/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.usersession.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.sso.admin.Domain;
import com.vmware.vim.binding.sso.admin.IdentitySource;
import com.vmware.vim.binding.sso.admin.IdentitySourceManagementService;
import com.vmware.vim.binding.vim.HostServiceTicket;
import com.vmware.vim.binding.vim.InternalServiceInstanceContent;
import com.vmware.vim.binding.vim.NfcService;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.store.PersistenceServerScopeProvider;
import com.vmware.vise.usersession.PingService;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSession;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.BlockingUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.service.ServiceRegistry;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vsphere.client.security.util.Util;
import com.vmware.vsphere.client.usersession.CloneSessionInfo;
import com.vmware.vsphere.client.usersession.SessionStartResult;
import com.vmware.vsphere.client.usersession.UserSessionEx;
import com.vmware.vsphere.client.usersession.UserSessionInfo;
import com.vmware.vsphere.client.usersession.UserSessionSSODomainInfo;
import com.vmware.vsphere.client.usersession.UserSessionServerInfo;
import com.vmware.vsphere.client.usersession.UserSessionServiceInternal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserSessionServiceImpl
implements UserSessionServiceInternal,
PersistenceServerScopeProvider {
    private static final Log _logger = LogFactory.getLog(UserSessionServiceImpl.class);
    private static final String CLIENT_OBJECT_TYPE = "vsphere:client";
    private final DataService _dataService;
    private final ServiceRegistry _serviceRegistry;
    private final SsoServiceManager _ssoServiceManager;
    private final boolean _h5ClientMode;
    private volatile String[] _systemDomains = null;

    public UserSessionServiceImpl(@Nonnull DataService dataService, @Nonnull ServiceRegistry serviceRegistry, @Nonnull SsoServiceManager ssoServiceManager, boolean bl) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataService, serviceRegistry, ssoServiceManager});
        this._dataService = dataService;
        this._serviceRegistry = serviceRegistry;
        this._ssoServiceManager = ssoServiceManager;
        this._h5ClientMode = bl;
    }

    public UserSession getUserSession() {
        try {
            _logger.debug((Object)"getUserSession:begin");
            UserSession userSession = Util.getUserSession();
            if (userSession == null) {
                return null;
            }
            UserSessionEx userSessionEx = new UserSessionEx(userSession);
            HttpSession httpSession = SessionUtil.getHttpSession();
            userSessionEx.hashedClientId = SessionUtil.getHashedClientId((String)userSessionEx.clientId);
            userSessionEx.linkedServersInfo = this.getLinkedServerInfos();
            userSessionEx.serversInfo = this.getServerInfos();
            _logger.debug((Object)"getUserSession:getServerInfos");
            if (!this._h5ClientMode) {
                userSessionEx.clientRef = this.getClientRef();
            }
            _logger.debug((Object)"getUserSession:getClientRef");
            SamlToken samlToken = AuthSessionUtil.getSsoToken((HttpSession)httpSession);
            if (samlToken != null) {
                Set set = SsoUtil.getGroups((SamlToken)samlToken);
                userSessionEx.groups = set.toArray(StringUtil.EMPTY_STRING_ARR);
                userSessionEx.systemDomains = this.getSystemDomains();
            }
            _logger.debug((Object)"getUserSession:done");
            return userSessionEx;
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to get the user session", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getSystemDomains() {
        String[] stringArray = this._systemDomains;
        if (stringArray == null) {
            UserSessionServiceImpl userSessionServiceImpl = this;
            synchronized (userSessionServiceImpl) {
                stringArray = this._systemDomains;
                if (stringArray == null) {
                    stringArray = this.extractSystemDomains();
                    this._systemDomains = stringArray;
                }
            }
        }
        return stringArray;
    }

    private String[] extractSystemDomains() {
        HashSet<String> hashSet = new HashSet<String>();
        _logger.debug((Object)"Retrieving list of system domains.");
        try {
            Domain[] domainArray;
            SsoAdminService ssoAdminService = this._ssoServiceManager.getSolutionAdminService(null, SsoDomain.getLocal());
            IdentitySourceManagementService identitySourceManagementService = ssoAdminService.getIdentitySourceManagementService();
            IdentitySource identitySource = identitySourceManagementService.get().getSystem();
            for (Domain domain : domainArray = identitySource.getDomains()) {
                String string = domain.getName();
                String string2 = domain.getAlias();
                if (!StringUtil.isNullOrEmpty((String)string)) {
                    _logger.debug((Object)("Identified a system domain by the name of '" + string + "'"));
                    hashSet.add(string);
                }
                if (StringUtil.isNullOrEmpty((String)string2)) continue;
                _logger.debug((Object)("Identified a system domain by the alias of '" + string + "'"));
                hashSet.add(string2);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"There was an issue while extracting the list of system domains", (Throwable)exception);
        }
        return hashSet.toArray(StringUtil.EMPTY_STRING_ARR);
    }

    @Override
    public UserSessionInfo getUserSessionInfo() {
        UserSession userSession = Util.getUserSession();
        if (userSession == null) {
            return null;
        }
        UserSessionInfo userSessionInfo = new UserSessionInfo();
        userSessionInfo.userName = userSession.userName;
        userSessionInfo.locale = userSession.locale;
        userSessionInfo.clientId = userSession.clientId;
        userSessionInfo.hashedClientId = SessionUtil.getHashedClientId((String)userSession.clientId);
        return userSessionInfo;
    }

    @Override
    public UserSessionServerInfo getUserSessionServerInfo() {
        UserSession userSession = Util.getUserSession();
        if (userSession == null) {
            return null;
        }
        UserSessionServerInfo userSessionServerInfo = new UserSessionServerInfo();
        userSessionServerInfo.linkedServersInfo = this.getLinkedServerInfos();
        userSessionServerInfo.serversInfo = this.getServerInfos();
        return userSessionServerInfo;
    }

    @Override
    public UserSessionSSODomainInfo getUserSessionSSODomainInfo() {
        HttpSession httpSession = SessionUtil.getHttpSession();
        SamlToken samlToken = AuthSessionUtil.getSsoToken((SsoDomain)SsoDomain.getLocal(), (HttpSession)httpSession);
        if (samlToken != null) {
            Set set = SsoUtil.getGroups((SamlToken)samlToken);
            UserSessionSSODomainInfo userSessionSSODomainInfo = new UserSessionSSODomainInfo();
            userSessionSSODomainInfo.groups = set.toArray(StringUtil.EMPTY_STRING_ARR);
            userSessionSSODomainInfo.systemDomains = this.getSystemDomains();
            return userSessionSSODomainInfo;
        }
        return null;
    }

    @Override
    public SessionStartResult initSession() {
        SessionStartResult sessionStartResult = new SessionStartResult();
        HttpSession httpSession = SessionUtil.getHttpSession();
        String string = SessionUtil.getHashedSessionId((HttpSession)httpSession);
        _logger.debug((Object)("Initializing user session for: " + string));
        CountDownLatch countDownLatch = SessionUtil.getSessionMonitor((HttpSession)httpSession);
        _logger.debug((Object)("Beginning wait for session initialization monitor: " + string));
        BlockingUtil.awaitUninterruptibly((CountDownLatch)countDownLatch);
        _logger.debug((Object)("Session has been initialized: " + string));
        List list = (List)SessionUtil.getData((String)"sessionError", (HttpSession)httpSession);
        if (list != null) {
            ArrayList<MethodFault> arrayList = new ArrayList<MethodFault>();
            for (Throwable throwable : list) {
                MethodFault methodFault = MixedUtil.getMethodFault((Throwable)throwable);
                arrayList.add(methodFault);
            }
            sessionStartResult.errors = arrayList.toArray(new MethodFault[0]);
        }
        sessionStartResult.userSession = this.getUserSession();
        return sessionStartResult;
    }

    @Override
    public CloneSessionInfo acquireCloneTicket(String string) throws Exception {
        String string2 = (String)SessionUtil.getData((String)"USER_NAME");
        if (StringUtil.isNullOrEmpty((String)string2)) {
            _logger.info((Object)"acquireCloneTicket called on an inactive session.");
            MixedUtil.throwNotAuthenticatedError(null);
        }
        VcService vcService = VimSessionUtil.getService((String)string);
        ManagedObjectReference managedObjectReference = vcService.getServiceInstanceContent().sessionManager;
        SessionManager sessionManager = (SessionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
        String string3 = sessionManager.acquireCloneTicket();
        CloneSessionInfo cloneSessionInfo = new CloneSessionInfo();
        ServerInfoEx serverInfoEx = VcServiceUtil.toServerInfoEx((VcService)vcService);
        cloneSessionInfo.setServerInfo((ServerInfo)serverInfoEx);
        cloneSessionInfo.setSessionTicket(string3);
        cloneSessionInfo.setUserName(string2);
        Locale locale = ResourceUtil.getLocale();
        if (locale != null) {
            cloneSessionInfo.setLocale(locale.toString());
        }
        return cloneSessionInfo;
    }

    @Override
    public HostServiceTicket acquireNfcSessionTicket(ManagedObjectReference managedObjectReference) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)managedObjectReference.getServerGuid());
        ServiceInstance serviceInstance = vcService.getServiceInstance();
        InternalServiceInstanceContent internalServiceInstanceContent = serviceInstance.retrieveInternalContent();
        NfcService nfcService = (NfcService)ManagedObjectUtil.getManagedObject((ManagedObjectReference)internalServiceInstanceContent.getNfcService());
        HostServiceTicket hostServiceTicket = nfcService.fileManagement(managedObjectReference, null);
        return hostServiceTicket;
    }

    public List<String> getServerGuids() {
        ServerInfo[] serverInfoArray = this.getServerInfos();
        if (serverInfoArray == null || serverInfoArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(serverInfoArray.length);
        for (ServerInfo serverInfo : serverInfoArray) {
            String string = serverInfo.serviceGuid;
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public void ping() {
        LinkedVcGroupRegistry linkedVcGroupRegistry;
        try {
            _logger.info((Object)"Initiating ping request.");
            linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
            for (LinkedVcGroup object : linkedVcGroupRegistry.getLinkedVcGroups()) {
                for (VcService vcService : object.getVcServices()) {
                    try {
                        _logger.info((Object)("Pinging vc service - " + vcService.getServiceUrl()));
                        vcService.getServiceInstance().currentTime();
                    }
                    catch (Exception exception) {
                        _logger.warn((Object)("Ping failed on vc service - " + vcService.getServiceUrl()), (Throwable)exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            _logger.debug((Object)"Exception thrown on ping", (Throwable)exception);
        }
        linkedVcGroupRegistry = this.getUserSession();
        List list = this._serviceRegistry.getServices(PingService.class.getName());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PingService pingService = (PingService)iterator.next();
            String string = pingService.getClass().getName();
            try {
                _logger.info((Object)("Pinging service - " + string));
                pingService.ping((UserSession)linkedVcGroupRegistry);
            }
            catch (Exception exception) {
                _logger.error((Object)("Ping failed on service - " + string), (Throwable)exception);
            }
        }
    }

    @Override
    public void sessionPing() {
        _logger.debug((Object)"Session request.");
    }

    private ServerInfo[][] getLinkedServerInfos() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        for (LinkedVcGroup object : linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups()) {
            ArrayList<ServerInfo> arrayList2 = new ArrayList<ServerInfo>();
            for (ServiceEndpointEx serviceEndpointEx : object.getServiceEndPoints()) {
                if (!serviceEndpointEx.getProtocol().equals(ServiceDirectory.ServiceProtocol.vimApi.name())) continue;
                ServerInfo serverInfo = this.createServerInfo((ServiceDirectory.ServiceEndpoint)serviceEndpointEx);
                arrayList2.add(serverInfo);
            }
            arrayList.add(ArrayUtil.toArray(arrayList2, ServerInfo.class));
        }
        List list = (List)SessionUtil.getData((String)"SERVER_INFO");
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ServerInfo serverInfo = (ServerInfo)iterator.next();
                ArrayList<ServerInfo> arrayList3 = new ArrayList<ServerInfo>();
                arrayList3.add(serverInfo);
                arrayList.add(ArrayUtil.toArray(arrayList3, ServerInfo.class));
            }
        }
        return (ServerInfo[][])arrayList.toArray((T[])new ServerInfo[0][]);
    }

    private ServerInfo[] getServerInfos() {
        ArrayList<ServerInfo> arrayList = new ArrayList<ServerInfo>();
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups()) {
            for (ServiceEndpointEx serviceEndpointEx : linkedVcGroup.getServiceEndPoints()) {
                if (!serviceEndpointEx.getProtocol().equals(ServiceDirectory.ServiceProtocol.vimApi.name())) continue;
                ServerInfo serverInfo = this.createServerInfo((ServiceDirectory.ServiceEndpoint)serviceEndpointEx);
                arrayList.add(serverInfo);
            }
        }
        List list = (List)SessionUtil.getData((String)"SERVER_INFO");
        if (list != null) {
            arrayList.addAll(list);
        }
        return arrayList.toArray(new ServerInfo[0]);
    }

    private ServerInfo createServerInfo(ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        VcService vcService = VimSessionUtil.getService((String)serviceEndpoint.instanceUuid);
        ServerInfoEx serverInfoEx = null;
        if (vcService == null) {
            serverInfoEx = new ServerInfoEx();
            serverInfoEx.serviceGuid = serviceEndpoint.instanceUuid;
            serverInfoEx.serviceUrl = serviceEndpoint.url;
            serverInfoEx.thumbprint = serviceEndpoint.sslThumbprint;
            serverInfoEx.errorCode = "connectError";
        } else {
            serverInfoEx = VcServiceUtil.toServerInfoEx((VcService)vcService, (ServiceDirectory.ServiceEndpoint)serviceEndpoint);
        }
        return serverInfoEx;
    }

    private Object getClientRef() {
        Constraint constraint = new Constraint();
        constraint.targetType = CLIENT_OBJECT_TYPE;
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{"id"});
        try {
            ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
            if (resultSet == null || resultSet.items == null || resultSet.items.length == 0) {
                return null;
            }
            return resultSet.items[0].resourceObject;
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            return null;
        }
    }
}

