/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.compatibility.impl;

import com.vmware.vise.util.Version;

class VersionInterval {
    private static final Version MIN_VERSION = new Version("0");
    private static final Version MAX_VERSION = new Version("10000");
    private Endpoint _minEndpoint;
    private Endpoint _maxEndpoint;

    public VersionInterval(String string, String string2) {
        this.init(string, string2);
    }

    public boolean contains(Version version) {
        if (version == null) {
            return this._minEndpoint.value == MIN_VERSION && this._maxEndpoint.value == MAX_VERSION;
        }
        int n = version.compareTo(this._minEndpoint.value);
        int n2 = version.compareTo(this._maxEndpoint.value);
        if (n < 0 || n2 > 0) {
            return false;
        }
        if (n == 0 && !this._minEndpoint.isInclusive) {
            return false;
        }
        return n2 != 0 || this._maxEndpoint.isInclusive;
    }

    private void init(String string, String string2) {
        if (string == null || string.isEmpty()) {
            this._minEndpoint = new Endpoint(MIN_VERSION, true);
        } else {
            this._minEndpoint = VersionInterval.parseIntervalEndpoint(string);
            if (this._minEndpoint.value == null) {
                this._minEndpoint.value = MIN_VERSION;
                this._minEndpoint.isInclusive = true;
            }
        }
        if (string2 == null || string2.isEmpty()) {
            this._maxEndpoint = new Endpoint(MAX_VERSION, true);
        } else {
            this._maxEndpoint = VersionInterval.parseIntervalEndpoint(string2);
            if (this._maxEndpoint.value == null) {
                this._maxEndpoint.value = MAX_VERSION;
                this._maxEndpoint.isInclusive = true;
            }
        }
    }

    private static Endpoint parseIntervalEndpoint(String string) {
        Endpoint endpoint = new Endpoint();
        if (string.startsWith("[")) {
            endpoint.isInclusive = true;
            String string2 = string.substring(1);
            endpoint.value = string2.isEmpty() ? null : new Version(string2);
            return endpoint;
        }
        if (string.endsWith("]")) {
            endpoint.isInclusive = true;
            String string3 = string.substring(0, string.length() - 1);
            endpoint.value = string3.isEmpty() ? null : new Version(string3);
            return endpoint;
        }
        if (string.startsWith("(")) {
            endpoint.isInclusive = false;
            String string4 = string.substring(1);
            endpoint.value = string4.isEmpty() ? null : new Version(string4);
            return endpoint;
        }
        if (string.endsWith(")")) {
            endpoint.isInclusive = false;
            String string5 = string.substring(0, string.length() - 1);
            endpoint.value = string5.isEmpty() ? null : new Version(string5);
            return endpoint;
        }
        endpoint.isInclusive = true;
        endpoint.value = new Version(string);
        return endpoint;
    }

    private static class Endpoint {
        public boolean isInclusive = false;
        public Version value;

        public Endpoint() {
        }

        public Endpoint(Version version, boolean bl) {
            this.value = version;
            this.isInclusive = bl;
        }
    }
}

