/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.task.TaskExecutor;

public class CorePluginsDeploymentActivator {
    protected static final String PACKAGES_FOLDER_NAME = "plugin-packages";
    private static final Log _logger = LogFactory.getLog(CorePluginsDeploymentActivator.class);
    private final TaskExecutor _executor;
    private final ExtensionService _extensionService;
    private final File _statusFile;

    public CorePluginsDeploymentActivator(@Nonnull TaskExecutor taskExecutor, @Nonnull ExtensionService extensionService, @Nullable File file) {
        this._executor = taskExecutor;
        this._extensionService = extensionService;
        this._statusFile = file;
        this.cleanupStatusFile();
    }

    public void deploy(final @Nonnull Callback callback) {
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                CorePluginsDeploymentActivator.this.deployInternal();
                callback.deployCompleted();
            }
        });
    }

    protected File getPackagesDir() {
        URL uRL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        File file = this.urlToFile(uRL);
        if (file == null) {
            return null;
        }
        File file2 = file;
        while (file2 != null && (file2 = file2.getParentFile()) != null) {
            File file3 = new File(file2, PACKAGES_FOLDER_NAME);
            if (!file3.exists() || !file3.isDirectory()) continue;
            return file3;
        }
        _logger.warn((Object)"Plugin package directory not found.");
        return null;
    }

    private void deployInternal() {
        File file = this.getPackagesDir();
        if (file != null) {
            this.deployPluginsFromDir(file);
        }
        this.writeStatusFile();
    }

    private File urlToFile(URL uRL) {
        File file;
        block5: {
            file = null;
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                String string = uRL.toString();
                if (string.contains(" ")) {
                    string = string.replace(" ", "%20");
                    try {
                        file = new File(new URI(string));
                    }
                    catch (URISyntaxException uRISyntaxException2) {
                        // empty catch block
                    }
                }
                if (file != null) break block5;
                _logger.error((Object)"Could not compute jar file", (Throwable)uRISyntaxException);
            }
        }
        return file;
    }

    private void deployPluginsFromDir(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            ArrayList<PluginPackageInfo> arrayList = new ArrayList<PluginPackageInfo>(fileArray.length);
            for (File file2 : fileArray) {
                if (!Files.isDirectory(file2.toPath(), new LinkOption[0])) continue;
                PluginPackageInfo pluginPackageInfo = new PluginPackageInfo(file2);
                arrayList.add(pluginPackageInfo);
            }
            Serializable[] serializableArray = arrayList.toArray(new PluginPackageInfo[arrayList.size()]);
            try {
                this._extensionService.addPluginPackages((PluginPackageInfo[])serializableArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void cleanupStatusFile() {
        if (this._statusFile != null && this._statusFile.exists()) {
            this._statusFile.delete();
        }
    }

    private void writeStatusFile() {
        try {
            if (this._statusFile != null) {
                this._statusFile.createNewFile();
                this._statusFile.deleteOnExit();
            }
        }
        catch (IOException iOException) {
            _logger.error((Object)("Could not create the status file " + this._statusFile));
        }
    }

    public static interface Callback {
        public void deployCompleted();
    }
}

