/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.extensionfw.BundleDeployer;
import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.BundleLifeCycleListener;
import com.vmware.vise.extensionfw.impl.DeploymentEventLogger;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.BlockingUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.virgo.nano.deployer.api.core.ApplicationDeployer;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions;

public class DirectApiBundleDeployer
implements BundleDeployer {
    private static final Log _logger = LogFactory.getLog(DirectApiBundleDeployer.class);
    private final DeploymentEventLogger _eventLogger;
    private final ApplicationDeployer _applicationDeployer;
    private final BundleLifeCycleListener _bundleLifeCycleListener;
    private final int _bundleDeployTimeoutS;
    private final Object _deployLock = new Object();

    public DirectApiBundleDeployer(ApplicationDeployer applicationDeployer, BundleLifeCycleListener bundleLifeCycleListener, int n, DeploymentEventLogger deploymentEventLogger) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{applicationDeployer, bundleLifeCycleListener, deploymentEventLogger});
        this._applicationDeployer = applicationDeployer;
        this._bundleLifeCycleListener = bundleLifeCycleListener;
        this._bundleDeployTimeoutS = n;
        this._eventLogger = deploymentEventLogger;
    }

    @Override
    public void deploy(List<BundleInfo> list) throws Exception {
        Collection<CountDownLatch> collection = this.enqueueBundlesForDeployment(list);
        List<Exception> list2 = this.waitForBundlesStart(collection);
        this.throwOnDeploymentError(list, list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<CountDownLatch> enqueueBundlesForDeployment(List<BundleInfo> list) throws DeploymentException {
        ArrayList<CountDownLatch> arrayList = new ArrayList<CountDownLatch>();
        for (BundleInfo bundleInfo : list) {
            if (bundleInfo == null || bundleInfo.getLocation() == null) continue;
            this._eventLogger.info(DeploymentEventLogger.Event.ARTIFACT_ENQUEUE_BEGIN, bundleInfo.getId(), bundleInfo.getVersion());
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)String.format("Enqueuing " + bundleInfo.toString(), new Object[0]));
            }
            arrayList.add(this._bundleLifeCycleListener.getBundleDeployedLatch(bundleInfo));
            DeploymentOptions deploymentOptions = new DeploymentOptions(false, false, false);
            Object object = this._deployLock;
            synchronized (object) {
                this._applicationDeployer.deploy(bundleInfo.getLocation().toURI(), deploymentOptions);
            }
            this._eventLogger.info(DeploymentEventLogger.Event.ARTIFACT_ENQUEUE_END, bundleInfo.getId(), bundleInfo.getVersion());
        }
        return arrayList;
    }

    private List<Exception> waitForBundlesStart(Collection<CountDownLatch> collection) {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        for (CountDownLatch countDownLatch : collection) {
            if (BlockingUtil.await((CountDownLatch)countDownLatch, (long)this._bundleDeployTimeoutS, (TimeUnit)TimeUnit.SECONDS)) continue;
            arrayList.add(new Exception("Timed out waiting for a bundle to start."));
        }
        return arrayList;
    }

    private void throwOnDeploymentError(List<BundleInfo> list, List<Exception> list2) throws CompositeException, Exception {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        arrayList.addAll(list2);
        arrayList.addAll(this._bundleLifeCycleListener.getDeployErrors(list));
        if (arrayList.size() > 1) {
            throw new CompositeException(arrayList);
        }
        if (arrayList.size() == 1) {
            throw (Exception)arrayList.get(0);
        }
    }

    @Override
    public void undeploy(List<BundleInfo> list) throws Exception {
        for (BundleInfo bundleInfo : list) {
            if (bundleInfo == null) continue;
            this._eventLogger.info(DeploymentEventLogger.Event.ARTIFACT_UNDEPLOY_BEGIN, bundleInfo.getId(), bundleInfo.getVersion());
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)String.format("Undeploying " + bundleInfo.toString(), new Object[0]));
            }
            URI uRI = bundleInfo.getLocation().toURI();
            DeploymentIdentity deploymentIdentity = this._applicationDeployer.getDeploymentIdentity(uRI);
            this._applicationDeployer.undeploy(deploymentIdentity, true);
            this._eventLogger.info(DeploymentEventLogger.Event.ARTIFACT_UNDEPLOY_END, bundleInfo.getId(), bundleInfo.getVersion());
        }
    }
}

