/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.ApplicationStartupMonitor;
import com.vmware.vise.extensionfw.ExtensionManager;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.impl.CorePluginsDeploymentActivator;
import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ExtensionBundleActivator
implements EventHandler,
ApplicationStartupMonitor {
    public static final String USER_REGION_EVENT = "org/eclipse/virgo/kernel/userregion/userartifacts/DEPLOYED";
    public static final String ASYNC_DEPLOYMENT_ENABLED_PROP = "newPlugins.deployAsync.enabled";
    private static final Log _logger = LogFactory.getLog(ExtensionBundleActivator.class);
    private final long _startMillis;
    private final CorePluginsDeploymentActivator _corePluginsDeploymentActivator;
    private final ExtensionService _extensionService;
    private final CountDownLatch _corePluginsDeployed;
    private final CountDownLatch _initialPluginsDeployed;
    private final boolean _asyncDeploymentEnabled;
    private static final String SOLUTION_MENUS_EXT_POINT = "vise.menus.context.solutionMenus";
    private static final String CONTEXT_MENUS_EXT_POINT = "vise.menus.context";
    private static final String ACTIONS_EXT_POINT = "vise.actions.specs";
    private static final String OBJECT_NAVIGATOR_EXT_POINT = "vise.navigator.nodespecs";

    public ExtensionBundleActivator(@Nonnull CorePluginsDeploymentActivator corePluginsDeploymentActivator, @Nonnull ExtensionService extensionService, @Nonnull ConfigurationService configurationService) {
        this._corePluginsDeploymentActivator = corePluginsDeploymentActivator;
        this._extensionService = extensionService;
        ValidationUtil.notNull((Object)this._corePluginsDeploymentActivator);
        ValidationUtil.notNull((Object)this._extensionService);
        this._corePluginsDeployed = new CountDownLatch(1);
        this._initialPluginsDeployed = new CountDownLatch(1);
        this._startMillis = System.currentTimeMillis();
        this._asyncDeploymentEnabled = Boolean.parseBoolean(configurationService.getProperty(ASYNC_DEPLOYMENT_ENABLED_PROP));
    }

    public void handleEvent(Event event) {
        if (event == null || !USER_REGION_EVENT.equals(event.getTopic())) {
            _logger.warn((Object)("Unexpected event handled: " + event));
        } else {
            this._corePluginsDeploymentActivator.deploy(new CorePluginsDeploymentActivator.Callback(){

                @Override
                public void deployCompleted() {
                    long l = System.currentTimeMillis() - ExtensionBundleActivator.this._startMillis;
                    _logger.info((Object)String.format("Internal plugins deployment done in (ms): %d", l));
                    ExtensionBundleActivator.this._corePluginsDeployed.countDown();
                    if (ExtensionBundleActivator.this._asyncDeploymentEnabled) {
                        ExtensionBundleActivator.this._extensionService.deployNewPackages();
                    }
                    ExtensionBundleActivator.this.invokeExtensionParsing();
                    ExtensionBundleActivator.this._initialPluginsDeployed.countDown();
                }
            });
        }
    }

    @Override
    public void waitForCorePluginPackagesDeployment() throws InterruptedException {
        this._corePluginsDeployed.await();
    }

    @Override
    public void waitForPostServerStartupPluginPackagesDeployment() throws InterruptedException {
        this._initialPluginsDeployed.await();
    }

    private void invokeExtensionParsing() {
        ExtensionManager.getInstance().getAllCombinedExtensionPointInfos();
        if (BuildProperties.isH5Client()) {
            ExtensionManager.getInstance().getExtensionObjects(CONTEXT_MENUS_EXT_POINT, null, true);
            ExtensionManager.getInstance().getExtensionObjects(ACTIONS_EXT_POINT, null, true);
            ExtensionManager.getInstance().getExtensionObjects(SOLUTION_MENUS_EXT_POINT, null, true);
            ExtensionManager.getInstance().getExtensionObjects(OBJECT_NAVIGATOR_EXT_POINT, null, true);
        }
    }
}

