/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.ExtensionManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class ExtensionManagerBundleEventNotifier
implements BundleListener {
    private static final Log _logger = LogFactory.getLog(ExtensionManagerBundleEventNotifier.class);
    private static final String MANIFEST_FILE_URI = "/plugin.xml";

    public ExtensionManagerBundleEventNotifier(BundleContext bundleContext) {
        bundleContext.addBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle = bundleEvent.getBundle();
        int n = bundleEvent.getType();
        if (2 == n) {
            try {
                this.bundleStarted(bundle);
            }
            catch (IOException | RuntimeException exception) {
                _logger.error((Object)("Error from bundleStarted: " + bundle), (Throwable)exception);
            }
        } else if (4 == n) {
            this.bundleStopped(bundle);
        }
    }

    private void bundleStarted(Bundle bundle) throws IOException {
        BundleInfo bundleInfo = this.getBundleInfo(bundle);
        URL uRL = bundle.getEntry(MANIFEST_FILE_URI);
        ExtensionManager.getInstance().bundleStarted(bundleInfo, uRL);
    }

    private void bundleStopped(Bundle bundle) {
        BundleInfo bundleInfo = this.getBundleInfo(bundle);
        ExtensionManager.getInstance().bundleStopped(bundleInfo);
    }

    private BundleInfo getBundleInfo(Bundle bundle) {
        Dictionary dictionary = bundle.getHeaders();
        String string = (String)dictionary.get("Bundle-SymbolicName");
        String string2 = (String)dictionary.get("Bundle-Version");
        String string3 = (String)dictionary.get("Module-Scope");
        String string4 = (String)dictionary.get("Web-ContextPath");
        File file = new File(bundle.getLocation());
        String string5 = (String)dictionary.get("Export-Package");
        String string6 = (String)dictionary.get("Import-Package");
        BundleInfo bundleInfo = new BundleInfo(string, string2, string4, file, string3, string5, string6);
        return bundleInfo;
    }
}

