/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.service.ClassLoaderService;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtensionMetadataParser {
    private static final Log _logger = LogFactory.getLog(ExtensionMetadataParser.class);
    private static final LoadingCache<Class, JAXBContext> JAXB_CONTEXT_CACHE = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<Class, JAXBContext>(){

        public JAXBContext load(Class clazz) throws JAXBException {
            return JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
    });

    public static void parse(ClassLoaderService classLoaderService, ExtensionInfo[] extensionInfoArray, Map<String, PropertyInfo> map) {
        for (ExtensionInfo extensionInfo : extensionInfoArray) {
            if (extensionInfo.getMetadata() != null || StringUtil.isNullOrEmpty((String)extensionInfo.getMetadataXmlStr())) continue;
            ExtensionMetadataParser.parse(classLoaderService, extensionInfo, map);
        }
    }

    public static void invalidateCache() {
        JAXB_CONTEXT_CACHE.invalidateAll();
    }

    private static void parse(ClassLoaderService classLoaderService, ExtensionInfo extensionInfo, Map<String, PropertyInfo> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Document document = XMLUtil.parseXml((String)extensionInfo.getMetadataXmlStr());
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String string = element.getNodeName();
            String string2 = node.getTextContent();
            Object object = string2;
            if (map.containsKey(string)) {
                PropertyInfo propertyInfo = map.get(string);
                if (propertyInfo.type.equals(Boolean.class.getName())) {
                    object = Boolean.parseBoolean(string2);
                    hashMap.put(string, object);
                } else if (!propertyInfo.type.equals(String.class.getName())) {
                    if (propertyInfo.type.equals(Integer.class.getName())) {
                        object = Integer.parseInt(string2);
                        hashMap.put(string, object);
                    } else if (propertyInfo.type.equals(Long.class.getName())) {
                        object = Long.parseLong(string2);
                        hashMap.put(string, object);
                    } else if (propertyInfo.type.equals(Float.class.getName())) {
                        object = Float.valueOf(Float.parseFloat(string2));
                        hashMap.put(string, object);
                    } else if (propertyInfo.type.equals(Double.class.getName())) {
                        object = Double.parseDouble(string2);
                        hashMap.put(string, object);
                    } else {
                        String string3 = "<" + propertyInfo.name + ">";
                        String string4 = "</" + propertyInfo.name + ">";
                        int n2 = extensionInfo.getMetadataXmlStr().indexOf(string3) + string3.length();
                        int n3 = extensionInfo.getMetadataXmlStr().indexOf(string4);
                        string2 = extensionInfo.getMetadataXmlStr().substring(n2, n3);
                        object = ExtensionMetadataParser.deserializeComplexMetadata(classLoaderService, extensionInfo, propertyInfo, string2);
                    }
                }
            }
            hashMap.put(string, object);
        }
        extensionInfo.setMetadata(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserializeComplexMetadata(ClassLoaderService classLoaderService, ExtensionInfo extensionInfo, PropertyInfo propertyInfo, String string) {
        try (StringReader stringReader = null;){
            Object object;
            stringReader = new StringReader(string);
            Class clazz = classLoaderService.loadClass(propertyInfo.type);
            JAXBContext jAXBContext = (JAXBContext)JAXB_CONTEXT_CACHE.get((Object)clazz);
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            Object object2 = object = unmarshaller.unmarshal((Source)new StreamSource(stringReader));
            return object2;
        }
    }
}

