/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.concurrent.LoggingRejectedExecutionHandler;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Filterer {
    private static final Log _logger = LogFactory.getLog(Filterer.class);
    private static final String POOL_NAME = "extfw-filterer-pool";
    private static final RejectedExecutionHandler HANDLER = new LoggingRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy(), "extfw-filterer-pool");
    private static final ExecutorService EXECUTOR = ThreadPoolFactory.newFlexibleThreadPool((int)0, (int)10, (ThreadFactory)new WorkerThreadFactory("extfw-filterer-pool"), (RejectedExecutionHandler)HANDLER);
    private final boolean _runsInstantFiltersOnly;

    public Filterer(boolean bl) {
        this._runsInstantFiltersOnly = bl;
    }

    public List<ExtensionInfo> filter(List<ExtensionInfo> list, Map<String, Object> map, List<ExtensionObjectFilter> list2) {
        int n = list2.size();
        if (n == 0) {
            return list;
        }
        HashSet<ExtensionInfo> hashSet = new HashSet<ExtensionInfo>();
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>(n);
        for (ExtensionObjectFilter extensionObjectFilter : list2) {
            List<ExtensionInfo> list3;
            if (this.shouldSkipFilter(extensionObjectFilter) || (list3 = this.getFilterableExtensionInfos(extensionObjectFilter, list, map, hashSet)) == null || list3.size() == 0) continue;
            Runnable runnable = this.createFilterRunTask(extensionObjectFilter, list3, map, hashSet);
            arrayList.add(runnable);
        }
        if (arrayList.size() > 0) {
            try {
                ExecutorUtil.executeTasks(arrayList, (Executor)EXECUTOR);
            }
            catch (InterruptedException interruptedException) {
                _logger.error((Object)"Error when executing extension object filtering tasks.", (Throwable)interruptedException);
            }
        }
        List<ExtensionInfo> list4 = this.getResultExtensionInfos(list, hashSet);
        return list4;
    }

    public FilterResult filterExtensions(List<ExtensionInfo> list, Map<String, Object> map, List<ExtensionObjectFilter> list2) {
        FilterResult filterResult = new FilterResult();
        if (list2.isEmpty()) {
            filterResult.extensionInfos = list;
            return filterResult;
        }
        int n = list2.size();
        HashSet<ExtensionInfo> hashSet = new HashSet<ExtensionInfo>();
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>(n);
        for (ExtensionObjectFilter extensionObjectFilter : list2) {
            List<ExtensionInfo> list3;
            if (this.shouldSkipFilter(extensionObjectFilter) || (list3 = this.getFilterableExtensionInfos(extensionObjectFilter, list, map, hashSet)).isEmpty()) continue;
            filterResult.executedFilters.add(extensionObjectFilter);
            Runnable runnable = this.createFilterRunTask(extensionObjectFilter, list3, map, hashSet);
            arrayList.add(runnable);
        }
        if (arrayList.size() > 0) {
            try {
                ExecutorUtil.executeTasks(arrayList, (Executor)EXECUTOR);
            }
            catch (InterruptedException interruptedException) {
                _logger.error((Object)"Error when executing extension object filtering tasks.", (Throwable)interruptedException);
            }
        }
        filterResult.extensionInfos = this.getResultExtensionInfos(list, hashSet);
        return filterResult;
    }

    private boolean shouldSkipFilter(ExtensionObjectFilter extensionObjectFilter) {
        return this._runsInstantFiltersOnly && !extensionObjectFilter.returnsInstantly() || !this._runsInstantFiltersOnly && extensionObjectFilter.returnsInstantly();
    }

    private Runnable createFilterRunTask(final ExtensionObjectFilter extensionObjectFilter, final List<ExtensionInfo> list, final Map<String, Object> map, final Set<ExtensionInfo> set) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<ExtensionInfo> list2 = extensionObjectFilter.apply(list, map);
                if (list.size() != list2.size()) {
                    for (ExtensionInfo extensionInfo : list) {
                        if (list2.indexOf(extensionInfo) == -1) {
                            Set set2 = set;
                            synchronized (set2) {
                                set.add(extensionInfo);
                            }
                            _logger.debug((Object)String.format("The extension %1s is filtered out by filter %2s", extensionInfo.getId(), extensionObjectFilter.getClass().getName()));
                            continue;
                        }
                        _logger.debug((Object)String.format("The extension %1s passed filter %2s", extensionInfo.getId(), extensionObjectFilter.getClass().getName()));
                    }
                }
            }
        };
        return runnable;
    }

    private List<ExtensionInfo> getFilterableExtensionInfos(ExtensionObjectFilter extensionObjectFilter, List<ExtensionInfo> list, Map<String, Object> map, Set<ExtensionInfo> set) {
        boolean bl = this.isValidContextForFilter(extensionObjectFilter, map);
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extensionInfo : list) {
            if (set.contains(extensionInfo) || !this.isValidExtensionForFilter(extensionInfo, extensionObjectFilter)) continue;
            if (bl) {
                arrayList.add(extensionInfo);
                continue;
            }
            if (extensionObjectFilter.getFilterProperties() == null) continue;
            set.add(extensionInfo);
        }
        return arrayList;
    }

    private boolean isValidExtensionForFilter(ExtensionInfo extensionInfo, ExtensionObjectFilter extensionObjectFilter) {
        if (extensionObjectFilter.getFilterProperties() == null) {
            return true;
        }
        for (PropertyInfo propertyInfo : extensionObjectFilter.getFilterProperties()) {
            if (extensionInfo.getMetadata() != null && extensionInfo.getMetadata().containsKey(propertyInfo.name) || propertyInfo.optional.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean isValidContextForFilter(ExtensionObjectFilter extensionObjectFilter, Map<String, Object> map) {
        if (extensionObjectFilter.getContextProperties() == null) {
            return true;
        }
        for (PropertyInfo propertyInfo : extensionObjectFilter.getContextProperties()) {
            if (map == null || !map.containsKey(propertyInfo.name)) {
                if (propertyInfo.optional.booleanValue()) continue;
                return false;
            }
            Object object = map.get(propertyInfo.name);
            if (this.isValidPropertyValue(object, propertyInfo)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidPropertyValue(Object object, PropertyInfo propertyInfo) {
        if (object == null || propertyInfo.type == null) {
            return true;
        }
        String string = object.getClass().getName();
        return string != null && string.equals(propertyInfo.type);
    }

    private List<ExtensionInfo> getResultExtensionInfos(List<ExtensionInfo> list, Set<ExtensionInfo> set) {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        int n = 0;
        for (ExtensionInfo extensionInfo : list) {
            if (set.contains(extensionInfo)) continue;
            arrayList.add(n++, extensionInfo);
        }
        return arrayList;
    }

    public static class FilterResult {
        public List<ExtensionInfo> extensionInfos = new ArrayList<ExtensionInfo>();
        public List<ExtensionObjectFilter> executedFilters = new ArrayList<ExtensionObjectFilter>();
    }
}

