/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.OsgiUsageValidationListener;
import com.vmware.vise.extensionfw.impl.OsgiUsageValidationCheck;
import com.vmware.vise.extensionfw.impl.PackageDeployData;
import com.vmware.vise.extensionfw.impl.PluginMetadataLookupImpl;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;

public class OsgiUsageValidationService {
    private static final Log _logger = LogFactory.getLog(OsgiUsageValidationService.class);
    private static final Log _medicLogger = LogFactory.getLog((String)"osgiUsageValidator.Logger");
    private static final String FIRST_PARTY_VALIDATION_PROPERTY = "validateFirstPartyPlugins";
    private static final String FIRST_PARTY_VALIDATION_ENABLED = "true";
    private static final Set<String> _firstPartyPlugins = new HashSet<String>();
    private final ConfigurationService _configService;
    private final OsgiUsageValidationListener _listener;
    private final ExecutorService _executor;
    private final List<OsgiUsageValidationCheck> _validations;

    protected OsgiUsageValidationService(ConfigurationService configurationService, OsgiUsageValidationListener osgiUsageValidationListener, ExecutorService executorService, List<OsgiUsageValidationCheck> list) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{configurationService, osgiUsageValidationListener, executorService, list});
        this._configService = configurationService;
        this._listener = osgiUsageValidationListener;
        this._executor = executorService;
        this._validations = list;
    }

    public void validate(Collection<PackageDeployData> collection, Collection<PackageDeployData> collection2) {
        try {
            this._executor.execute(new OsgiUsageValidationTask(collection, collection2));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            _logger.error((Object)"Couldn't initiate validation of OSGi bad-practices.", (Throwable)rejectedExecutionException);
        }
    }

    private final boolean skipFirstPartyPluginValidation(IdVersionPair idVersionPair) {
        String string;
        try {
            string = this._configService.getProperty(FIRST_PARTY_VALIDATION_PROPERTY);
        }
        catch (Exception exception) {
            _logger.warn((Object)"Could not check validateFirstPartyPlugins property.", (Throwable)exception);
            string = null;
        }
        return !FIRST_PARTY_VALIDATION_ENABLED.equals(string) && _firstPartyPlugins.contains(idVersionPair.getId());
    }

    static {
        _firstPartyPlugins.add("com.vmware.ds");
        _firstPartyPlugins.add("com.vmware.license.client");
        _firstPartyPlugins.add("com.vmware.opsmgmt.client");
        _firstPartyPlugins.add("com.vmware.vsphere.client.srupload");
        _firstPartyPlugins.add("com.vmware.ssoadminui");
        _firstPartyPlugins.add("com.vmware.vsphere.client.telemetry");
        _firstPartyPlugins.add("com.vmware.vca.marketing.ngc.ui");
        _firstPartyPlugins.add("com.vmware.vco");
        _firstPartyPlugins.add("com.vmware.vsphere.client");
        _firstPartyPlugins.add("com.vmware.vsphere.client.modules");
        _firstPartyPlugins.add("com.vmware.vsphere.client.html");
    }

    private class OsgiUsageValidationTask
    implements Runnable {
        private static final String VALIDATION_START_MARKER = "==================================================";
        private static final String PLUGIN_PACKAGE_LOG_FIELD = "pluginPackage";
        private static final String VALIDATION_CHECK_LOG_FIELD = "validationCheck";
        private final Collection<PackageDeployData> _pluginPackagesToValidate;
        private final Collection<PackageDeployData> _deployedPluginPackages;

        public OsgiUsageValidationTask(Collection<PackageDeployData> collection, Collection<PackageDeployData> collection2) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{collection, collection2});
            this._pluginPackagesToValidate = collection;
            this._deployedPluginPackages = collection2;
        }

        @Override
        public void run() {
            _logger.info((Object)"Started validation of OSGi bad practices.");
            String string = MDC.get((String)PLUGIN_PACKAGE_LOG_FIELD);
            boolean bl = false;
            PluginMetadataLookupImpl pluginMetadataLookupImpl = new PluginMetadataLookupImpl(this._deployedPluginPackages);
            for (PackageDeployData packageDeployData : this._pluginPackagesToValidate) {
                IdVersionPair idVersionPair = packageDeployData.getPackageRef();
                if (idVersionPair == null || !pluginMetadataLookupImpl.isPluginDeployed(idVersionPair)) {
                    _logger.info((Object)("OSGi validation skipped for plugin package " + idVersionPair + ". It is not deployed."));
                    continue;
                }
                if (OsgiUsageValidationService.this.skipFirstPartyPluginValidation(idVersionPair)) {
                    _logger.debug((Object)("OSGi validation skipped for plugin package " + idVersionPair + ". It is a first party plugin."));
                    continue;
                }
                try {
                    if (!bl) {
                        MDC.put((String)PLUGIN_PACKAGE_LOG_FIELD, (String)VALIDATION_START_MARKER);
                        MDC.put((String)VALIDATION_CHECK_LOG_FIELD, (String)"");
                        _medicLogger.info((Object)"New validation of plugins started.");
                        bl = true;
                    }
                    String string2 = pluginMetadataLookupImpl.getPluginName(idVersionPair);
                    String string3 = pluginMetadataLookupImpl.getPluginVendor(idVersionPair);
                    String string4 = string2 + ", " + string3;
                    MDC.put((String)PLUGIN_PACKAGE_LOG_FIELD, (String)idVersionPair.toString());
                    MDC.put((String)VALIDATION_CHECK_LOG_FIELD, (String)"STARTED");
                    _medicLogger.info((Object)("Validating [" + string4 + "]"));
                    MDC.put((String)VALIDATION_CHECK_LOG_FIELD, (String)"-");
                    _logger.info((Object)("Started validating " + idVersionPair));
                    for (OsgiUsageValidationCheck osgiUsageValidationCheck : OsgiUsageValidationService.this._validations) {
                        String string5 = osgiUsageValidationCheck.getClass().getSimpleName();
                        try {
                            _logger.info((Object)("Begin " + string5 + " on " + idVersionPair));
                            osgiUsageValidationCheck.validate(idVersionPair, pluginMetadataLookupImpl, OsgiUsageValidationService.this._listener);
                            _logger.info((Object)("End " + string5 + " on " + idVersionPair));
                        }
                        catch (RuntimeException runtimeException) {
                            _medicLogger.error((Object)("Unexpected error while running " + string5 + ". Check main log for details."));
                            _logger.error((Object)("Error validating plugin " + idVersionPair.toString()), (Throwable)runtimeException);
                        }
                    }
                    MDC.put((String)VALIDATION_CHECK_LOG_FIELD, (String)"FINISHED");
                    _medicLogger.info((Object)("Validating [" + string4 + "]"));
                    _logger.info((Object)("Finished validating " + idVersionPair));
                }
                catch (RuntimeException runtimeException) {
                    _medicLogger.error((Object)"Unexpected error while validating plugin. Check main log for details.");
                    _logger.error((Object)("Error validating plugin " + idVersionPair.toString()), (Throwable)runtimeException);
                }
            }
            if (bl) {
                MDC.put((String)PLUGIN_PACKAGE_LOG_FIELD, (String)VALIDATION_START_MARKER);
                MDC.put((String)VALIDATION_CHECK_LOG_FIELD, (String)"");
                _medicLogger.info((Object)"Validation of all plugins finished.");
                MDC.put((String)PLUGIN_PACKAGE_LOG_FIELD, (String)string);
            }
            _logger.info((Object)"Finished validation of OSGi bad practices.");
        }
    }
}

