/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.impl.PackageManifest;
import com.vmware.vise.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class ParBuilder {
    private static final String PAR_EXTENSION = ".par";
    private static final String APPLICATION_SYMBOLIC_NAME = "Application-SymbolicName";
    private static final String APPLICATION_VERSION = "Application-Version";
    private static final String APPLICATION_NAME = "Application-Name";
    private static final String APPLICATION_DESCRIPTION = "Application-Description";

    public File build(PackageManifest packageManifest, File file) throws IOException {
        if (packageManifest == null || StringUtil.isNullOrEmpty((String)packageManifest.packageId) || StringUtil.isNullOrEmpty((String)packageManifest.version)) {
            throw new IllegalArgumentException("The plugin-package.xml should contain an  \"id\" and a \"version\" attributes.");
        }
        if (file == null) {
            throw new IllegalArgumentException("The /plugins folder of the plugin package should not be null.");
        }
        String string = packageManifest.packageId + "-" + packageManifest.version;
        File file2 = new File(file.getParent(), string + PAR_EXTENSION);
        file2.createNewFile();
        Manifest manifest = this.createParManifest(packageManifest);
        try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(file2), manifest);){
            for (File file3 : file.listFiles()) {
                this.addFileToPar(file3, jarOutputStream);
            }
        }
        return file2;
    }

    private Manifest createParManifest(PackageManifest packageManifest) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.putValue(APPLICATION_SYMBOLIC_NAME, packageManifest.packageId);
        attributes.putValue(APPLICATION_VERSION, packageManifest.version);
        attributes.putValue(APPLICATION_NAME, packageManifest.name);
        attributes.putValue(APPLICATION_DESCRIPTION, packageManifest.description);
        return manifest;
    }

    private void addFileToPar(File file, JarOutputStream jarOutputStream) throws IOException {
        JarEntry jarEntry = new JarEntry(file.getName());
        jarEntry.setTime(Calendar.getInstance().getTimeInMillis());
        jarOutputStream.putNextEntry(jarEntry);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ParBuilder.copyFileStream(fileInputStream, jarOutputStream);
        }
        jarOutputStream.closeEntry();
    }

    private static void copyFileStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }
}

