/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionPointInfo;
import com.vmware.vise.extensionfw.PluginConstants;
import com.vmware.vise.extensionfw.PluginDependency;
import com.vmware.vise.extensionfw.PluginDependencyType;
import com.vmware.vise.extensionfw.impl.PackageManifestParser;
import com.vmware.vise.extensionfw.impl.PluginManifest;
import com.vmware.vise.extensionfw.impl.RelationViewExtensionInfoCreator;
import com.vmware.vise.extensionfw.impl.TemplateInfo;
import com.vmware.vise.extensionfw.impl.TemplateInstanceInfo;
import com.vmware.vise.extensionfw.impl.TemplateVariableInfo;
import com.vmware.vise.extensionfw.impl.parser.PluginFormatParser;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.DocumentBuilderFactorySource;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.XMLUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PluginManifestParser {
    private static final DocumentBuilderFactorySource BUILDER_FACTORY_SOURCE = DocumentBuilderFactorySource.INSTANCE;
    private static final boolean IS_H5_CLIENT = BuildProperties.isH5Client();
    private static final RelationViewExtensionInfoCreator RELATION_INFO_CREATOR = new RelationViewExtensionInfoCreator();
    private static final Log _logger = LogFactory.getLog(PluginManifestParser.class);
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String PLUGIN_FLAG_PROPERTY = "<isPluginShortcut>true</isPluginShortcut>";
    private static final Pattern COLUMN_TAIL_PATTERN = Pattern.compile("</com.vmware.ui.lists.ColumnDataSourceInfo>.*", 32);
    private static final Pattern ACTION_TAIL_PATTERN = Pattern.compile("</com.vmware.actionsfw.ActionSpec>.*", 32);
    private static final Pattern PROP_PATTERN = Pattern.compile("<requestedProperties>(.*)<");
    private static final Pattern SORT_PATTERN = Pattern.compile("<sortProperty>(.*)<");
    private static final Pattern UID_PATTERN = Pattern.compile("<uid>(.*)<");
    private static final Pattern DELEGATE_CLASSNAME_PATTERN = Pattern.compile("<className>(.*)<");
    private static final Pattern ACTIONURL_PATTERN = Pattern.compile("<actionUrl>(.*)<");
    private static final Pattern DIALOGTITLE_PATTERN = Pattern.compile("<dialogTitle>(.*)<");
    private static final Pattern DIALOGSIZE_PATTERN = Pattern.compile("<dialogSize>(.*)<");
    private static final Pattern DIALOGICON_PATTERN = Pattern.compile("<dialogIcon>(.*)<");
    private static final Pattern PLUGIN_ACTION_URL = Pattern.compile("<url>(.*)<");
    private static final Pattern MODAL_PATTERN = Pattern.compile("<modal>((.|" + LINE_SEPARATOR + ")*)</modal>");
    private static final Pattern MODAL_TITLE_PATTERN = Pattern.compile("<title>(.*)<");
    private static final Pattern MODAL_SIZE_PATTERN = Pattern.compile("<size>(.*)<");
    private static final Pattern MODAL_CLOSABLE_PATTERN = Pattern.compile("<closable>(.*)<");
    private static final Pattern GLOBAL_VIEW_HAS_TITLE = Pattern.compile("<metadata>[\\s\\S]*<key>hasTitle</key>\\s*<value>(.*)</value>", 8);
    private static final Pattern SSV_EXTENDED_POINT_PATTERN = Pattern.compile("^vsphere\\.core\\..+\\.summarySectionViews$");
    private static final Pattern SSV_SIZE_PATTERN = Pattern.compile("(<size.*>.+</size>)", 32);
    private static final Pattern SSV_HEIGHT_PATTERN = Pattern.compile("<height>(.*)</height>", 32);
    private static final Pattern SSV_WIDTH_PATTERN = Pattern.compile("<width>(.*)</width>", 32);
    private static final String HTML_ONLY_MODAL_ACTION_DELEGATE = "com.vmware.vsphere.client.HtmlPluginModalAction";
    private static final String HTML_ONLY_HEADLESS_ACTION_DELEGATE = "com.vmware.vsphere.client.HtmlPluginHeadlessAction";
    private static final String HTML_BRIDGE_ACTION_DELEGATE = "com.vmware.vsphere.client.htmlbridge.HtmlActionDelegate";

    public static PluginManifest getPluginManifest(URL uRL, String string, String string2, Map<String, String> map, Set<PluginDependencyType> set, boolean bl) throws IOException {
        Element element;
        Document document;
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = BUILDER_FACTORY_SOURCE.createDocumentBuilder();
            document = documentBuilder.parse(uRL.toString());
            element = document.getDocumentElement();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        PluginManifest pluginManifest = new PluginManifest();
        String string3 = XMLUtil.getAttribute((Element)element, (String)"id");
        if (string3 != null) {
            string = string3;
        }
        if (string == null) {
            throw new IOException("The plugin manifest at " + uRL + " should specify a plugin id attribute.");
        }
        IdVersionPair idVersionPair = new IdVersionPair(string, string2);
        String string4 = XMLUtil.getAttribute((Element)element, (String)"type");
        if (string4 != null) {
            pluginManifest.pluginType = string4;
        }
        pluginManifest.pluginId = string;
        pluginManifest.securityPolicyURI = XMLUtil.getAttribute((Element)element, (String)"securityPolicyUri");
        pluginManifest.moduleURI = XMLUtil.getAttribute((Element)element, (String)"moduleUri");
        if (IS_H5_CLIENT && pluginManifest.moduleURI != null && !PluginManifestParser.hasHtmlViewOrAction(element)) {
            _logger.warn((Object)("Ignoring plugin " + string + " because it doesn't contain any HTML view or action"));
            return null;
        }
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"resources");
        if (element2 != null) {
            Document document2 = documentBuilder.newDocument();
            document2.appendChild(document2.importNode(element2, true));
            pluginManifest.resourceXml = document2;
        }
        pluginManifest.defaultBundle = XMLUtil.getAttribute((Element)element, (String)"defaultBundle");
        pluginManifest.extensionPoints = PluginManifestParser.getExtensionPointInfos(element, idVersionPair);
        pluginManifest.extensions = PluginManifestParser.getExtensionInfos(element, idVersionPair, document, map, bl);
        pluginManifest.templateInfos = PluginManifestParser.getTemplateInfos(element, idVersionPair);
        pluginManifest.templateInstanceInfos = PluginManifestParser.getTemplateInstanceInfos(element, idVersionPair);
        pluginManifest.exportedClasses = PluginManifestParser.getExportedClasses(element);
        pluginManifest.dependencies = PluginManifestParser.getDependencies(XMLUtil.getChildTag((Node)element, (String)"dependencies"), set);
        pluginManifest.metadata = PackageManifestParser.parseMetadata(element);
        return pluginManifest;
    }

    private static boolean hasHtmlViewOrAction(Element element) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"extension");
        for (Element element2 : list) {
            String string = XMLUtil.xmlToString((Node)element2);
            if (string.contains("com.vmware.vsphere.client.htmlbridge.HtmlView")) {
                return true;
            }
            if (!PluginManifestParser.hasHtmlActions(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasHtmlActions(String string) {
        return string.contains(HTML_BRIDGE_ACTION_DELEGATE) || string.contains(HTML_ONLY_MODAL_ACTION_DELEGATE) || string.contains(HTML_ONLY_HEADLESS_ACTION_DELEGATE);
    }

    public static List<ExtensionPointInfo> getExtensionPointInfos(Element element, IdVersionPair idVersionPair) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"extensionPoint");
        ArrayList<ExtensionPointInfo> arrayList = new ArrayList<ExtensionPointInfo>(list.size());
        for (Element element2 : list) {
            String string = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (string == null) {
                throw new IOException("The extensionPoint tag should specify an id attribute.");
            }
            String string2 = null;
            Element element3 = XMLUtil.getChildTag((Node)element2, (String)"objectType");
            if (element3 != null) {
                string2 = XMLUtil.getAttribute((Element)element3, (String)"class");
            }
            if (string2 == null) {
                throw new IOException("The extension-point " + string + " should specify an objectType tag with a class attribute.");
            }
            ExtensionPointInfo extensionPointInfo = new ExtensionPointInfo();
            extensionPointInfo.setId(string);
            extensionPointInfo.setPluginRef(idVersionPair);
            extensionPointInfo.setObjectType(string2);
            arrayList.add(extensionPointInfo);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<ExtensionInfo> getExtensionInfos(Element element, IdVersionPair idVersionPair, Document document, Map<String, String> map, boolean bl) throws IOException {
        Object object;
        List<ExtensionInfo> list;
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        if (BuildProperties.isH5Client() && PluginManifestParser.isNonCorePlugin(map) && BuildProperties.useExperimentalSdkFeatures()) {
            list = PluginFormatParser.getExtensionInfos(element, idVersionPair);
            arrayList.addAll(list);
        }
        list = XMLUtil.getChildTags((Node)element, (String)"extension");
        HashMap<Object, Element> hashMap = new HashMap<Object, Element>();
        for (Element element2 : list) {
            Object object2;
            Element element3;
            String string;
            object = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (object == null) {
                throw new IOException("The extension tag should specify an extension id.");
            }
            String[] stringArray = PluginManifestParser.getTagValues(element2, "extendedPoint");
            if (stringArray == null) {
                throw new IOException("The extension tag should specify an extendedPoint tag.");
            }
            if (IS_H5_CLIENT) {
                if (Arrays.asList(stringArray).contains("vise.empty.global.views")) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    string = stringArray[i];
                    if (!string.endsWith(".html")) continue;
                    stringArray[i] = string.substring(0, string.lastIndexOf(".html"));
                }
            }
            if ((element3 = XMLUtil.getChildTag((Node)element2, (String)"object")) == null) {
                throw new IOException("The extension tag should have a nested object tag.");
            }
            string = XMLUtil.getAttribute((Element)element3, (String)"type");
            element3.removeAttribute("type");
            String string2 = XMLUtil.xmlToString((Node)element3);
            boolean bl2 = true;
            List<Pair<String, String>> list2 = null;
            if (IS_H5_CLIENT) {
                block34: {
                    if (bl || PluginManifestParser.sandboxPlugin(element, map)) {
                        string2 = string2.replaceAll("(<contentSpec>)", "<contentSpec><sandbox>true</sandbox>");
                    }
                    if (string2.contains("<componentClass")) {
                        if ((string2 = PluginManifestParser.convertComponentClassXml(string2, (String)object, idVersionPair)) == null) {
                            _logger.warn((Object)("Ignoring Flex view id " + (String)object + " in plugin " + idVersionPair.getId()));
                            continue;
                        }
                    } else if (string2.contains("com.vmware.ui.lists.ColumnContainer")) {
                        bl2 = false;
                        list2 = PluginManifestParser.convertColumnContainerXml(string2, (String)object);
                    } else if (stringArray[0].equals("vise.home.shortcuts") && !PluginManifestParser.isCoreVsphereClientPackageId(map)) {
                        string2 = string2.replaceFirst("</object>", "<isPluginShortcut>true</isPluginShortcut></object>");
                    } else if (stringArray[0].equals("vise.actions.specs") && PluginManifestParser.isNonCorePlugin(map)) {
                        string2 = PluginManifestParser.convertActionsSpecs(string2, (String)object);
                    } else {
                        String string3;
                        if (stringArray[0].equals("vise.actions.sets")) {
                            bl2 = false;
                            if (PluginManifestParser.hasHtmlActions(string2)) {
                                string2 = PluginManifestParser.convertRootPath(string2, "<actionUrl>", (String)object, idVersionPair);
                                list2 = PluginManifestParser.convertActionSet(string2, (String)object);
                                stringArray = new String[]{"vise.actions.specs"};
                                break block34;
                            } else {
                                _logger.warn((Object)("Ignoring Flex actions set id " + (String)object + " in plugin " + idVersionPair.getId()));
                                continue;
                            }
                        }
                        if (stringArray[0].equals("vsphere.core.menus.solutionMenus")) {
                            string2 = PluginManifestParser.convertSolutionMenus(string2, (String)object, idVersionPair);
                            stringArray = new String[]{"vise.menus.context.solutionMenus"};
                            PluginManifestParser.addObjectTypesToSolutionMenuIfMissing(element, document, element2);
                        } else if (stringArray[0].equals("vise.relateditems.specs")) {
                            string2 = PluginManifestParser.convertRelatedItems(string2);
                            hashMap.put(object, element3);
                        } else if (string2.contains("<viewOpenedUponFocus")) {
                            string2 = PluginManifestParser.convertViewOpenedUponFocus(document, element3);
                        } else if (stringArray[0].contains("manageCategories")) {
                            stringArray = new String[]{stringArray[0].replace("manageCategories", "manage.settingsCategories")};
                        } else if (stringArray[0].equals("vise.global.views") && ((Matcher)(object2 = GLOBAL_VIEW_HAS_TITLE.matcher(string2))).find() && "false".equals(string3 = ((Matcher)object2).group(1))) {
                            stringArray[0] = "vise.empty.global.views";
                        }
                    }
                }
                string2 = PluginManifestParser.convertSizeForSummarySectionViews(string2, stringArray[0], (String)object);
            }
            if (bl2) {
                object2 = PluginManifestParser.createExtensionInfo(element2, (String)object, stringArray, idVersionPair, string, string2);
                PluginManifestParser.addMetadata((ExtensionInfo)object2, document, element2, map);
                arrayList.add((ExtensionInfo)object2);
                continue;
            }
            object2 = list2.iterator();
            while (object2.hasNext()) {
                Pair pair = (Pair)object2.next();
                String string4 = (String)pair.first;
                String string5 = (String)pair.second;
                ExtensionInfo extensionInfo = PluginManifestParser.createExtensionInfo(element2, string4, stringArray, idVersionPair, string, string5);
                PluginManifestParser.addMetadata(extensionInfo, document, element2, map);
                arrayList.add(extensionInfo);
            }
        }
        if (!hashMap.isEmpty() && IS_H5_CLIENT && !bl && PluginManifestParser.isVSphereClientModulePackageId(map)) {
            for (Map.Entry entry : hashMap.entrySet()) {
                object = RELATION_INFO_CREATOR.createRelationViewExtensionInfos((String)entry.getKey(), (Element)entry.getValue(), idVersionPair, map, document);
                arrayList.addAll((Collection<ExtensionInfo>)object);
            }
        }
        return arrayList;
    }

    private static String convertSizeForSummarySectionViews(String string, String string2, String string3) {
        int n;
        int n2;
        Matcher matcher = SSV_EXTENDED_POINT_PATTERN.matcher(string2);
        if (!matcher.matches()) {
            return string;
        }
        matcher = SSV_SIZE_PATTERN.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        String string4 = matcher.group(1);
        Matcher matcher2 = SSV_WIDTH_PATTERN.matcher(string4);
        String string5 = matcher2.find() ? matcher2.group(1) : "1";
        Matcher matcher3 = SSV_HEIGHT_PATTERN.matcher(string4);
        String string6 = matcher3.find() ? matcher3.group(1) : "1";
        try {
            n2 = Integer.parseInt(string5);
            n = Integer.parseInt(string6);
        }
        catch (NumberFormatException numberFormatException) {
            _logger.warn((Object)String.format("Wrong format of the <size> property in extension %1$s.%nThe correct format is <size><width>int</width><height>int</height></size>", string3));
            return string;
        }
        string = matcher.replaceFirst("");
        String string7 = String.format("<metadata><entry><key>size</key><value>%s:%s</value></entry></metadata>", n2, n);
        String string8 = "</contentSpec>";
        return string.replaceFirst(string8, string7 + System.lineSeparator() + string8);
    }

    private static boolean sandboxPlugin(Element element, Map<String, String> map) {
        return PluginManifestParser.isNonCorePlugin(map) && "plugin".equalsIgnoreCase(element.getTagName());
    }

    private static boolean isNonCorePlugin(Map<String, String> map) {
        return map != null && !PluginManifestParser.isCoreVsphereClientPackageId(map);
    }

    private static boolean isCoreVsphereClientPackageId(Map<String, String> map) {
        String string = map.get("pluginPackageId");
        if (string instanceof String) {
            String string2 = string;
            return ArrayUtil.contains((Object)string2, (Object[])PluginConstants.CORE_VSPHERE_CLIENT_PACKAGE_IDS);
        }
        return false;
    }

    private static boolean isVSphereClientModulePackageId(Map<String, String> map) {
        String string;
        if (map == null) {
            return false;
        }
        String string2 = map.get("pluginPackageId");
        return string2 instanceof String && ("com.vmware.vsphere.client".equals(string = string2) || "com.vmware.vsphere.client.html".equals(string));
    }

    private static ExtensionInfo createExtensionInfo(Element element, String string, String[] stringArray, IdVersionPair idVersionPair, String string2, String string3) throws IOException {
        String[] stringArray2 = PluginManifestParser.getTagValues(element, "hostedPoint");
        ExtensionInfo extensionInfo = new ExtensionInfo();
        extensionInfo.setId(string);
        extensionInfo.setExtendedPointIds(stringArray);
        extensionInfo.setHostedPointsIds(stringArray2);
        extensionInfo.setPluginRef(idVersionPair);
        extensionInfo.setObjectType(string2);
        extensionInfo.setObjectXmlStr(string3);
        extensionInfo.setPrecedingIds(PluginManifestParser.getPrecedingExtensions(element));
        return extensionInfo;
    }

    private static void addMetadata(ExtensionInfo extensionInfo, Document document, Element element, Map<String, String> map) throws IOException {
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"metadata");
        if (map != null) {
            if (element2 == null) {
                element2 = document.createElement("metadata");
            }
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                Element element3 = document.createElement(string);
                Text text = document.createTextNode((String)entry.getValue());
                element3.appendChild(text);
                element2.appendChild(element3);
            }
        }
        if (element2 != null) {
            String string = XMLUtil.xmlToString((Node)element2);
            extensionInfo.setMetadataXmlStr(string);
        }
    }

    private static String convertSolutionMenus(String string, String string2, IdVersionPair idVersionPair) {
        string = string.replaceAll("<children>", "<type>MENU</type>\n  <children>");
        string = string.replaceAll("<Array>", "");
        string = string.replaceAll("</Array>", "");
        string = string.replaceAll("com.vmware.actionsfw.ActionMenuItemSpec", "object");
        string = string.replaceAll("<type>action</type>", "<type>ACTION</type>");
        string = string.replaceAll("<type>separator</type>", "<type>SEPARATOR</type>");
        return string;
    }

    private static String convertRelatedItems(String string) {
        String string2 = "com.vmware.ui.relateditems.model.RelationSpec";
        if (!string.contains(string2)) {
            return string;
        }
        string = string.replaceAll("<relationSpecs>", "");
        string = string.replaceAll("</relationSpecs>", "");
        string = string.replaceAll(string2, "relationSpecs");
        return string;
    }

    private static String convertComponentClassXml(String string, String string2, IdVersionPair idVersionPair) {
        if (string.contains("com.vmware.vsphere.client.htmlbridge.HtmlView")) {
            string = string.replaceAll("componentClass", "contentSpec");
            string = string.replaceAll("<object>[\\s]*<root>", "");
            string = string.replaceAll("</root>[\\s]*</object>", "<sandbox>true</sandbox>");
            string = PluginManifestParser.convertRootPath(string, "<url>", string2, idVersionPair);
        } else if (string.contains("<componentClass")) {
            return null;
        }
        return string;
    }

    private static String convertRootPath(String string, String string2, String string3, IdVersionPair idVersionPair) {
        String string4 = string2 + "/ui/";
        String string5 = string2 + "/vsphere-client/";
        if (string.contains(string5)) {
            string = string.replaceAll(string5, string4);
        } else if (string.contains(string4)) {
            _logger.warn((Object)("Plugin '" + idVersionPair.getId() + "' should not hard-code URL path '/ui/' in extension: " + string3 + ",\n it should either be a relative path (plugin-name/...), or start with /vsphere-client/plugin-name for Flex client compatibility."));
        } else {
            _logger.warn((Object)("Plugin '" + idVersionPair.getId() + "' is missing URL path '/vsphere-client/' in extension: " + string3 + ",\n this is required for Flex client compatibility."));
        }
        return string;
    }

    private static List<Pair<String, String>> convertActionSet(String string, String string2) {
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        String[] stringArray = string.split("<com.vmware.actionsfw.ActionSpec>");
        for (int i = 1; i < stringArray.length; ++i) {
            Object object;
            String string3 = ACTION_TAIL_PATTERN.matcher(stringArray[i]).replaceAll("");
            Matcher matcher = UID_PATTERN.matcher(string3);
            if (!matcher.find()) {
                _logger.error((Object)("Skipping ActionSpec because <uid> is missing, in extension " + string2));
                continue;
            }
            String string4 = matcher.group(1);
            ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
            matcher = ACTIONURL_PATTERN.matcher(string3);
            if (!matcher.find()) {
                _logger.error((Object)("Skipping ActionSpec because <actionUrl> is missing, in extension " + string2));
                continue;
            }
            arrayList2.add(new Pair((Object)"actionUrl", (Object)matcher.group(1)));
            matcher = DIALOGTITLE_PATTERN.matcher(string3);
            if (matcher.find()) {
                arrayList2.add(new Pair((Object)"dialogTitle", (Object)matcher.group(1)));
            }
            if ((matcher = DIALOGSIZE_PATTERN.matcher(string3)).find() && PluginManifestParser.isModalSizeValid((String)(object = matcher.group(1)), string2)) {
                arrayList2.add(new Pair((Object)"dialogSize", object));
            }
            if ((matcher = DIALOGICON_PATTERN.matcher(string3)).find()) {
                arrayList2.add(new Pair((Object)"dialogIcon", (Object)matcher.group(1)));
            }
            if ((matcher = MODAL_CLOSABLE_PATTERN.matcher(string3)).find()) {
                arrayList2.add(new Pair((Object)"closable", (Object)matcher.group(1)));
            }
            string3 = string3 + "\n<additionalData>";
            object = arrayList2.iterator();
            while (object.hasNext()) {
                Pair pair = (Pair)object.next();
                string3 = string3 + "\n<entry><key>" + (String)pair.first + "</key>";
                string3 = string3 + "\n<value>" + (String)pair.second + "</value></entry>";
            }
            matcher = DELEGATE_CLASSNAME_PATTERN.matcher(string3 = string3 + "\n</additionalData>");
            if (matcher.find()) {
                string3 = string3 + "\n<invoker>" + matcher.group(1) + "</invoker>";
            }
            string3 = string3.replaceAll("conditionalProperty>", "availabilityProperty>");
            string3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<object>" + string3 + "\n</object>";
            arrayList.add((Pair<String, String>)new Pair((Object)string4, (Object)string3));
        }
        return arrayList;
    }

    private static List<Pair<String, String>> convertColumnContainerXml(String string, String string2) {
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        String[] stringArray = string.split("<com.vmware.ui.lists.ColumnDataSourceInfo>");
        int n = 1;
        for (int i = 1; i < stringArray.length; ++i) {
            Matcher matcher;
            String string3 = COLUMN_TAIL_PATTERN.matcher(stringArray[i]).replaceAll("");
            if (string3.contains("<String>")) {
                string3 = string3.replaceAll("<requestedProperties>[\\s]*<String>(.*)</String>[\\s]*<", "<requestedProperties>$1<");
            }
            if ((matcher = SORT_PATTERN.matcher(string3 = (matcher = PROP_PATTERN.matcher(string3)).find() && "name".equals(matcher.group(1)) ? string3.replace("<requestedProperties>name</requestedProperties>", "<requestedProperties>id</requestedProperties>\n<requestedProperties>primaryIconId</requestedProperties>\n<requestedProperties>name</requestedProperties>\n<requestedProperties>labelIds</requestedProperties>\n<columnRenderer>object-name</columnRenderer>") : string3.replace("</requestedProperties>", "</requestedProperties>\n<columnRenderer>text</columnRenderer>"))).find() && "name".equals(matcher.group(1))) {
                string3 = string3 + "\n<width>250</width>";
                string3 = string3 + "\n<sortedByDefault>true</sortedByDefault>";
            }
            string3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<object>" + string3 + "\n</object>";
            String string4 = string2 + '_' + n++;
            arrayList.add((Pair<String, String>)new Pair((Object)string4, (Object)string3));
        }
        return arrayList;
    }

    private static String[] getTagValues(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string2 = XMLUtil.getTagValue((Element)element2);
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[0]);
    }

    private static Set<String> getPrecedingExtensions(Element element) {
        NodeList nodeList = element.getElementsByTagName("precedingExtension");
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getTagValue((Element)element2);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private static List<TemplateInfo> getTemplateInfos(Element element, IdVersionPair idVersionPair) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"template");
        ArrayList<TemplateInfo> arrayList = new ArrayList<TemplateInfo>(list.size());
        for (Element element2 : list) {
            String string = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (string == null) {
                throw new IOException("The template tag should specify a template id.");
            }
            String string2 = XMLUtil.getChildTagValue((Node)element2, (String)"inheritedTemplate");
            String string3 = XMLUtil.xmlToString((Node)element2);
            TemplateVariableInfo[] templateVariableInfoArray = PluginManifestParser.getTemplateVariableInfos(element2);
            TemplateInfo templateInfo = new TemplateInfo();
            templateInfo.setId(string);
            templateInfo.setInheritedTemplateId(string2);
            templateInfo.setPluginRef(idVersionPair);
            templateInfo.setVariableInfos(templateVariableInfoArray);
            templateInfo.setTemplateXmlStr(string3);
            arrayList.add(templateInfo);
        }
        return arrayList;
    }

    private static List<TemplateInstanceInfo> getTemplateInstanceInfos(Element element, IdVersionPair idVersionPair) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"templateInstance");
        ArrayList<TemplateInstanceInfo> arrayList = new ArrayList<TemplateInstanceInfo>(list.size());
        for (Element element2 : list) {
            String string = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (string == null) {
                throw new IOException("The templateInstance tag should specify an id attribute.");
            }
            String string2 = XMLUtil.getChildTagValue((Node)element2, (String)"templateId");
            if (string2 == null) {
                throw new IOException("The templateInstance tag should specify a templateId child node.");
            }
            Pair<String, String>[] pairArray = PluginManifestParser.getTemplateInstanceVariables(element2);
            String[] stringArray = PluginManifestParser.getTagValues(element2, "excludedExtension");
            TemplateInstanceInfo templateInstanceInfo = new TemplateInstanceInfo();
            templateInstanceInfo.setId(string);
            templateInstanceInfo.setTemplateId(string2);
            templateInstanceInfo.setPluginRef(idVersionPair);
            templateInstanceInfo.setVariableNameValues(pairArray);
            templateInstanceInfo.setExcludedExtensionIds(stringArray);
            arrayList.add(templateInstanceInfo);
        }
        return arrayList;
    }

    private static List<String> getExportedClasses(Element element) {
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"export");
        if (element2 == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = element.getElementsByTagName("class");
        int n = nodeList.getLength();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element3 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element3, (String)"name");
            arrayList.add(string);
        }
        return arrayList;
    }

    static PluginDependency[] getDependencies(Element element, Set<PluginDependencyType> set) throws IOException {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getElementsByTagName("dependency");
        int n = nodeList.getLength();
        ArrayList<PluginDependency> arrayList = new ArrayList<PluginDependency>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element2, (String)"type");
            String string2 = XMLUtil.getAttribute((Element)element2, (String)"uri");
            if (string == null) {
                throw new IOException("The dependency tag should specify a type attributes.");
            }
            PluginDependencyType pluginDependencyType = PluginDependencyType.fromString(string);
            if (set != null && !set.contains((Object)pluginDependencyType)) {
                throw new IOException("The dependency type '" + string + "' is not supported for this plugin.");
            }
            if (string2 == null) {
                throw new IOException("The dependency tag should specify a uri attributes.");
            }
            PluginDependency pluginDependency = new PluginDependency(string.toLowerCase(), string2);
            arrayList.add(pluginDependency);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new PluginDependency[0]);
    }

    private static TemplateVariableInfo[] getTemplateVariableInfos(Element element) throws IOException {
        NodeList nodeList = element.getElementsByTagName("variable");
        int n = nodeList.getLength();
        ArrayList<TemplateVariableInfo> arrayList = new ArrayList<TemplateVariableInfo>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element2, (String)"name");
            if (string == null) {
                throw new IOException("The variable tag should specify a name attribute.");
            }
            boolean bl = XMLUtil.getBooleanAttribute((Element)element2, (String)"required", (boolean)true);
            String string2 = XMLUtil.getAttribute((Element)element2, (String)"defaultValue");
            TemplateVariableInfo templateVariableInfo = new TemplateVariableInfo(string);
            templateVariableInfo.setRequired(bl);
            templateVariableInfo.setDefaultValue(string2);
            arrayList.add(templateVariableInfo);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new TemplateVariableInfo[0]);
    }

    private static Pair<String, String>[] getTemplateInstanceVariables(Element element) throws IOException {
        NodeList nodeList = element.getElementsByTagName("variable");
        int n = nodeList.getLength();
        ArrayList<Pair> arrayList = new ArrayList<Pair>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element2, (String)"name");
            if (string == null) {
                throw new IOException("The variable tag should specify a name attribute.");
            }
            String string2 = XMLUtil.getAttribute((Element)element2, (String)"value");
            Pair pair = new Pair((Object)string, (Object)string2);
            arrayList.add(pair);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new Pair[0]);
    }

    private static String convertViewOpenedUponFocus(Document document, Element element) throws IOException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Element element2;
            if (!(nodeList.item(i) instanceof Element) || !(element2 = (Element)nodeList.item(i)).getNodeName().equals("viewOpenedUponFocus") || (string = XMLUtil.getAttribute((Element)element2, (String)"className")) == null || !string.equals("com.vmware.ui.objectnavigator.views.CategoryNodeTreeView")) continue;
            element2.removeAttribute("className");
            Element element3 = document.createElement("url");
            element3.appendChild(document.createTextNode("resources/ui/views/objectnavigator/CategoryNodeTreeView.html"));
            element2.appendChild(element3);
        }
        return XMLUtil.xmlToString((Node)element);
    }

    private static String convertActionsSpecs(String string, String string2) throws IOException {
        Matcher matcher = MODAL_PATTERN.matcher(string);
        if (matcher.find()) {
            String string3;
            String string4 = matcher.group(1);
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            Matcher matcher2 = PLUGIN_ACTION_URL.matcher(string4);
            if (!matcher2.find()) {
                _logger.error((Object)("Missing <url> inside <modal> in extension: " + string2));
                return string;
            }
            arrayList.add(new Pair((Object)"url", (Object)matcher2.group(1)));
            matcher2 = MODAL_TITLE_PATTERN.matcher(string4);
            if (matcher2.find()) {
                arrayList.add(new Pair((Object)"title", (Object)matcher2.group(1)));
            }
            if ((matcher2 = MODAL_SIZE_PATTERN.matcher(string4)).find() && PluginManifestParser.isModalSizeValid(string3 = matcher2.group(1), string2)) {
                arrayList.add(new Pair((Object)"size", (Object)string3));
            }
            if ((matcher2 = MODAL_CLOSABLE_PATTERN.matcher(string4)).find()) {
                arrayList.add(new Pair((Object)"closable", (Object)matcher2.group(1)));
            }
            string3 = LINE_SEPARATOR + "<pluginData>";
            for (Pair pair : arrayList) {
                string3 = string3 + LINE_SEPARATOR + "<entry><key>" + (String)pair.first + "</key>";
                string3 = string3 + LINE_SEPARATOR + "<value>" + (String)pair.second + "</value></entry>";
            }
            string3 = string3 + LINE_SEPARATOR + "<entry><key>headless</key>";
            string3 = string3 + LINE_SEPARATOR + "<value>false</value></entry>";
            string3 = string3 + LINE_SEPARATOR + "</pluginData>";
            string3 = string3 + LINE_SEPARATOR + "<invoker>com.vmware.vsphere.client.pluginActions</invoker>";
            string = string.replaceAll(MODAL_PATTERN.toString(), string3);
        } else {
            Matcher matcher3 = PLUGIN_ACTION_URL.matcher(string);
            if (matcher3.find()) {
                String string5 = LINE_SEPARATOR + "<pluginData>";
                string5 = string5 + LINE_SEPARATOR + "<entry><key>url</key>";
                string5 = string5 + LINE_SEPARATOR + "<value>" + matcher3.group(1) + "</value></entry>";
                string5 = string5 + LINE_SEPARATOR + "<entry><key>headless</key>";
                string5 = string5 + LINE_SEPARATOR + "<value>true</value></entry>";
                string5 = string5 + LINE_SEPARATOR + "</pluginData>";
                string5 = string5 + LINE_SEPARATOR + "<invoker>com.vmware.vsphere.client.pluginActions</invoker>";
                string = string.replaceAll(PLUGIN_ACTION_URL.toString(), string5);
            } else {
                _logger.warn((Object)("Action extension " + string2 + " specifies neither a <modal> tag for a modal dialog, nor a <url> tag for a headless action."));
            }
        }
        return string;
    }

    private static boolean isModalSizeValid(String string, String string2) {
        boolean bl = false;
        try {
            String[] stringArray = string.split(",");
            if (stringArray.length == 2) {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                if (n > 0 && n2 > 0) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            _logger.warn((Object)("Wrong format of the <size> property in extension" + string2 + ". The correct format is <size>int,int</size>"));
        }
        return bl;
    }

    private static void addObjectTypesToSolutionMenuIfMissing(Element element, Document document, Element element2) {
        Object object;
        Element element3 = XMLUtil.getChildTag((Node)element2, (String)"metadata");
        if (element3 != null) {
            object = XMLUtil.getChildTag((Node)element3, (String)"objectType");
            if (object != null) {
                return;
            }
        } else {
            element3 = document.createElement("metadata");
            element2.appendChild(element3);
        }
        object = StringUtils.join(PluginManifestParser.getPluginObjectTypes(element), (String)",");
        Element element4 = document.createElement("objectType");
        Text text = document.createTextNode(StringUtils.join(PluginConstants.VSPHERE_OBJECTS, (String)", ") + ", " + (String)object);
        element4.appendChild(text);
        element3.appendChild(element4);
    }

    private static Set<String> getPluginObjectTypes(Element element) {
        List<TemplateInstanceInfo> list = null;
        try {
            list = PluginManifestParser.getTemplateInstanceInfos(element, null);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (TemplateInstanceInfo templateInstanceInfo : list) {
            hashSet.add(PluginManifestParser.getObjectType(templateInstanceInfo));
        }
        return hashSet;
    }

    private static String getObjectType(TemplateInstanceInfo templateInstanceInfo) {
        Pair<String, String>[] pairArray;
        for (Pair<String, String> pair : pairArray = templateInstanceInfo.getVariableNameValues()) {
            if (!"objectType".equals(pair.first)) continue;
            return (String)pair.second;
        }
        throw new IllegalStateException("The template instance does not contain an objectType variable");
    }
}

