/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionManager;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.session.SessionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemotePluginProcessor {
    private static final String URL = "<url>";
    public static final String PLUGIN_REGISTRATION_URL_BY_SERVER = "pluginRegistrationUrlByServer";
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private static final Log _logger = LogFactory.getLog(RemotePluginProcessor.class);

    public static List<ExtensionInfo> filterOutInvalidRemoteExtensions(ExtensionManager extensionManager, List<ExtensionInfo> list, Map<String, Object> map) {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        ArrayList<ExtensionInfo> arrayList2 = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extensionInfo : list) {
            PluginInfo pluginInfo = extensionManager.getPluginInfo(extensionInfo.getPluginRef());
            if (pluginInfo == null) {
                arrayList.add(extensionInfo);
                continue;
            }
            PluginPackageInfo pluginPackageInfo = null;
            try {
                pluginPackageInfo = extensionManager.getPluginPackageInfo(pluginInfo.getPackageRef());
            }
            catch (Exception exception) {
                _logger.error((Object)("No plugin package info found for: " + extensionInfo.getId()));
                arrayList.add(extensionInfo);
                continue;
            }
            if (pluginPackageInfo != null && pluginPackageInfo.isRemotePlugin()) {
                arrayList2.add(extensionInfo);
                continue;
            }
            arrayList.add(extensionInfo);
        }
        if (arrayList2.size() == 0) {
            return arrayList;
        }
        List<ExtensionInfo> list2 = map == null || map.isEmpty() || map.get(CONTEXT_OBJECTS) == null ? RemotePluginProcessor.getValidRemoteGlobalExtensions(arrayList2) : RemotePluginProcessor.getValidRemoteObjectExtensions(extensionManager, arrayList2, map);
        if (list2 != null) {
            arrayList.addAll((Collection<ExtensionInfo>)list2);
        }
        return arrayList;
    }

    public static String changeURLInObjectXml(PluginPackageInfo pluginPackageInfo, String string, Map<String, Object> map) {
        Object object;
        if (pluginPackageInfo == null || !pluginPackageInfo.isRemotePlugin() || !string.contains(URL)) {
            return string;
        }
        ConcurrentMap<String, Object> concurrentMap = pluginPackageInfo.getMetadata();
        if (concurrentMap == null) {
            return string;
        }
        Map map2 = (Map)concurrentMap.get(PLUGIN_REGISTRATION_URL_BY_SERVER);
        if (map2 == null || map2.isEmpty()) {
            return string;
        }
        String string2 = RemotePluginProcessor.getContextObjString(map);
        String string3 = null;
        if (StringUtil.isNullOrEmpty((String)string2)) {
            object = map2.values();
            string3 = RemotePluginProcessor.getPreferredUrl(object);
        } else {
            object = map2.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (!string2.contains(string4)) continue;
                string3 = (String)map2.get(string4);
                break;
            }
        }
        if (StringUtil.isNullOrEmpty((String)string3)) {
            return string;
        }
        object = URL + string3 + "/";
        string = string.replaceAll(URL, (String)object);
        return string;
    }

    protected static String getPreferredUrl(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        String string = (String)SessionUtil.getData((String)"ssoServerHost");
        if (string != null) {
            for (String string2 : collection) {
                if (!string2.contains(string)) continue;
                return string2;
            }
        }
        return collection.iterator().next();
    }

    private static List<ExtensionInfo> getValidRemoteGlobalExtensions(List<ExtensionInfo> list) {
        HashMap<String, ExtensionInfo> hashMap = new HashMap<String, ExtensionInfo>();
        for (ExtensionInfo extensionInfo : list) {
            if (hashMap.containsKey(extensionInfo.getId())) {
                ExtensionInfo extensionInfo2 = (ExtensionInfo)hashMap.get(extensionInfo.getId());
                Version version = new Version(extensionInfo2.getPluginRef().getVersion());
                Version version2 = new Version(extensionInfo.getPluginRef().getVersion());
                if (version2.compareTo(version) <= 0) continue;
                hashMap.put(extensionInfo.getId(), extensionInfo);
                continue;
            }
            hashMap.put(extensionInfo.getId(), extensionInfo);
        }
        return new ArrayList<ExtensionInfo>(hashMap.values());
    }

    private static List<ExtensionInfo> getValidRemoteObjectExtensions(ExtensionManager extensionManager, List<ExtensionInfo> list, Map<String, Object> map) {
        String string = RemotePluginProcessor.getContextObjString(map);
        if (StringUtil.isNullOrEmpty((String)string)) {
            return list;
        }
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        block2: for (ExtensionInfo extensionInfo : list) {
            ConcurrentMap<String, Object> concurrentMap;
            Map map2;
            IdVersionPair idVersionPair = extensionInfo.getPluginRef();
            PluginPackageInfo pluginPackageInfo = null;
            try {
                pluginPackageInfo = extensionManager.getPluginPackageInfo(idVersionPair);
            }
            catch (Exception exception) {
                continue;
            }
            if (pluginPackageInfo == null || !pluginPackageInfo.isRemotePlugin() || (map2 = (Map)(concurrentMap = pluginPackageInfo.getMetadata()).get(PLUGIN_REGISTRATION_URL_BY_SERVER)) == null) continue;
            Set set = map2.keySet();
            for (String string2 : set) {
                if (!string.contains(string2)) continue;
                arrayList.add(extensionInfo);
                continue block2;
            }
        }
        return arrayList;
    }

    private static String getContextObjString(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Object object = map.get(CONTEXT_OBJECTS);
        Object object2 = null;
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        if (objectArray != null && objectArray.length > 0) {
            object2 = objectArray[0];
        }
        if (object2 == null) {
            return null;
        }
        return object2.toString();
    }
}

