/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionPointInfo;
import com.vmware.vise.extensionfw.impl.PluginManifestParser;
import com.vmware.vise.extensionfw.impl.TemplateInfo;
import com.vmware.vise.extensionfw.impl.TemplateInstanceInfo;
import com.vmware.vise.extensionfw.impl.TemplateVariableInfo;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.XMLUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TemplateInstantiator {
    private static final String VARIABLE_TOKEN_PATTERN_PREFIX = "\\$\\{";
    private static final String VARIABLE_TOKEN_PATTERN_SUFFIX = "\\}";
    private static final Log _logger = LogFactory.getLog(TemplateInstantiator.class);
    private TemplateInfo _templateInfo;
    private TemplateInstanceInfo _instanceInfo;
    private List<ExtensionPointInfo> _extensionPointInfos = new ArrayList<ExtensionPointInfo>();
    private List<ExtensionInfo> _extensionInfos = new ArrayList<ExtensionInfo>();

    public TemplateInstantiator(TemplateInfo templateInfo, TemplateInstanceInfo templateInstanceInfo) {
        this._templateInfo = templateInfo;
        this._instanceInfo = templateInstanceInfo;
    }

    public void instantiate(Map<String, String> map, boolean bl) {
        String string = this.resolveTemplateXml();
        if (string == null) {
            return;
        }
        Document document = XMLUtil.parseXml((String)string);
        if (document == null) {
            _logger.error((Object)("The template '" + this._templateInfo.getId() + "' could not be parsed."));
            return;
        }
        Element element = document.getDocumentElement();
        IdVersionPair idVersionPair = this._instanceInfo.getPluginRef();
        try {
            this._extensionPointInfos = PluginManifestParser.getExtensionPointInfos(element, idVersionPair);
            this._extensionInfos = PluginManifestParser.getExtensionInfos(element, idVersionPair, document, map, bl);
            this.excludeExtensions();
        }
        catch (Exception exception) {
            _logger.error((Object)("Error while creating the template instance '" + this._instanceInfo.getId() + "'"), (Throwable)exception);
        }
    }

    public List<ExtensionPointInfo> getExtensionPointInfos() {
        return this._extensionPointInfos;
    }

    public List<ExtensionInfo> getExtensionInfos() {
        return this._extensionInfos;
    }

    private String resolveTemplateXml() {
        String string = this._templateInfo.getTemplateXmlStr();
        TemplateVariableInfo[] templateVariableInfoArray = this._templateInfo.getVariableInfos();
        if (templateVariableInfoArray == null) {
            return string;
        }
        for (TemplateVariableInfo templateVariableInfo : templateVariableInfoArray) {
            String string2 = templateVariableInfo.getName();
            String string3 = this.getVariableValue(string2, templateVariableInfo.getDefaultValue());
            if (string3 == null) {
                if (templateVariableInfo.isRequired()) {
                    _logger.error((Object)("The template variable '" + string2 + "' should be specified in the template instance '" + this._instanceInfo.getId()));
                    return null;
                }
                string3 = "";
            }
            string = string.replaceAll(VARIABLE_TOKEN_PATTERN_PREFIX + string2 + VARIABLE_TOKEN_PATTERN_SUFFIX, string3);
        }
        return string;
    }

    private void excludeExtensions() {
        String[] stringArray = this._instanceInfo.getExcludedExtensionIds();
        if (stringArray == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            hashSet.add(string);
        }
        Iterator<ExtensionInfo> iterator = this._extensionInfos.iterator();
        while (iterator.hasNext()) {
            ExtensionInfo extensionInfo = (ExtensionInfo)iterator.next();
            if (!hashSet.contains(extensionInfo.getId())) continue;
            iterator.remove();
        }
    }

    private String getVariableValue(String string, String string2) {
        Pair<String, String>[] pairArray = this._instanceInfo.getVariableNameValues();
        if (pairArray != null) {
            for (Pair<String, String> pair : pairArray) {
                if (!((String)pair.first).equals(string)) continue;
                return (String)pair.second;
            }
        }
        if (!StringUtil.isNullOrEmpty((String)string2)) {
            return string2;
        }
        return null;
    }
}

