/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl.parser;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

enum ExtensionPoint {
    NAVIGATION("navigation", "vise.navigator.nodespecs"){

        @Override
        public String getLegacyFormat(Element element, List<Element> list, String string, IdVersionPair idVersionPair) {
            String string2 = XMLUtil.getAttribute((Element)element, (String)"id");
            String string3 = XMLUtil.getAttribute((Element)element, (String)"target");
            String string4 = XMLUtil.getAttribute((Element)element, (String)"icon");
            String string5 = XMLUtil.getAttribute((Element)element, (String)"labelKey");
            String string6 = XMLUtil.getAttribute((Element)element, (String)"parent");
            String string7 = "";
            if (StringUtil.isNullOrEmpty((String)string6)) {
                boolean bl = false;
                if (StringUtil.isNullOrEmpty((String)string3)) {
                    _logger.error((Object)String.format(ExtensionPoint.MISSING_ATTRIBUTE_ERROR, idVersionPair.getId(), string2, "target"));
                    bl = true;
                }
                if (StringUtil.isNullOrEmpty((String)string4)) {
                    _logger.error((Object)String.format(ExtensionPoint.MISSING_ATTRIBUTE_ERROR, idVersionPair.getId(), string2, "icon"));
                    bl = true;
                }
                if (bl) {
                    return null;
                }
                boolean bl2 = false;
                for (Element element2 : list) {
                    String string8 = XMLUtil.getAttribute((Element)element2, (String)"parent");
                    if (StringUtil.isNullOrEmpty((String)string8) || !string8.equals(string2)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    string7 = "<viewOpenedUponFocus><url>resources/ui/views/objectnavigator/CategoryNodeTreeView.html</url></viewOpenedUponFocus>";
                }
                string6 = "vsphere.core.navigator.solutionsCategory";
                string5 = string;
            }
            String string9 = "<object><title>%s</title><icon>#{%s}</icon><navigationTargetUid>%s</navigationTargetUid><parentUid>%s</parentUid>%s</object>";
            return String.format(string9, string5, string4, string3, string6, string7);
        }
    }
    ,
    GLOBAL_VIEW("globalView", "vise.empty.global.views"){

        @Override
        public String getLegacyFormat(Element element, List<Element> list, String string, IdVersionPair idVersionPair) {
            String string2 = "<object><name>%s</name><contentSpec><sandbox>true</sandbox><url>%s</url><metadata><entry><key>hasTitle</key><value>false</value></entry></metadata></contentSpec></object>";
            String string3 = this.parseAttribute(element, idVersionPair, "uri", true);
            return string3 == null ? null : String.format(string2, string, string3);
        }
    }
    ,
    SUMMARY_VIEW("summary", "vsphere.core.%s.summarySectionViews"){

        @Override
        public String getLegacyFormat(Element element, List<Element> list, String string, IdVersionPair idVersionPair) {
            return "";
        }
    }
    ,
    MONITOR_VIEW("monitorView", "vsphere.core.%s.monitorView"){

        @Override
        public String getLegacyFormat(Element element, List<Element> list, String string, IdVersionPair idVersionPair) {
            return "";
        }
    }
    ,
    MONITOR_CATEGORY("monitor", "vsphere.core.%s.monitorCategories"){

        @Override
        public String getLegacyFormat(Element element, List<Element> list, String string, IdVersionPair idVersionPair) {
            return "";
        }
    }
    ,
    CONFIGURE_VIEW("configureView", "vsphere.core.%s.manageView"){

        @Override
        public String getLegacyFormat(Element element, List<Element> list, String string, IdVersionPair idVersionPair) {
            return "";
        }
    }
    ,
    CONFIGURE_CATEGORY("configure", "vsphere.core.%s.manageCategories"){

        @Override
        public String getLegacyFormat(Element element, List<Element> list, String string, IdVersionPair idVersionPair) {
            return "";
        }
    }
    ,
    ACTION("action", "vise.actions.sets"){

        @Override
        public String getLegacyFormat(Element element, List<Element> list, String string, IdVersionPair idVersionPair) {
            return "";
        }
    }
    ,
    MENU("menu", "vise.menus.context.solutionMenus"){
        private final String ACTION_ID = "actionId";
        private final String SEPARATOR = "separator";
        private final String COMMA_SEPARATOR = ",";
        private final String ACTION_TYPE_XML = "<type>ACTION</type>";
        private final String ACTION_SEPARATOR_XML = "<object><type>SEPARATOR</type></object>";
        private final String ACTION_ID_XML_FORMAT = "<object><type>ACTION</type><uid>%s</uid></object>";
        protected static final String OBJECT_TYPE_XML_FORMAT = "<metadata><objectType>%s</objectType></metadata>";
        private final String SAME_ATTRIBUTE_ELEMENT_ERROR = "[Plugin id: %s, Extension id: %s] '%s' defined as an attribute and a tag element.";

        @Override
        public String getLegacyFormat(Element element, List<Element> list, String string, IdVersionPair idVersionPair) {
            String string2 = XMLUtil.getAttribute((Element)element, (String)"id");
            String string3 = this.getLegacyMenuActionsXml(element);
            if (!string3.contains("<type>ACTION</type>")) {
                _logger.error((Object)String.format(ExtensionPoint.MISSING_DEFINITION_ERROR, idVersionPair.getId(), string2, "actionId"));
                return null;
            }
            return String.format("<object><label>%s</label><type>MENU</type><children>%s</children></object>", string, string3);
        }

        @Override
        protected String getMetadata(Element element, IdVersionPair idVersionPair) {
            Object object22;
            String string = XMLUtil.getAttribute((Element)element, (String)"id");
            String string2 = XMLUtil.getAttribute((Element)element, (String)"objectType");
            List list = XMLUtil.getChildTags((Node)element, (String)"objectType");
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (Object object22 : list) {
                arrayList.add(XMLUtil.getTagValue((Element)object22));
            }
            if (!(arrayList.isEmpty() ^ StringUtil.isNullOrEmpty((String)string2))) {
                if (arrayList.isEmpty()) {
                    _logger.error((Object)String.format(ExtensionPoint.MISSING_ATTRIBUTE_ERROR, idVersionPair.getId(), string, "objectType"));
                } else {
                    _logger.error((Object)String.format("[Plugin id: %s, Extension id: %s] '%s' defined as an attribute and a tag element.", idVersionPair.getId(), string, "objectType"));
                }
                return null;
            }
            if (!StringUtil.isNullOrEmpty((String)string2)) {
                arrayList.add(string2);
            }
            ArrayList arrayList2 = new ArrayList();
            for (String charSequence2 : arrayList) {
                if (OBJECT_BY_TYPE.get(charSequence2) != null) continue;
                arrayList2.add(charSequence2);
            }
            if (!arrayList2.isEmpty()) {
                object22 = arrayList2.iterator();
                while (object22.hasNext()) {
                    String string3 = (String)object22.next();
                    _logger.error((Object)String.format(ExtensionPoint.INVALID_OBJECT_TYPE_ERROR, idVersionPair.getId(), string, string3));
                }
                return null;
            }
            object22 = "";
            StringBuilder stringBuilder = new StringBuilder();
            for (String string4 : arrayList) {
                stringBuilder.append((String)object22);
                object22 = ",";
                stringBuilder.append((String)OBJECT_BY_TYPE.get(string4));
            }
            return String.format(OBJECT_TYPE_XML_FORMAT, stringBuilder.toString());
        }

        private String getLegacyMenuActionsXml(Element element) {
            StringBuilder stringBuilder = new StringBuilder();
            List list = XMLUtil.getChildTags((Node)element);
            for (Element element2 : list) {
                if ("separator".equals(element2.getNodeName())) {
                    stringBuilder.append("<object><type>SEPARATOR</type></object>");
                    continue;
                }
                if (!"actionId".equals(element2.getNodeName())) continue;
                stringBuilder.append(String.format("<object><type>ACTION</type><uid>%s</uid></object>", XMLUtil.getTagValue((Element)element2).trim()));
            }
            return stringBuilder.toString();
        }
    };

    private final String _type;
    private final String _legacyType;
    private static final Log _logger;
    protected static final String MISSING_ATTRIBUTE_ERROR = "[Plugin id: %s, Extension id: %s] Missing '%s' attribute.";
    protected static final String MISSING_DEFINITION_ERROR = "[Plugin id: %s, Extension id: %s] Missing '%s' definition.";
    protected static final String INVALID_OBJECT_TYPE_ERROR = "[Plugin id: %s, Extension id: %s] object type '%s' is not valid.";
    protected static final String EMPTY_METADATA = "<metadata></metadata>";
    protected static final Map<String, String> OBJECT_BY_TYPE;

    private ExtensionPoint(String string2, String string3) {
        this._type = string2;
        this._legacyType = string3;
    }

    final List<ExtensionInfo> parseExtensions(Element element, IdVersionPair idVersionPair) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{element, idVersionPair});
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        List list = XMLUtil.getChildTags((Node)element, (String)this._type);
        String string = "";
        if (!list.isEmpty()) {
            string = this.parseDisplayName(element, idVersionPair);
        }
        String string2 = null;
        for (Element element2 : list) {
            ExtensionInfo extensionInfo = this.parseExtension(element2, list, idVersionPair, string, string2);
            if (extensionInfo == null) continue;
            arrayList.add(extensionInfo);
            string2 = extensionInfo.getId();
        }
        return arrayList;
    }

    protected abstract String getLegacyFormat(Element var1, List<Element> var2, String var3, IdVersionPair var4);

    protected String getMetadata(Element element, IdVersionPair idVersionPair) {
        return EMPTY_METADATA;
    }

    protected final String parseAttribute(Element element, IdVersionPair idVersionPair, String string, boolean bl) {
        String string2 = XMLUtil.getAttribute((Element)element, (String)string);
        if (bl && StringUtil.isNullOrEmpty((String)string2)) {
            _logger.warn((Object)("Ignoring " + this._type + " extension of plugin " + idVersionPair + " with missing required attribute: " + string));
            return null;
        }
        return string2;
    }

    private ExtensionInfo parseExtension(Element element, List<Element> list, IdVersionPair idVersionPair, String string, String string2) {
        String string3 = this.parseAttribute(element, idVersionPair, "id", true);
        String string4 = this.parseAttribute(element, idVersionPair, "objectType", false);
        String string5 = this.getLegacyFormat(element, list, string, idVersionPair);
        String string6 = this.getMetadata(element, idVersionPair);
        if (string3 == null || string5 == null || string6 == null) {
            return null;
        }
        return this.createExtensionInfo(string3, string4, idVersionPair, null, string5, string6, string2);
    }

    private ExtensionInfo createExtensionInfo(String string, Object object, IdVersionPair idVersionPair, String string2, String string3, String string4, String string5) {
        ExtensionInfo extensionInfo = new ExtensionInfo();
        extensionInfo.setId(string);
        String string6 = String.format(this._legacyType, object);
        extensionInfo.setExtendedPointIds(new String[]{string6});
        extensionInfo.setPluginRef(idVersionPair);
        extensionInfo.setObjectType(string2);
        extensionInfo.setObjectXmlStr(string3);
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(string5));
        extensionInfo.setPrecedingIds(hashSet);
        extensionInfo.setMetadataXmlStr(string4);
        return extensionInfo;
    }

    private String parseDisplayName(Element element, IdVersionPair idVersionPair) {
        String string = this.parseAttribute(element, idVersionPair, "nameKey", false);
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.warn((Object)"The nameKey attribute does not exist, using the plugin id instead");
            string = this.parseAttribute(element, idVersionPair, "id", true);
        }
        return string;
    }

    static {
        _logger = LogFactory.getLog(ExtensionPoint.class);
        OBJECT_BY_TYPE = new HashMap<String, String>();
        OBJECT_BY_TYPE.put("vm", "VirtualMachine");
        OBJECT_BY_TYPE.put("cluster", "ClusterComputeResource");
        OBJECT_BY_TYPE.put("datacenter", "Datacenter");
        OBJECT_BY_TYPE.put("datastore", "Datastore");
        OBJECT_BY_TYPE.put("dscluster", "StoragePod");
        OBJECT_BY_TYPE.put("dvPortgroup", "DistributedVirtualPortgroup");
        OBJECT_BY_TYPE.put("dvs", "DistributedVirtualSwitch");
        OBJECT_BY_TYPE.put("folder", "Folder");
        OBJECT_BY_TYPE.put("host", "HostSystem");
        OBJECT_BY_TYPE.put("network", "Network");
        OBJECT_BY_TYPE.put("resourcePool", "ResourcePool");
        OBJECT_BY_TYPE.put("vApp", "VirtualApp");
        OBJECT_BY_TYPE.put("hp", "HostProfile");
    }
}

