/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl.validation;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.OsgiUsageValidationListener;
import com.vmware.vise.extensionfw.OsgiWarningInfo;
import com.vmware.vise.extensionfw.impl.PluginMetadataLookup;
import com.vmware.vise.extensionfw.impl.validation.OsgiUsageValidationCheckBase;
import com.vmware.vise.extensionfw.impl.validation.OsgiValidationUtils;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class CompanyNameMismatchCheck
extends OsgiUsageValidationCheckBase {
    private static final String DESCRIPTION = "Packages exported with reverse company name other than the one specified in the bundle symbolic name";

    @Override
    public void validate(IdVersionPair idVersionPair, PluginMetadataLookup pluginMetadataLookup, OsgiUsageValidationListener osgiUsageValidationListener) {
        List<BundleInfo> list = pluginMetadataLookup.getBundles(idVersionPair);
        for (BundleInfo bundleInfo : list) {
            String string = bundleInfo.getId();
            if (StringUtil.isNullOrEmpty((String)string)) continue;
            String string2 = OsgiValidationUtils.companyPrefix(string);
            List<String> list2 = pluginMetadataLookup.exportedPackagesByBundle(bundleInfo, false);
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = false;
            for (String string3 : list2) {
                if (string3.startsWith(string2)) {
                    bl = true;
                    continue;
                }
                arrayList.add(string3);
            }
            if (!bl || arrayList.isEmpty()) continue;
            OsgiWarningInfo osgiWarningInfo = new OsgiWarningInfo(idVersionPair, DESCRIPTION, OsgiWarningInfo.ObjectType.PACKAGE, string, OsgiWarningInfo.ObjectType.PACKAGE, OsgiValidationUtils.formatList(arrayList));
            this.logWarning(osgiWarningInfo, osgiUsageValidationListener);
        }
    }
}

