/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl.validation;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.OsgiUsageValidationListener;
import com.vmware.vise.extensionfw.OsgiWarningInfo;
import com.vmware.vise.extensionfw.impl.PluginMetadataLookup;
import com.vmware.vise.extensionfw.impl.validation.OsgiUsageValidationCheckBase;
import com.vmware.vise.extensionfw.impl.validation.OsgiValidationUtils;
import com.vmware.vise.util.IdVersionPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NestedLibMultiUsageCheck
extends OsgiUsageValidationCheckBase {
    private static final String DESCRIPTION = "JARs with one and the same name are found in multiple bundles";

    @Override
    public void validate(IdVersionPair idVersionPair, PluginMetadataLookup pluginMetadataLookup, OsgiUsageValidationListener osgiUsageValidationListener) {
        Map<String, List<String>> map = this.createNestedLibToBundlesMap(idVersionPair, pluginMetadataLookup);
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            List<String> list = entry.getValue();
            if (list == null || list.size() <= 1) continue;
            OsgiWarningInfo osgiWarningInfo = new OsgiWarningInfo(idVersionPair, DESCRIPTION, OsgiWarningInfo.ObjectType.JAR, string, OsgiWarningInfo.ObjectType.BUNDLE, OsgiValidationUtils.formatList(list));
            this.logWarning(osgiWarningInfo, "Nested in bundles", osgiUsageValidationListener);
        }
    }

    private Map<String, List<String>> createNestedLibToBundlesMap(IdVersionPair idVersionPair, PluginMetadataLookup pluginMetadataLookup) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        List<BundleInfo> list = pluginMetadataLookup.getBundles(idVersionPair);
        for (BundleInfo bundleInfo : list) {
            List<String> list2 = pluginMetadataLookup.nestedLibrariesByBundle(bundleInfo);
            for (String string : list2) {
                if (string.equals(".")) continue;
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, new ArrayList());
                }
                ((List)hashMap.get(string)).add(bundleInfo.getId());
            }
        }
        return hashMap;
    }
}

