/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl.validation;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.OsgiUsageValidationListener;
import com.vmware.vise.extensionfw.OsgiWarningInfo;
import com.vmware.vise.extensionfw.impl.PluginMetadataLookup;
import com.vmware.vise.extensionfw.impl.validation.OsgiUsageValidationCheckBase;
import com.vmware.vise.extensionfw.impl.validation.OsgiValidationUtils;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.io.StreamUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class NestedLibPackageExportCheck
extends OsgiUsageValidationCheckBase {
    private static final String DESCRIPTION = "Exporting nonexistent packages or packages from nested or imported JARs";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(IdVersionPair idVersionPair, PluginMetadataLookup pluginMetadataLookup, OsgiUsageValidationListener osgiUsageValidationListener) {
        List<BundleInfo> list = pluginMetadataLookup.getBundles(idVersionPair);
        for (BundleInfo bundleInfo : list) {
            try {
                JarFile jarFile = new JarFile(bundleInfo.getLocation());
                try {
                    List<String> list2 = pluginMetadataLookup.exportedPackagesByBundle(bundleInfo, true);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String string : list2) {
                        String string2 = string.replaceAll("\\.", "/");
                        JarEntry jarEntry = jarFile.getJarEntry(string2);
                        if (jarEntry != null) continue;
                        arrayList.add(string);
                    }
                    if (arrayList.isEmpty()) continue;
                    OsgiWarningInfo osgiWarningInfo = new OsgiWarningInfo(idVersionPair, DESCRIPTION, OsgiWarningInfo.ObjectType.BUNDLE, bundleInfo.getId(), OsgiWarningInfo.ObjectType.BUNDLE, OsgiValidationUtils.formatList(arrayList));
                    this.logWarning(osgiWarningInfo, "Exported foreign packages", osgiUsageValidationListener);
                }
                finally {
                    StreamUtil.close((ZipFile)jarFile);
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not open JAR file for reading.", iOException);
            }
        }
    }
}

