/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl.validation;

import com.vmware.vise.extensionfw.OsgiUsageValidationListener;
import com.vmware.vise.extensionfw.OsgiWarningInfo;
import com.vmware.vise.extensionfw.impl.OsgiUsageValidationCheck;
import com.vmware.vise.util.ValidationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.gemini.blueprint.service.ServiceUnavailableException;
import org.slf4j.MDC;

public abstract class OsgiUsageValidationCheckBase
implements OsgiUsageValidationCheck {
    private static final String VALIDATION_CHECK_LOG_FIELD = "validationCheck";
    private static final String WARNING_MESSAGE_LOG_PATTERN = "[%s: %s; %s: %s]";
    private static final Log _logger = LogFactory.getLog(OsgiUsageValidationCheckBase.class);
    private static final Log _medicLogger = LogFactory.getLog((String)"osgiUsageValidator.Logger");

    protected void logError(OsgiWarningInfo osgiWarningInfo, String string, OsgiUsageValidationListener osgiUsageValidationListener) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{osgiWarningInfo, string});
        String string2 = MDC.get((String)VALIDATION_CHECK_LOG_FIELD);
        MDC.put((String)VALIDATION_CHECK_LOG_FIELD, (String)osgiWarningInfo.getValidationCheck());
        String string3 = string.replaceAll("[\n\r]", " ");
        _medicLogger.error((Object)string3);
        MDC.put((String)VALIDATION_CHECK_LOG_FIELD, (String)string2);
        this.notifyListener(osgiUsageValidationListener, osgiWarningInfo);
    }

    protected void logWarning(OsgiWarningInfo osgiWarningInfo, String string, OsgiUsageValidationListener osgiUsageValidationListener) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{osgiWarningInfo});
        String string2 = MDC.get((String)VALIDATION_CHECK_LOG_FIELD);
        MDC.put((String)VALIDATION_CHECK_LOG_FIELD, (String)osgiWarningInfo.getValidationCheck());
        String string3 = String.format(WARNING_MESSAGE_LOG_PATTERN, new Object[]{osgiWarningInfo.getSourceType(), osgiWarningInfo.getSourceRef(), string, osgiWarningInfo.getTargetRefs()});
        string3 = string3.replaceAll("[\n\r]", " ");
        _medicLogger.warn((Object)string3);
        MDC.put((String)VALIDATION_CHECK_LOG_FIELD, (String)string2);
        this.notifyListener(osgiUsageValidationListener, osgiWarningInfo);
    }

    protected void logWarning(OsgiWarningInfo osgiWarningInfo, OsgiUsageValidationListener osgiUsageValidationListener) {
        this.logWarning(osgiWarningInfo, osgiWarningInfo.getTargetType().toString() + "s", osgiUsageValidationListener);
    }

    protected void logInfo(String string) {
        string = string.replaceAll("[\n\r]", " ");
        _medicLogger.info((Object)string);
    }

    private void notifyListener(OsgiUsageValidationListener osgiUsageValidationListener, OsgiWarningInfo osgiWarningInfo) {
        if (osgiUsageValidationListener != null) {
            try {
                osgiUsageValidationListener.validationCheckFailed(osgiWarningInfo);
            }
            catch (ServiceUnavailableException serviceUnavailableException) {
                _logger.debug((Object)"There is no wired listener for validation warnings");
            }
            catch (RuntimeException runtimeException) {
                _logger.error((Object)("Error notifying validation check listener for plugin " + osgiWarningInfo.getPluginPackageRef()), (Throwable)runtimeException);
            }
        }
    }
}

