/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl.validation;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.OsgiUsageValidationListener;
import com.vmware.vise.extensionfw.OsgiWarningInfo;
import com.vmware.vise.extensionfw.impl.PluginMetadataLookup;
import com.vmware.vise.extensionfw.impl.validation.OsgiUsageValidationCheckBase;
import com.vmware.vise.extensionfw.impl.validation.OsgiValidationUtils;
import com.vmware.vise.util.IdVersionPair;
import java.util.ArrayList;
import java.util.List;

public class UnversionedPackageExportCheck
extends OsgiUsageValidationCheckBase {
    private static final String DESCRIPTION = "Export of packages with no version specified";

    @Override
    public void validate(IdVersionPair idVersionPair, PluginMetadataLookup pluginMetadataLookup, OsgiUsageValidationListener osgiUsageValidationListener) {
        List<BundleInfo> list = pluginMetadataLookup.getBundles(idVersionPair);
        for (BundleInfo bundleInfo : list) {
            List<String> list2 = pluginMetadataLookup.exportedPackagesByBundle(bundleInfo, false);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list2) {
                if (string.contains(";version")) continue;
                arrayList.add(string);
            }
            if (arrayList.isEmpty()) continue;
            OsgiWarningInfo osgiWarningInfo = new OsgiWarningInfo(idVersionPair, DESCRIPTION, OsgiWarningInfo.ObjectType.BUNDLE, bundleInfo.getId(), OsgiWarningInfo.ObjectType.PACKAGE, OsgiValidationUtils.formatList(arrayList));
            this.logWarning(osgiWarningInfo, "Unversioned packages", osgiUsageValidationListener);
        }
    }
}

