/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl.virgo;

import com.vmware.vise.extensionfw.impl.DeploymentEventLogger;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.Level;

public class DeploymentEventLoggerImpl
implements DeploymentEventLogger {
    private final EventLogger _medicLogger;
    private static final Map<DeploymentEventLogger.Event, String> EVENTS_TO_CODES;
    private static final Log _logger;

    @Override
    public void info(DeploymentEventLogger.Event event, Object ... objectArray) {
        this.log(event, Level.INFO, objectArray);
    }

    @Override
    public void warn(DeploymentEventLogger.Event event, Object ... objectArray) {
        this.log(event, Level.WARNING, objectArray);
    }

    @Override
    public void error(DeploymentEventLogger.Event event, Object ... objectArray) {
        this.log(event, Level.ERROR, objectArray);
    }

    public DeploymentEventLoggerImpl(EventLogger eventLogger) {
        if (eventLogger == null) {
            throw new IllegalArgumentException("medicLogger cannot be null.");
        }
        this._medicLogger = eventLogger;
    }

    private void log(DeploymentEventLogger.Event event, Level level, Object ... objectArray) {
        String string = EVENTS_TO_CODES.get((Object)event);
        if (string == null) {
            _logger.warn((Object)("Unexpected deployment event key: " + (Object)((Object)event)));
        } else {
            this._medicLogger.log(string, level, objectArray);
        }
    }

    static {
        _logger = LogFactory.getLog(DeploymentEventLoggerImpl.class);
        EVENTS_TO_CODES = new EnumMap<DeploymentEventLogger.Event, String>(DeploymentEventLogger.Event.class);
        EVENTS_TO_CODES.put(DeploymentEventLogger.Event.PACKAGE_DEPLOY_BEGIN, "XF1000I");
        EVENTS_TO_CODES.put(DeploymentEventLogger.Event.PACKAGE_DEPLOY_END, "XF1001I");
        EVENTS_TO_CODES.put(DeploymentEventLogger.Event.PACKAGE_DEPLOY_FAIL, "XF1009E");
        EVENTS_TO_CODES.put(DeploymentEventLogger.Event.PACKAGE_UNDEPLOY_BEGIN, "XF2000I");
        EVENTS_TO_CODES.put(DeploymentEventLogger.Event.PACKAGE_UNDEPLOY_END, "XF2001I");
        EVENTS_TO_CODES.put(DeploymentEventLogger.Event.PACKAGE_UNDEPLOY_FAIL, "XF2009E");
        EVENTS_TO_CODES.put(DeploymentEventLogger.Event.ARTIFACT_ENQUEUE_BEGIN, "XF0010I");
        EVENTS_TO_CODES.put(DeploymentEventLogger.Event.ARTIFACT_ENQUEUE_END, "XF0011I");
        EVENTS_TO_CODES.put(DeploymentEventLogger.Event.ARTIFACT_UNDEPLOY_BEGIN, "XF0020I");
        EVENTS_TO_CODES.put(DeploymentEventLogger.Event.ARTIFACT_UNDEPLOY_END, "XF0021I");
    }
}

