/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.spbm.filters;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;

public class VmsForProfileFilterBuilder
implements QueryFilterBuilder {
    private static final String INVERSE_SUFFIX = "/@deprecatedInverse";
    private final ObjectReferenceService _objectReferenceService;

    public VmsForProfileFilterBuilder(ObjectReferenceService objectReferenceService) {
        this._objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="vmsForStorageProfileFilter")
    public Filter vmsForStorageProfileFilter(String profileId) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{profileId});
        Object profileRef = this._objectReferenceService.getReference(profileId, true);
        ArrayList<PropertyPredicate> relationPredicates = new ArrayList<PropertyPredicate>();
        String forwardRelation = "vm/@deprecatedInverse";
        relationPredicates.add(new PropertyPredicate(forwardRelation, PropertyPredicate.ComparisonOperator.EQUAL, profileRef));
        return new Filter(relationPredicates);
    }

    @QueryFilter(value="vmTemplatesForStorageProfileFilter")
    public Filter vmTemplatesForStorageProfileFilter(String profileId) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{profileId});
        Object profileRef = this._objectReferenceService.getReference(profileId, true);
        ArrayList<PropertyPredicate> relationPredicates = new ArrayList<PropertyPredicate>();
        String forwardRelation = "vmTemplate/@deprecatedInverse";
        relationPredicates.add(new PropertyPredicate(forwardRelation, PropertyPredicate.ComparisonOperator.EQUAL, profileRef));
        return new Filter(relationPredicates);
    }
}

