/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.spbm.impl;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.common.model.PropertyValueData;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.h5.spbm.util.SpbmStringUtil;
import com.vmware.vsphere.client.h5.spbm.util.VStorageObjectManagerUtil;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.impl.PbmServiceUnableToConnectException;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpbmFcdProfilePropertyProvider
implements PropertyProviderBean {
    private static final String STORAGE_PROFILE_VIEW_PRIVILEGE = "StorageProfile.View";
    private static final String DATASTORE_SUMMARY_TYPE = "summary/type";
    private static final String VSAN_TYPE = "vsan";
    private static final Log _logger = LogFactory.getLog(SpbmFcdProfilePropertyProvider.class);
    private final QueryService _queryService;
    private final PbmServiceFactory _pbmServiceFactory;
    private final FeatureStateService _featureStateService;

    public SpbmFcdProfilePropertyProvider(QueryServiceFactory queryServiceFactory, PbmServiceFactory pbmServiceFactory, FeatureStateService featureStateService) {
        this._queryService = queryServiceFactory.getQueryService();
        this._pbmServiceFactory = pbmServiceFactory;
        this._featureStateService = featureStateService;
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="isFcdNamespacePolicySupportedByVc")
    public boolean getIsFcdNamespacePolicySupportedByVc(ManagedObjectReference dsRef) throws Exception {
        return this._featureStateService.isEnabled(Feature.FCD_VSAN) && VcServiceUtil.is66VcOrLaterByServerGuid((String)dsRef.getServerGuid());
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="fcdNamespaceProfileId")
    public ProfileId getFcdNamespaceProfileId(ManagedObjectReference dsRef) throws Exception {
        return VStorageObjectManagerUtil.getFcdNamespaceProfileForDatastore(dsRef);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="fcdNamespaceProfileData")
    public PropertyValueData[] getFcdNamespaceProfileData(ManagedObjectReference dsRef) throws Exception {
        try {
            PbmService pbmService;
            Profile[] profiles;
            ProfileId fcdProfileId;
            boolean hasPrivileges = this.hasPrivileges(ManagedObjectUtil.getRootFolder((String)dsRef.getServerGuid()), STORAGE_PROFILE_VIEW_PRIVILEGE);
            Profile fcdProfile = null;
            if (hasPrivileges && (fcdProfileId = VStorageObjectManagerUtil.getFcdNamespaceProfileForDatastore(dsRef)) != null && (profiles = (pbmService = PbmSessionUtil.getService((String)dsRef.getServerGuid(), (PbmServiceFactory)this._pbmServiceFactory)).getProfileManager().retrieveContent(new ProfileId[]{fcdProfileId})) != null && profiles.length > 0) {
                fcdProfile = profiles[0];
            }
            PropertyValueData result = !hasPrivileges ? PropertyValueData.newInstance((String)SpbmStringUtil.getString("fcd.namespace.policyLabel"), (String)SpbmStringUtil.getString("fcd.namespace.policy.noPermissions")) : PropertyValueData.newInstance((String)SpbmStringUtil.getString("fcd.namespace.policyLabel"), (String)(fcdProfile != null ? fcdProfile.getName() : SpbmStringUtil.getString("na.value")));
            return new PropertyValueData[]{result};
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to retrieve FCD namespace profile.", (Throwable)ex);
            throw PbmUtil.getMethodFault((Exception)((Object)ex));
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve FCD namespace profile.", (Throwable)ex);
            throw PbmUtil.getMethodFault((Exception)ex);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve FCD namespace profile.", (Throwable)ex);
            throw ex;
        }
    }

    private boolean hasPrivileges(ManagedObjectReference entity, String ... privileges) {
        String[] grantedPrivileges = (String[])QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)entity, (String)"grantedPrivileges");
        return AuthorizationUtil.isPrivilegeGranted((String[])privileges, (String[])grantedPrivileges);
    }
}

