/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.proxy;

import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.proxy.Params;
import com.jamonapi.utils.Logger;
import com.jamonapi.utils.Misc;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Date;

public class MonProxy
implements InvocationHandler {
    private Object monitoredObj;
    private String className;
    Params params;
    private static Method EQUALS_METHOD;

    MonProxy(Object monitoredObj, Params params) {
        this.monitoredObj = monitoredObj;
        this.params = params;
        this.className = "(class=" + monitoredObj.getClass().getName() + ")";
    }

    public Object getMonitoredObject() {
        return MonProxy.getMonitoredObject(this.monitoredObj);
    }

    public static Object getMonitoredObject(Object obj) {
        if (obj == null) {
            return null;
        }
        while (Proxy.isProxyClass(obj.getClass()) && Proxy.getInvocationHandler(obj) instanceof MonProxy) {
            MonProxy monProxy = (MonProxy)Proxy.getInvocationHandler(obj);
            obj = monProxy.getMonitoredObject();
        }
        return obj;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean isExceptionDetailEnabled;
        Monitor mon = null;
        boolean isExceptionSummaryEnabled = this.params.isExceptionSummaryEnabled && this.params.isEnabled;
        boolean bl = isExceptionDetailEnabled = this.params.isExceptionDetailEnabled && this.params.isEnabled;
        if (this.params.isInterfaceEnabled && this.params.isEnabled) {
            mon = MonitorFactory.start("MonProxy-Interface " + this.className + ": " + method.toString());
        }
        try {
            if (method.equals(EQUALS_METHOD)) {
                Boolean bl2 = this.equals(args[0]);
                return bl2;
            }
            Object object = method.invoke(this.monitoredObj, args);
            return object;
        }
        catch (InvocationTargetException e) {
            if (isExceptionSummaryEnabled || isExceptionDetailEnabled) {
                String sqlMessage = "";
                Throwable rootCause = e.getCause();
                if (rootCause instanceof SQLException && isExceptionSummaryEnabled) {
                    SQLException sqlException = (SQLException)rootCause;
                    sqlMessage = ",ErrorCode=" + sqlException.getErrorCode() + ",SQLState=" + sqlException.getSQLState();
                }
                if (isExceptionSummaryEnabled) {
                    String detailStackTrace = Misc.getExceptionTrace(rootCause);
                    MonitorFactory.add(new MonKeyImp("MonProxy-Exception: InvocationTargetException", detailStackTrace, "Exception"), 1.0);
                    MonitorFactory.add(new MonKeyImp("MonProxy-Exception: Root cause exception=" + rootCause.getClass().getName() + sqlMessage, detailStackTrace, "Exception"), 1.0);
                    MonitorFactory.add(new MonKeyImp("MonProxy-Exception: " + this.className + " Exception: " + method.toString(), detailStackTrace, "Exception"), 1.0);
                }
                if (isExceptionDetailEnabled) {
                    this.params.exceptionBuffer.addRow(new Object[]{new Long(++this.params.exceptionID), new Date(), Misc.getExceptionTrace(rootCause), method.toString()});
                }
            }
            throw e.getCause();
        }
        finally {
            if (mon != null) {
                mon.stop();
            }
        }
    }

    public boolean equals(Object obj) {
        return this.getMonitoredObject().equals(MonProxy.getMonitoredObject(obj));
    }

    static {
        try {
            EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
        }
        catch (Exception e) {
            Logger.log("Error trying to create reflective equals method.  This error should never happen: " + e);
        }
    }
}

