/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricTimeIntervals;
import com.vmware.opsmgmt.client.advperfcharts.util.Constants;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceMetricIdInfoCollector;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceTimeIntervalRetriever;
import com.vmware.opsmgmt.client.advperfcharts.util.comparator.PerformanceCountersComparator;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceCounterCollector {
    private static final Log _logger = LogFactory.getLog(PerformanceCounterCollector.class);
    private static final String NAME = "name";
    private static final String VM_STORAGE_SYSTEM = "host;storageSystem";
    private static final String HOST_STORAGE_SYSTEM = "storageSystem";
    private static final String HOST_STORAGE_SYSTEM_TYPE = "StorageSystem";
    private static final String STORAGE_DEVICE_INFO_SCSI_LUN = "storageDeviceInfo.scsiLun";
    private static final String STORAGE_DEVICE_INFO_TOPOLOGY_PATH = "storageDeviceInfo.plugStoreTopology.path";
    private static final String HOST_STORAGE_MOUNT_INFO = "fileSystemVolumeInfo.mountInfo";
    private DataService _dataService;
    private ManagedObjectReference _moRef;
    private PerformanceManager _perfManager;
    private int _sampleInterval;
    private Calendar _startDate;
    private Calendar _endDate;

    public PerformanceCounterCollector(ManagedObjectReference managedObjectReference, DataService dataService, PerformanceManager performanceManager) {
        this._moRef = managedObjectReference;
        this._dataService = dataService;
        this._perfManager = performanceManager;
    }

    public ManagedObjectReference getMoRef() {
        return this._moRef;
    }

    public PerformanceManager getPerformanceManager() {
        return this._perfManager;
    }

    public int getSampleInterval() {
        return this._sampleInterval;
    }

    public Date getStartDate() {
        return this._startDate.getTime();
    }

    public Date getEndDate() {
        return this._endDate.getTime();
    }

    public List<PerformanceCounter> getAvailableCounters() {
        PerformanceManager.ProviderSummary providerSummary = PerformanceCounterCollector.queryProviderSummary(this._moRef, this._perfManager);
        Map<String, Object> map = this.retrieveCountersData();
        List<PerformanceCounter> list = this.getCountersForTimeInterval(PerformanceMetricTimeIntervals.REALTIME, providerSummary, map);
        List<PerformanceCounter> list2 = this.getCountersForTimeInterval(PerformanceMetricTimeIntervals.HISTORICAL_STATS, providerSummary, map);
        ArrayList<PerformanceCounter> arrayList = new ArrayList<PerformanceCounter>(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    private Map<String, Object> retrieveCountersData() {
        if (Constants.TYPE_HOST.equals(this._moRef.getType()) || Constants.TYPE_VM.equals(this._moRef.getType())) {
            ResultSet resultSet = null;
            try {
                QuerySpec querySpec = PerformanceCounterCollector.buildQuerySpec(this._moRef);
                resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
            }
            catch (Exception exception) {
                _logger.error((Object)exception);
                return Collections.emptyMap();
            }
            return PerformanceCounterCollector.getCountersData(resultSet);
        }
        return Collections.emptyMap();
    }

    private static QuerySpec buildQuerySpec(ManagedObjectReference managedObjectReference) {
        String string = Constants.TYPE_VM.equals(managedObjectReference.getType()) ? VM_STORAGE_SYSTEM : HOST_STORAGE_SYSTEM;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{NAME};
        propertySpec.type = Constants.TYPE_HOST;
        PropertySpec propertySpec2 = new PropertySpec();
        propertySpec2.propertyNames = new String[]{STORAGE_DEVICE_INFO_TOPOLOGY_PATH, STORAGE_DEVICE_INFO_SCSI_LUN, HOST_STORAGE_MOUNT_INFO};
        propertySpec2.type = HOST_STORAGE_SYSTEM_TYPE;
        propertySpec2.relation = string;
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = QueryUtil.getReferenceUid((Object)managedObjectReference) + ".performanceCountersData";
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.constraint = QueryUtil.createObjectIdentityConstraint((Object)managedObjectReference);
        querySpec.resourceSpec.propertySpecs = new PropertySpec[]{propertySpec, propertySpec2};
        return querySpec;
    }

    private static Map<String, Object> getCountersData(ResultSet resultSet) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (resultSet != null && resultSet.items != null && resultSet.items.length != 0) {
            for (ResultItem resultItem : resultSet.items) {
                PropertyValue[] propertyValueArray = resultItem.properties;
                if (propertyValueArray == null || propertyValueArray.length == 0) continue;
                for (PropertyValue propertyValue : propertyValueArray) {
                    if (NAME.equals(propertyValue.propertyName)) {
                        hashMap.put(NAME, propertyValue.value);
                        continue;
                    }
                    if (STORAGE_DEVICE_INFO_TOPOLOGY_PATH.equals(propertyValue.propertyName)) {
                        hashMap.put(STORAGE_DEVICE_INFO_TOPOLOGY_PATH, propertyValue.value);
                        continue;
                    }
                    if (STORAGE_DEVICE_INFO_SCSI_LUN.equals(propertyValue.propertyName)) {
                        hashMap.put(STORAGE_DEVICE_INFO_SCSI_LUN, propertyValue.value);
                        continue;
                    }
                    if (!HOST_STORAGE_MOUNT_INFO.equals(propertyValue.propertyName)) continue;
                    hashMap.put(HOST_STORAGE_MOUNT_INFO, propertyValue.value);
                }
            }
        }
        return hashMap;
    }

    public List<PerformanceCounter> getAvailableCountersSorted() {
        List<PerformanceCounter> list = this.getAvailableCounters();
        Collections.sort(list, new PerformanceCountersComparator());
        return list;
    }

    private List<PerformanceCounter> getCountersForTimeInterval(PerformanceMetricTimeIntervals performanceMetricTimeIntervals, PerformanceManager.ProviderSummary providerSummary, Map<String, Object> map) {
        PerformanceInfoQuerySpec performanceInfoQuerySpec = new PerformanceInfoQuerySpec();
        performanceInfoQuerySpec.interval = performanceMetricTimeIntervals;
        PerformanceTimeIntervalRetriever performanceTimeIntervalRetriever = new PerformanceTimeIntervalRetriever(this._perfManager, performanceInfoQuerySpec, providerSummary);
        if (!performanceTimeIntervalRetriever.isAvailable()) {
            return Collections.emptyList();
        }
        _logger.debug((Object)("Calling PerformanceManager.queryAvailableMetric(<" + this._moRef + ">, null, null, " + performanceTimeIntervalRetriever.getSampleInterval() + ") "));
        PerformanceManager.MetricId[] metricIdArray = this._perfManager.queryAvailableMetric(this._moRef, null, null, performanceTimeIntervalRetriever.getSampleInterval());
        if (metricIdArray == null) {
            return Collections.emptyList();
        }
        PerformanceMetricIdInfoCollector performanceMetricIdInfoCollector = new PerformanceMetricIdInfoCollector(this._moRef, this._perfManager, this._dataService, metricIdArray, performanceMetricTimeIntervals, map);
        return performanceMetricIdInfoCollector.getPerformanceCounters();
    }

    public static PerformanceManager.ProviderSummary queryProviderSummary(ManagedObjectReference managedObjectReference, PerformanceManager performanceManager) {
        PerformanceManager.ProviderSummary providerSummary;
        String string = managedObjectReference.getType();
        if (ClusterComputeResource.class.getSimpleName().equals(string) || ResourcePool.class.getSimpleName().equals(string) || Datastore.class.getSimpleName().equals(string) || Folder.class.getSimpleName().equals(string) || StoragePod.class.getSimpleName().equals(string)) {
            providerSummary = new PerformanceManager.ProviderSummary();
            providerSummary.setEntity(managedObjectReference);
            providerSummary.setCurrentSupported(false);
            providerSummary.setSummarySupported(true);
            providerSummary.setRefreshRate(Integer.valueOf(-1));
        } else {
            providerSummary = performanceManager.queryProviderSummary(managedObjectReference);
            _logger.debug((Object)("Calling PerformanceManager.queryProviderSummary for: " + managedObjectReference));
        }
        return providerSummary;
    }
}

