/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.CustomDateTimeUnits;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.vim.binding.vim.HistoricalInterval;
import com.vmware.vim.binding.vim.PerformanceManager;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceTimeIntervalRetriever {
    private static final Log _logger = LogFactory.getLog(PerformanceTimeIntervalRetriever.class);
    private final int LAST_DAY_INDEX = 0;
    private final int LAST_WEEK_INDEX = 1;
    private final int LAST_MONTH_INDEX = 2;
    private final int LAST_YEAR_INDEX = 3;
    private PerformanceManager _perfManager;
    private boolean _emptyInterval = false;
    private Date _startDate;
    private Date _endDate;
    private int _sampleInterval;
    private int _maxSample = -1;
    private boolean _available;

    public PerformanceTimeIntervalRetriever(PerformanceManager performanceManager, PerformanceInfoQuerySpec performanceInfoQuerySpec, PerformanceManager.ProviderSummary providerSummary) {
        this._perfManager = performanceManager;
        boolean bl = providerSummary.summarySupported;
        boolean bl2 = providerSummary.currentSupported;
        switch (performanceInfoQuerySpec.interval) {
            case HISTORICAL_STATS: {
                this._available = bl;
                this._emptyInterval = true;
                break;
            }
            case LAST_DAY: {
                this._available = bl;
                if (!bl) break;
                this.retrieveData(0);
                break;
            }
            case LAST_WEEK: {
                this._available = bl;
                if (!bl) break;
                this.retrieveData(1);
                break;
            }
            case LAST_MONTH: {
                this._available = bl;
                if (!bl) break;
                this.retrieveData(2);
                break;
            }
            case LAST_YEAR: {
                this._available = bl;
                if (!bl) break;
                this.retrieveData(3);
                break;
            }
            case RAW_DATA_FEED: {
                this._available = bl;
                if (!bl) break;
                this.retrieveRawData(0);
                break;
            }
            case LAST_VALUE: {
                this._maxSample = 1;
            }
            case REALTIME: {
                this._available = bl2;
                if (!bl2) break;
                this._sampleInterval = providerSummary.refreshRate;
                break;
            }
            case CUSTOM: {
                this._available = bl;
                if (!bl) break;
                this._sampleInterval = -1;
                if (performanceInfoQuerySpec.customPeriodUnits != null && performanceInfoQuerySpec.customPeriodUnitsCount != 0) {
                    this.setCustomDatesForPeriod(performanceInfoQuerySpec.customPeriodUnits, performanceInfoQuerySpec.customPeriodUnitsCount);
                    break;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(performanceInfoQuerySpec.startDate);
                this._startDate = performanceInfoQuerySpec.startDate;
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(performanceInfoQuerySpec.endDate);
                this._endDate = performanceInfoQuerySpec.endDate;
            }
        }
    }

    public Date getStartDate() {
        return this._available ? this._startDate : null;
    }

    public Date getEndDate() {
        return this._available ? this._endDate : null;
    }

    public Integer getSampleInterval() {
        if (this._available) {
            if (this._emptyInterval) {
                return null;
            }
            return this._sampleInterval;
        }
        return -1;
    }

    public int getMaxSample() {
        return this._available ? this._maxSample : -1;
    }

    public boolean isAvailable() {
        return this._available;
    }

    private void retrieveData(int n) {
        _logger.debug((Object)"Calling PerformanceManager.getHistoricalInterval() ");
        HistoricalInterval historicalInterval = this._perfManager.getHistoricalInterval()[n];
        this._sampleInterval = historicalInterval.samplingPeriod;
        this._endDate = Calendar.getInstance().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -1 * historicalInterval.length);
        this._startDate = calendar.getTime();
    }

    private void retrieveRawData(int n) {
        _logger.debug((Object)"Calling PerformanceManager.getHistoricalInterval() ");
        HistoricalInterval historicalInterval = this._perfManager.getHistoricalInterval()[n];
        this._sampleInterval = historicalInterval.samplingPeriod;
    }

    private void setCustomDatesForPeriod(CustomDateTimeUnits customDateTimeUnits, int n) {
        this._endDate = new Date();
        Calendar calendar = Calendar.getInstance();
        switch (customDateTimeUnits) {
            case HOUR: {
                calendar.add(10, -1 * n);
                this._startDate = calendar.getTime();
                break;
            }
            case DAY: {
                calendar.add(5, -1 * n);
                this._startDate = calendar.getTime();
                break;
            }
            case WEEK: {
                calendar.add(3, -1 * n);
                this._startDate = calendar.getTime();
                break;
            }
            case MONTH: {
                calendar.add(2, -1 * n);
                this._startDate = calendar.getTime();
            }
        }
    }
}

