/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl;

import com.vmware.vim.sso.client.DefaultTokenFactory;
import com.vmware.vim.sso.client.GssNegotiationClient;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.SsoAsyncHandler;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.CertificateValidationException;
import com.vmware.vim.sso.client.exception.InternalError;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.ServerCommunicationException;
import com.vmware.vim.sso.client.exception.SsoException;
import com.vmware.vim.sso.client.exception.TimeSynchronizationException;
import com.vmware.vim.sso.client.exception.TokenRequestRejectedException;
import com.vmware.vim.sso.client.impl.GssResult;
import com.vmware.vim.sso.client.impl.RequestBuilder;
import com.vmware.vim.sso.client.impl.RequestBuilderFactory;
import com.vmware.vim.sso.client.impl.ResponseHandler;
import com.vmware.vim.sso.client.impl.ResponseHandlerFactory;
import com.vmware.vim.sso.client.impl.SecurityTokenServiceImpl;
import com.vmware.vim.sso.client.impl.SoapBinding;
import com.vmware.vim.sso.client.impl.Util;
import com.vmware.vim.sso.client.impl.ValidateUtil;
import com.vmware.vim.sso.client.impl.WsSecuritySignature;
import com.vmware.vim.sso.client.impl.WsSecuritySignatureFactory;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

final class GssNegotiationClientImpl
implements GssNegotiationClient {
    private final Logger _log = LoggerFactory.getLogger(GssNegotiationClientImpl.class);
    private static final String INCOMPLETE_SSPI_ERR_MSG = "No token has been acquired. The negotiation should continue";
    private final SoapBinding _binding;
    private final SecurityTokenServiceConfig _config;
    private final RequestBuilderFactory _requestBuilderFactory;
    private final ResponseHandlerFactory _responseHandlerFactory;
    private final boolean _isHokRequest;
    private final TokenSpec _tokenSpec;
    private String _contextId;

    GssNegotiationClientImpl(SoapBinding binding, SecurityTokenServiceConfig config, RequestBuilderFactory requestBuilderFactory, ResponseHandlerFactory responseHandlerFactory, TokenSpec tokenSpec) {
        assert (binding != null);
        assert (config != null);
        assert (requestBuilderFactory != null);
        assert (responseHandlerFactory != null);
        assert (tokenSpec != null);
        this._binding = binding;
        this._config = config;
        this._requestBuilderFactory = requestBuilderFactory;
        this._responseHandlerFactory = responseHandlerFactory;
        this._tokenSpec = tokenSpec;
        this._contextId = null;
        this._isHokRequest = this._tokenSpec.getConfirmation() == TokenSpec.Confirmation.DEFAULT && this._config.getHolderOfKeyConfig() != null;
    }

    @Override
    public GssNegotiationClient.GssNegotiationResult negotiateToken(byte[] leg) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, CertificateValidationException, TimeSynchronizationException {
        boolean isInitial = ValidateUtil.isEmpty(this._contextId);
        this._log.debug("Initial GSS negotiation leg: " + isInitial);
        ResponseHandler<GssResult> responseHanlder = this._responseHandlerFactory.getAcquireTokenByGssResponseHandler();
        RequestBuilder requestBuilder = isInitial ? this._requestBuilderFactory.getInitialAcquireTokenByGssBuilder(this._tokenSpec, leg) : this._requestBuilderFactory.getContinueAcquireTokenByGssBuilder(this._contextId, leg);
        WsSecuritySignature signature = isInitial && this._isHokRequest ? WsSecuritySignatureFactory.createWsSecuritySignatureCertificate(this._config.getHolderOfKeyConfig()) : WsSecuritySignatureFactory.createNullWsSecuritySignature();
        GssResult gssResult = new SecurityTokenServiceImpl.RequestResponseProcessor<GssResult>(requestBuilder, responseHanlder, signature, this._binding).executeRoundtrip();
        Element result = gssResult.getToken();
        this._contextId = gssResult.getConextId();
        SamlToken token = null;
        if (result == null) {
            this._log.warn(INCOMPLETE_SSPI_ERR_MSG);
        } else {
            token = DefaultTokenFactory.createTokenFromDom(result, this._config.getTrustedRootCertificates(), this._config.getClockToleranceInSeconds());
            this._log.info("Successfully acquired token for user: " + Util.getTokenSubjectForLog(token));
        }
        return new GssNegotiationResultImpl(gssResult.getLeg(), token);
    }

    @Override
    public Future<GssNegotiationClient.GssNegotiationResult> negotiateTokenAsync(final byte[] leg, SsoAsyncHandler<GssNegotiationClient.GssNegotiationResult> asyncHandler) {
        ValidateUtil.validateNotNull(asyncHandler, "Asynchronous handler");
        return this._config.getExecutorService().submit(new SecurityTokenServiceImpl.AsyncCommand<GssNegotiationClient.GssNegotiationResult>(asyncHandler){

            @Override
            protected GssNegotiationClient.GssNegotiationResult executeAction() throws SsoException {
                return GssNegotiationClientImpl.this.negotiateToken(leg);
            }
        });
    }

    @Override
    public Future<GssNegotiationClient.GssNegotiationResult> negotiateTokenAsync(byte[] leg) {
        return this.negotiateTokenAsync(leg, new SecurityTokenServiceImpl.NullSsoAsyncHanlder<GssNegotiationClient.GssNegotiationResult>());
    }

    private static final class GssNegotiationResultImpl
    implements GssNegotiationClient.GssNegotiationResult {
        private final byte[] _leg;
        private final SamlToken _token;

        GssNegotiationResultImpl(byte[] leg, SamlToken token) {
            assert (leg != null || token != null);
            this._leg = leg;
            this._token = token;
        }

        @Override
        public SamlToken getToken() {
            return this._token;
        }

        @Override
        public byte[] getLeg() {
            return this._leg;
        }
    }
}

