/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl;

import com.vmware.vim.sso.client.DefaultTokenFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurIDHandler;
import com.vmware.vim.sso.client.SecurIDNegotiator;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.SsoAsyncHandler;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.CertificateValidationException;
import com.vmware.vim.sso.client.exception.InternalError;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.ServerCommunicationException;
import com.vmware.vim.sso.client.exception.TimeSynchronizationException;
import com.vmware.vim.sso.client.exception.TokenRequestRejectedException;
import com.vmware.vim.sso.client.impl.RequestBuilder;
import com.vmware.vim.sso.client.impl.RequestBuilderFactory;
import com.vmware.vim.sso.client.impl.ResponseHandler;
import com.vmware.vim.sso.client.impl.ResponseHandlerFactory;
import com.vmware.vim.sso.client.impl.SecurIDResult;
import com.vmware.vim.sso.client.impl.SecurityTokenServiceImpl;
import com.vmware.vim.sso.client.impl.SoapBinding;
import com.vmware.vim.sso.client.impl.Util;
import com.vmware.vim.sso.client.impl.ValidateUtil;
import com.vmware.vim.sso.client.impl.WsSecuritySignature;
import com.vmware.vim.sso.client.impl.WsSecuritySignatureFactory;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SecurIDNegotiatorImpl
implements SecurIDNegotiator {
    private final Logger _log = LoggerFactory.getLogger(SecurIDNegotiatorImpl.class);
    private static final String INCOMPLETE_SECURID_ERR_MSG = "No token has been acquired. The SecurID negotiation should continue";
    private final SoapBinding binding;
    private final SecurityTokenServiceConfig config;
    private final RequestBuilderFactory requestBuilderFactory;
    private final ResponseHandlerFactory responseHandlerFactory;
    private final boolean isHokRequest;
    private final TokenSpec tokenSpec;

    SecurIDNegotiatorImpl(SoapBinding binding, SecurityTokenServiceConfig config, RequestBuilderFactory requestBuilderFactory, ResponseHandlerFactory responseHandlerFactory, TokenSpec tokenSpec) {
        assert (binding != null);
        assert (config != null);
        assert (requestBuilderFactory != null);
        assert (responseHandlerFactory != null);
        assert (tokenSpec != null);
        this.binding = binding;
        this.config = config;
        this.requestBuilderFactory = requestBuilderFactory;
        this.responseHandlerFactory = responseHandlerFactory;
        this.tokenSpec = tokenSpec;
        this.isHokRequest = this.tokenSpec.getConfirmation() == TokenSpec.Confirmation.DEFAULT && this.config.getHolderOfKeyConfig() != null;
    }

    @Override
    public SecurIDNegotiator.SecurIDNegotiationResult negotiateToken(String userName, String sessionID, SecurIDHandler securIDHandler) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, CertificateValidationException, TimeSynchronizationException {
        boolean isInitial = sessionID == null;
        this._log.debug("Initial SecurID negotiation leg: " + isInitial);
        ResponseHandler<SecurIDResult> responseHanlder = this.responseHandlerFactory.getAcquireTokenBySecurIDResponseHandler();
        RequestBuilder requestBuilder = isInitial ? this.requestBuilderFactory.getInitiateAcquireTokenBySecurIDBuilder(userName, securIDHandler, this.tokenSpec) : this.requestBuilderFactory.getContinueAcquireTokenBySecurIDBuilder(userName, securIDHandler, sessionID);
        WsSecuritySignature signature = isInitial && this.isHokRequest ? WsSecuritySignatureFactory.createWsSecuritySignatureCertificate(this.config.getHolderOfKeyConfig()) : WsSecuritySignatureFactory.createNullWsSecuritySignature();
        SecurIDResult securIDResult = new SecurityTokenServiceImpl.RequestResponseProcessor<SecurIDResult>(requestBuilder, responseHanlder, signature, this.binding).executeRoundtrip();
        Element result = securIDResult.getToken();
        SamlToken token = null;
        if (result == null) {
            this._log.warn(INCOMPLETE_SECURID_ERR_MSG);
        } else {
            token = DefaultTokenFactory.createTokenFromDom(result, this.config.getTrustedRootCertificates(), this.config.getClockToleranceInSeconds());
            this._log.info("Successfully acquired token for user: " + Util.getTokenSubjectForLog(token));
        }
        return new SecurIDNegotiationResultImpl(securIDResult.getSessionID(), token);
    }

    @Override
    public Future<SecurIDNegotiator.SecurIDNegotiationResult> negotiateTokenAsync(final String userName, final String sessionID, final SecurIDHandler securIDHandler, SsoAsyncHandler<SecurIDNegotiator.SecurIDNegotiationResult> asyncHandler) {
        ValidateUtil.validateNotNull(asyncHandler, "Asynchronous handler");
        return this.config.getExecutorService().submit(new SecurityTokenServiceImpl.AsyncCommand<SecurIDNegotiator.SecurIDNegotiationResult>(asyncHandler){

            @Override
            protected SecurIDNegotiator.SecurIDNegotiationResult executeAction() throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, CertificateValidationException, TimeSynchronizationException {
                return SecurIDNegotiatorImpl.this.negotiateToken(userName, sessionID, securIDHandler);
            }
        });
    }

    @Override
    public Future<SecurIDNegotiator.SecurIDNegotiationResult> negotiateTokenAsync(String userName, String sessionID, SecurIDHandler securIDHandler) {
        return this.negotiateTokenAsync(userName, sessionID, securIDHandler, new SecurityTokenServiceImpl.NullSsoAsyncHanlder<SecurIDNegotiator.SecurIDNegotiationResult>());
    }

    private static final class SecurIDNegotiationResultImpl
    implements SecurIDNegotiator.SecurIDNegotiationResult {
        private final String sessionID;
        private final SamlToken token;

        SecurIDNegotiationResultImpl(String sessionID, SamlToken token) {
            this.sessionID = sessionID;
            this.token = token;
        }

        @Override
        public String getSessionID() {
            return this.sessionID;
        }

        @Override
        public SamlToken getToken() {
            return this.token;
        }
    }
}

