/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl.processors.request;

import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurIDHandler;
import com.vmware.vim.sso.client.impl.RequestBuilder;
import com.vmware.vim.sso.client.impl.SoapMessage;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import com.vmware.vim.sso.client.util.codec.Base64;
import com.vmware.vim.sso.client.util.codec.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPPart;
import org.oasis_open.docs.ws_sx.ws_trust._200512.BinaryExchangeType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.LifetimeType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.AttributedString;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.PasscodeString;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SecurityHeaderType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.UsernameTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.AttributedDateTime;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.TimestampType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class RequestBuilderImpl
implements RequestBuilder {
    protected static final String TOKEN_TYPE_SAML2 = "urn:oasis:names:tc:SAML:2.0:assertion";
    private static final String XML_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final Logger _log = LoggerFactory.getLogger(RequestBuilderImpl.class);
    private static final String PROCESS_RST_ERROR = "Error processing request for security token";
    private final int _requestValidityInSeconds;
    private final JAXBContext _jaxbContext;
    private final String _soapAction;

    public RequestBuilderImpl(JAXBContext jaxbContext, int requestValidityInSeconds, String soapAction) {
        assert (jaxbContext != null);
        assert (soapAction != null);
        this._jaxbContext = jaxbContext;
        this._requestValidityInSeconds = requestValidityInSeconds;
        this._soapAction = soapAction;
    }

    @Override
    public final SoapMessage createRequest() throws ParserException {
        org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory wstFactory = new org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory();
        ObjectFactory wsseObjFactory = new ObjectFactory();
        if (_log.isDebugEnabled()) {
            _log.debug("Creating WS-Trust request: " + this.createRedactedDescription() + " with validity " + this._requestValidityInSeconds + "sec.");
        }
        SecurityHeaderType secHeader = this.createSecurityHeader();
        this.addSecurityHeaderInfo(secHeader);
        SoapMessage result = this.wrapToSoapMessage(this.createBody(wstFactory), wsseObjFactory.createSecurity(secHeader));
        this.postProcessRequest(result);
        _log.debug("Finished creating WS-Trust request");
        return result;
    }

    @Override
    public int getRequestValidityInSeconds() {
        return this._requestValidityInSeconds;
    }

    protected abstract JAXBElement<?> createBody(org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory var1) throws ParserException;

    protected abstract void addSecurityHeaderInfo(SecurityHeaderType var1);

    protected abstract void postProcessRequest(SoapMessage var1) throws ParserException;

    protected abstract String createRedactedDescription();

    protected final BinaryExchangeType createBinaryExchangeElement(org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory wstFactory, byte[] data) {
        BinaryExchangeType xchg = wstFactory.createBinaryExchangeType();
        xchg.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        xchg.setValueType("http://schemas.xmlsoap.org/ws/2005/02/trust/spnego");
        xchg.setValue(StringUtils.newStringUtf8(Base64.encodeBase64(data, false)));
        return xchg;
    }

    protected final void insertSamlToken(SoapMessage message, String elementNamespace, String elementLocalName, SamlToken token) throws ParserException {
        SOAPPart messageDocument = message.getMessage().getSOAPPart();
        NodeList targetElement = messageDocument.getElementsByTagNameNS(elementNamespace, elementLocalName);
        if (targetElement == null || targetElement.getLength() != 1) {
            String errMsg = "Error inserting SAML token into the SOAP message. No/Too many " + elementLocalName + " found.";
            _log.debug(errMsg);
            throw new ParserException(errMsg);
        }
        Node copiedToken = token.importTo((Document)messageDocument);
        targetElement.item(0).appendChild(copiedToken);
    }

    protected final LifetimeType createLifetimeElement(long tokenLifetime) {
        assert (tokenLifetime > 0L) : tokenLifetime;
        org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory wstFactory = new org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory();
        LifetimeType lifetime = wstFactory.createLifetimeType();
        org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.ObjectFactory wssuObjFactory = new org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.ObjectFactory();
        AttributedDateTime created = wssuObjFactory.createAttributedDateTime();
        DateFormat wssDateFormat = RequestBuilderImpl.createDateFormatter();
        long now = System.currentTimeMillis();
        String startDate = wssDateFormat.format(new Date(now));
        created.setValue(startDate);
        AttributedDateTime expires = wssuObjFactory.createAttributedDateTime();
        String endDate = wssDateFormat.format(new Date(now + TimeUnit.SECONDS.toMillis(tokenLifetime)));
        expires.setValue(endDate);
        lifetime.setCreated(created);
        lifetime.setExpires(expires);
        if (_log.isDebugEnabled()) {
            _log.debug("Lifitime created with following values -- Create date: " + startDate + " Expire date: " + endDate);
        }
        return lifetime;
    }

    private SoapMessage wrapToSoapMessage(JAXBElement<?> request, JAXBElement<?> secHeader) throws ParserException {
        Element body = this.marshallJaxbElement(request).getDocumentElement();
        Element header = this.marshallJaxbElement(secHeader).getDocumentElement();
        SoapMessage message = new SoapMessage(body, header, this._soapAction);
        return message;
    }

    private Document marshallJaxbElement(JAXBElement<?> jaxbElement) throws ParserException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document result = null;
        try {
            result = dbf.newDocumentBuilder().newDocument();
            this._jaxbContext.createMarshaller().marshal(jaxbElement, (Node)result);
        }
        catch (JAXBException jaxbException) {
            _log.debug(PROCESS_RST_ERROR, (Throwable)jaxbException);
            throw new ParserException(PROCESS_RST_ERROR, jaxbException);
        }
        catch (ParserConfigurationException pce) {
            _log.debug(PROCESS_RST_ERROR, (Throwable)pce);
            throw new ParserException(PROCESS_RST_ERROR, pce);
        }
        return result;
    }

    private SecurityHeaderType createSecurityHeader() {
        ObjectFactory wsseObjFactory = new ObjectFactory();
        org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.ObjectFactory wssuObjFactory = new org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.ObjectFactory();
        SecurityHeaderType secHeader = wsseObjFactory.createSecurityHeaderType();
        secHeader.getAny().add(wssuObjFactory.createTimestamp(this.createTimestamp()));
        _log.debug("Security header successfully created");
        return secHeader;
    }

    private TimestampType createTimestamp() {
        org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.ObjectFactory wssuObjFactory = new org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.ObjectFactory();
        TimestampType timestamp = wssuObjFactory.createTimestampType();
        long now = System.currentTimeMillis();
        Date createDate = new Date(now);
        Date expirationDate = new Date(now + TimeUnit.SECONDS.toMillis(this.getRequestValidityInSeconds()));
        DateFormat wssDateFormat = RequestBuilderImpl.createDateFormatter();
        AttributedDateTime createTime = wssuObjFactory.createAttributedDateTime();
        createTime.setValue(wssDateFormat.format(createDate));
        AttributedDateTime expirationTime = wssuObjFactory.createAttributedDateTime();
        expirationTime.setValue(wssDateFormat.format(expirationDate));
        timestamp.setCreated(createTime);
        timestamp.setExpires(expirationTime);
        if (_log.isDebugEnabled()) {
            _log.debug("Timestamp created with following values -- Create date: " + createTime.getValue() + " Expire date: " + expirationTime.getValue());
        }
        return timestamp;
    }

    private static DateFormat createDateFormatter() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(XML_DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat;
    }

    protected UsernameTokenType createUserNamePassCodeToken(String userName, SecurIDHandler securIDHandler) {
        ObjectFactory wssObjFactory = new ObjectFactory();
        UsernameTokenType userNameToken = wssObjFactory.createUsernameTokenType();
        AttributedString attributedString = wssObjFactory.createAttributedString();
        attributedString.setValue(userName);
        userNameToken.setUsername(attributedString);
        PasscodeString passcode = wssObjFactory.createPasscodeString();
        passcode.setValue(securIDHandler.getPasscode(userName));
        userNameToken.getAny().add(wssObjFactory.createPasscode(passcode));
        if (_log.isDebugEnabled()) {
            _log.debug("Username passcode token for user: " + userName + "created");
        }
        return userNameToken;
    }
}

