/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cm.client;

import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;

public enum CisServiceType {
    CM("com.vmware.cis", "cs.componentmanager"),
    IS("com.vmware.cis", "cs.inventory"),
    KEYVALUE("com.vmware.cis", "cs.keyvalue"),
    AUTHORIZATION("com.vmware.cis", "cs.authorization"),
    SSO("com.vmware.cis", "cs.identity"),
    LICENSE("com.vmware.cis", "cs.license"),
    DS("com.vmware.cis", "cs.ds");

    private final ServiceType _serviceType;

    private CisServiceType(String product, String type) {
        this._serviceType = new ServiceTypeImpl(product, type);
    }

    public String getProduct() {
        return this._serviceType.getProductId();
    }

    public String getType() {
        return this._serviceType.getTypeId();
    }

    public String getFullName() {
        return this.getProduct() + "." + this.getType();
    }

    public ServiceType getServiceType() {
        return this._serviceType;
    }

    private static final class Constants {
        public static final String SEPARATOR = ".";
        public static final String PRODUCT_CIS = "com.vmware.cis";
        public static final String TYPE_CM = "cs.componentmanager";
        public static final String TYPE_IS = "cs.inventory";
        public static final String TYPE_KEYVALUE = "cs.keyvalue";
        public static final String TYPE_AUTHORIZATION = "cs.authorization";
        public static final String TYPE_SSO = "cs.identity";
        public static final String TYPE_LICENSE = "cs.license";
        public static final String TYPE_DS = "cs.ds";

        private Constants() {
        }
    }
}

