/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.api;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QueryCommand;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.Validate;

public final class MockQueryServiceFactory
implements QueryServiceFactory {
    private static final String QUERY_FILTERS_ARE_NOT_THE_SAME_MESSAGE = "The query filters are not the same";
    private int _invocationIndex = 0;
    private final List<Query> _expectedQueries = new ArrayList<Query>();
    private final List<ResultSet> _expectedResults = new ArrayList<ResultSet>();
    private final QueryService _queryService = QueryService.Builder.forProvider(new MockDataProvider()).build();

    @Override
    public QueryService getQueryService() {
        return this._queryService;
    }

    public void expectAndReturn(QueryCommand command, ResultSet resultSet) {
        Validate.notNull((Object)command);
        Validate.notNull((Object)resultSet);
        this._expectedQueries.add(command.getQuery());
        this._expectedResults.add(resultSet);
    }

    private static void assertQueries(Query expectedQuery, Query query) {
        MockQueryServiceFactory.assertSelectedProperties(expectedQuery.getProperties(), query.getProperties());
        MockQueryServiceFactory.assertEquals(expectedQuery.getResourceModels(), query.getResourceModels(), "The query resource models are not the same");
        MockQueryServiceFactory.assertFilter(expectedQuery.getFilter(), query.getFilter());
        MockQueryServiceFactory.assertEquals(expectedQuery.getSortCriteria(), query.getSortCriteria(), "The query sort criteria are not the same");
        MockQueryServiceFactory.assertEquals(expectedQuery.getOffset(), query.getOffset(), "The query offsets are not the same");
        MockQueryServiceFactory.assertEquals(expectedQuery.getLimit(), query.getLimit(), "The query limits are not the same");
        MockQueryServiceFactory.assertEquals(expectedQuery.getWithTotalCount(), query.getWithTotalCount(), "The query withTotalCount flags are not the same");
    }

    private static void assertFilter(Filter expectedFilter, Filter filter) {
        String errorMessage = "The query filters are not the same - expected:<" + expectedFilter + "> but was:<" + filter + ">";
        if (expectedFilter == null && filter == null) {
            return;
        }
        if (expectedFilter == null || filter == null) {
            throw new AssertionError((Object)errorMessage);
        }
        if (!expectedFilter.getOperator().equals((Object)filter.getOperator())) {
            throw new AssertionError((Object)errorMessage);
        }
        if (expectedFilter.getCriteria().size() != filter.getCriteria().size()) {
            throw new AssertionError((Object)errorMessage);
        }
        Iterator<PropertyPredicate> expectedPredicatesIterator = expectedFilter.getCriteria().iterator();
        Iterator<PropertyPredicate> actualPredicatesIterator = filter.getCriteria().iterator();
        while (expectedPredicatesIterator.hasNext()) {
            if (!MockQueryServiceFactory.areEqualPredicates(expectedPredicatesIterator.next(), actualPredicatesIterator.next())) {
                throw new AssertionError((Object)errorMessage);
            }
        }
    }

    private static boolean areEqualPredicates(PropertyPredicate predicate1, PropertyPredicate predicate2) {
        HashSet set2;
        if (!predicate1.getOperator().equals((Object)PropertyPredicate.ComparisonOperator.IN)) {
            return Objects.equals(predicate1, predicate2);
        }
        if (!predicate1.getOperator().equals((Object)predicate2.getOperator())) {
            return false;
        }
        if (predicate1.isIgnoreCase() != predicate2.isIgnoreCase()) {
            return false;
        }
        if (!predicate1.getProperty().equals(predicate2.getProperty())) {
            return false;
        }
        HashSet set1 = new HashSet((Collection)predicate1.getComparableValue());
        return set1.equals(set2 = new HashSet((Collection)predicate2.getComparableValue()));
    }

    private static void assertSelectedProperties(List<String> expectedProperties, List<String> properties) {
        MockQueryServiceFactory.assertEquals(expectedProperties.size(), properties.size(), "The sizes of query properties are not the same");
        for (int i = 0; i < expectedProperties.size(); ++i) {
            String expectedProperty = expectedProperties.get(i);
            String property = properties.get(i);
            MockQueryServiceFactory.assertEquals(expectedProperty, property, "The query properties on position " + i + " are not the same");
        }
    }

    private static void assertEquals(Object expected, Object actual, String msg) {
        if (Objects.equals(expected, actual)) {
            return;
        }
        throw new AssertionError((Object)(msg + " - expected:<" + expected + "> but was:<" + actual + ">"));
    }

    private class MockDataProvider
    implements DataProvider {
        private MockDataProvider() {
        }

        @Override
        public ResultSet executeQuery(Query query) {
            int currentInvocation = MockQueryServiceFactory.this._invocationIndex++;
            if (currentInvocation >= MockQueryServiceFactory.this._expectedQueries.size()) {
                throw new AssertionError((Object)("The query service has been called more times than the recorded expectations:" + query));
            }
            Query expectedQuery = (Query)MockQueryServiceFactory.this._expectedQueries.get(currentInvocation);
            MockQueryServiceFactory.assertQueries(expectedQuery, query);
            return (ResultSet)MockQueryServiceFactory.this._expectedResults.get(currentInvocation);
        }

        @Override
        public QuerySchema getSchema() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

