/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.api.binding;

import com.vmware.cis.data.internal.api.binding.NestedBindingField;
import com.vmware.cis.data.internal.api.binding.NestedRelatedBindingField;
import com.vmware.cis.data.internal.api.binding.PropertyBindingField;
import com.vmware.cis.data.internal.api.binding.QueryBindingDescriptor;
import com.vmware.cis.data.internal.api.binding.QueryBindingField;
import com.vmware.cis.data.internal.api.binding.QueryBindingRelationshipValidator;
import com.vmware.cis.data.internal.provider.ext.alias.AliasPropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.alias.AliasPropertyRepository;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyRepository;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.cis.data.internal.util.ReflectionUtil;
import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public final class QueryBindingParser {
    public static QueryBindingDescriptor parse(Class<?> resultType) {
        QueryBindingDescriptor descriptor = QueryBindingParser.toDescriptor(resultType);
        QueryBindingRelationshipValidator.validate(resultType);
        return descriptor;
    }

    private static QueryBindingDescriptor toDescriptor(Class<?> resultType) {
        QueryBindingParser.validateBindingClass(resultType);
        QueryBinding queryModel = resultType.getAnnotation(QueryBinding.class);
        String resourceModel = queryModel.value();
        ArrayList<QueryBindingField> queryBindingFields = new ArrayList<QueryBindingField>();
        queryBindingFields.addAll(QueryBindingParser.collectAliasQueryBindingFields(resourceModel, resultType));
        queryBindingFields.addAll(QueryBindingParser.collectRelatedQueryBindingFields(resourceModel, resultType));
        queryBindingFields.addAll(QueryBindingParser.collectNestedQueryBindingFields(resultType));
        queryBindingFields.addAll(QueryBindingParser.collectRelatedNestedQueryBindingFields(resourceModel, resultType));
        boolean noAnnotatedMembers = queryBindingFields.isEmpty();
        Validate.isTrue((!noAnnotatedMembers ? 1 : 0) != 0, (String)String.format("The provided class '%s' has no annotated fields.", resultType.getSimpleName()));
        return new QueryBindingDescriptor(resultType, resourceModel, queryBindingFields);
    }

    private static List<QueryBindingField> collectRelatedNestedQueryBindingFields(String resourceModel, Class<?> resultType) {
        assert (resourceModel != null);
        assert (resultType != null);
        ArrayList<QueryBindingField> queryBindingFields = new ArrayList<QueryBindingField>();
        for (Field field : ReflectionUtil.getAllFields(resultType)) {
            NestedRelatedBindingField queryBindingField;
            if (!field.isAnnotationPresent(NestedQueryBinding.class) || field.isAnnotationPresent(NestedQueryBinding.class) && !field.isAnnotationPresent(Relationship.class)) continue;
            try {
                queryBindingField = QueryBindingParser.getNestedRelatedBindingField(resourceModel, field);
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException(String.format("Invalid related nested query binding property declaration '%s' in class '%s'", field.getName(), resultType.getCanonicalName()), ex);
            }
            queryBindingFields.add(queryBindingField);
        }
        return queryBindingFields;
    }

    private static NestedRelatedBindingField getNestedRelatedBindingField(String resourceModel, Field field) {
        assert (resourceModel != null);
        assert (field != null);
        Class<?> fieldType = ReflectionUtil.getType(field);
        QueryBindingDescriptor descriptor = QueryBindingParser.toDescriptor(fieldType);
        QualifiedProperty targetProperty = QualifiedProperty.forModelAndSimpleProperty(descriptor.getResourceModel(), "@modelKey");
        String[] relationships = field.getAnnotation(Relationship.class).value();
        Class relatedPropertyType = field.getType().isArray() ? Object[].class : Object.class;
        RelatedPropertyDescriptor relatedPropertyDescriptor = RelatedPropertyDescriptor.of(resourceModel, field.getName(), relatedPropertyType, relationships, targetProperty.toString(), true);
        return new NestedRelatedBindingField(field, descriptor, relatedPropertyDescriptor);
    }

    private static List<QueryBindingField> collectNestedQueryBindingFields(Class<?> resultType) {
        assert (resultType != null);
        ArrayList<QueryBindingField> queryBindingFields = new ArrayList<QueryBindingField>();
        for (Field field : ReflectionUtil.getAllFields(resultType)) {
            NestedBindingField queryBindingField;
            if (!field.isAnnotationPresent(NestedQueryBinding.class) || field.isAnnotationPresent(Relationship.class)) continue;
            try {
                queryBindingField = QueryBindingParser.getNestedBindingField(field);
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException(String.format("Invalid nested query binding property declaration '%s' in class '%s'", field.getName(), resultType.getCanonicalName()), ex);
            }
            queryBindingFields.add(queryBindingField);
        }
        return queryBindingFields;
    }

    private static NestedBindingField getNestedBindingField(Field field) {
        assert (field != null);
        if (field.getType().isArray()) {
            throw new IllegalArgumentException("Nested binding field cannot be array, unless it is a related nested binding field.");
        }
        QueryBindingDescriptor descriptor = QueryBindingParser.toDescriptor(field.getType());
        return new NestedBindingField(field, descriptor);
    }

    private static List<QueryBindingField> collectRelatedQueryBindingFields(String resourceModel, Class<?> resultType) {
        assert (!StringUtils.isEmpty((String)resourceModel));
        assert (resultType != null);
        Map<Field, RelatedPropertyDescriptor> descriptorsByField = RelatedPropertyRepository.collectRelatedPropertyDescriptorByField(resourceModel, resultType, true);
        ArrayList<QueryBindingField> queryBindingFields = new ArrayList<QueryBindingField>();
        for (Field field : descriptorsByField.keySet()) {
            RelatedPropertyDescriptor descriptor = descriptorsByField.get(field);
            queryBindingFields.add(PropertyBindingField.forRelatedProperty(resultType, field, descriptor));
        }
        return queryBindingFields;
    }

    private static List<QueryBindingField> collectAliasQueryBindingFields(String resourceModel, Class<?> resultType) {
        assert (!StringUtils.isEmpty((String)resourceModel));
        assert (resultType != null);
        Map<Field, AliasPropertyDescriptor> descriptorsByField = AliasPropertyRepository.collectAliasPropertyDescriptorByField(resourceModel, resultType, true);
        ArrayList<QueryBindingField> queryBindingFields = new ArrayList<QueryBindingField>();
        for (Field field : descriptorsByField.keySet()) {
            AliasPropertyDescriptor descriptor = descriptorsByField.get(field);
            queryBindingFields.add(PropertyBindingField.forAliasProperty(resultType, field, descriptor));
        }
        return queryBindingFields;
    }

    private static void validateBindingClass(Class<?> resultType) {
        Validate.isTrue((boolean)resultType.isAnnotationPresent(QueryBinding.class), (String)("The provided class '" + resultType.getSimpleName() + "' is not annotated with @QueryBinding annotation."));
        QueryBinding queryModel = resultType.getAnnotation(QueryBinding.class);
        Validate.isTrue((!StringUtils.isEmpty((String)queryModel.value()) ? 1 : 0) != 0, (String)("The provided class '" + resultType.getSimpleName() + "' has an empty resource model definition."));
        Validate.isTrue((boolean)ReflectionUtil.hasDefaultConstructor(resultType), (String)("The provided class '" + resultType.getSimpleName() + "' has no default constructor."));
    }
}

