/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.internal.provider.ProviderBySchemaLookup;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProviderRepository
implements ProviderBySchemaLookup {
    private static Logger _logger = LoggerFactory.getLogger(ProviderRepository.class);
    private final Map<String, DataProvider> _providerByProperty;
    private final Map<String, DataProvider> _providerByModel;
    private final QuerySchema _schema;

    private ProviderRepository(Map<String, DataProvider> providerByProperty, Map<String, DataProvider> providerByModel, QuerySchema schema) {
        this._providerByProperty = Collections.unmodifiableMap(providerByProperty);
        this._providerByModel = Collections.unmodifiableMap(providerByModel);
        this._schema = schema;
    }

    public static ProviderBySchemaLookup forProviders(Collection<DataProvider> providers) {
        _logger.debug("Creating lookup for providers: {}", providers);
        LinkedHashMap<DataProvider, QuerySchema> schemaByProvider = new LinkedHashMap<DataProvider, QuerySchema>(providers.size());
        for (DataProvider provider : providers) {
            try {
                QuerySchema schema = provider.getSchema();
                schemaByProvider.put(provider, schema);
            }
            catch (Exception e) {
                String providerAsString = provider.toString();
                _logger.error("Ignore data provider '{}' because it failed", (Object)providerAsString, (Object)e);
            }
        }
        return new ProviderRepository(ProviderRepository.toProviderByProperty(schemaByProvider), ProviderRepository.toProviderByModel(schemaByProvider), ProviderRepository.toSchema(ProviderRepository.toModelsByName(schemaByProvider)));
    }

    @Override
    public DataProvider getProviderForProperty(String property) {
        Validate.notEmpty((String)property, (String)"property");
        return this.getProviderForProperty(this._providerByProperty, property);
    }

    @Override
    public DataProvider getProviderForProperties(Collection<String> properties) {
        Validate.notEmpty(properties, (String)"properties");
        return this.getProviderForProperties(properties, this._providerByProperty);
    }

    private DataProvider getProviderForProperties(Collection<String> properties, Map<String, DataProvider> providerByProperty) {
        DataProvider provider = null;
        for (String property : properties) {
            DataProvider currentProvider = this.getProviderForProperty(providerByProperty, property);
            if (provider == null) {
                provider = currentProvider;
            }
            if (currentProvider != null && currentProvider == provider) continue;
            return null;
        }
        return provider;
    }

    private static Map<String, DataProvider> toProviderByProperty(Map<DataProvider, QuerySchema> schemaByProvider) {
        HashMap<String, DataProvider> providerByProperty = new HashMap<String, DataProvider>();
        for (Map.Entry<DataProvider, QuerySchema> e : schemaByProvider.entrySet()) {
            DataProvider provider = e.getKey();
            QuerySchema schema = e.getValue();
            for (Map.Entry<String, QuerySchema.ModelInfo> modelEntry : schema.getModels().entrySet()) {
                String modelName = modelEntry.getKey();
                QuerySchema.ModelInfo modelInfo = modelEntry.getValue();
                ProviderRepository.registerDataProvider(provider, modelName, modelInfo, providerByProperty);
            }
        }
        return providerByProperty;
    }

    private static Map<String, DataProvider> toProviderByModel(Map<DataProvider, QuerySchema> schemaByProvider) {
        HashMap<String, DataProvider> providerByModel = new HashMap<String, DataProvider>();
        for (Map.Entry<DataProvider, QuerySchema> e : schemaByProvider.entrySet()) {
            DataProvider provider = e.getKey();
            QuerySchema schema = e.getValue();
            for (Map.Entry<String, QuerySchema.ModelInfo> modelEntry : schema.getModels().entrySet()) {
                String modelName = modelEntry.getKey();
                if (providerByModel.containsKey(modelName)) continue;
                providerByModel.put(modelName, provider);
            }
        }
        return providerByModel;
    }

    private static Map<String, Collection<QuerySchema.ModelInfo>> toModelsByName(Map<DataProvider, QuerySchema> schemaByProvider) {
        HashMap<String, Collection<QuerySchema.ModelInfo>> modelsByName = new HashMap<String, Collection<QuerySchema.ModelInfo>>();
        for (Map.Entry<DataProvider, QuerySchema> e : schemaByProvider.entrySet()) {
            QuerySchema schema = e.getValue();
            for (Map.Entry<String, QuerySchema.ModelInfo> modelEntry : schema.getModels().entrySet()) {
                String modelName = modelEntry.getKey();
                QuerySchema.ModelInfo modelInfo = modelEntry.getValue();
                ArrayList<QuerySchema.ModelInfo> models = (ArrayList<QuerySchema.ModelInfo>)modelsByName.get(modelName);
                if (models == null) {
                    models = new ArrayList<QuerySchema.ModelInfo>();
                    modelsByName.put(modelName, models);
                }
                models.add(modelInfo);
            }
        }
        return modelsByName;
    }

    private static void registerDataProvider(DataProvider provider, String modelName, QuerySchema.ModelInfo modelInfo, Map<String, DataProvider> providerByProperty) {
        for (Map.Entry<String, QuerySchema.PropertyInfo> propertyEntry : modelInfo.getProperties().entrySet()) {
            String propertyName = propertyEntry.getKey();
            QuerySchema.PropertyInfo propertyInfo = propertyEntry.getValue();
            ProviderRepository.registerDataProvider(provider, modelName, propertyName, propertyInfo, providerByProperty);
        }
    }

    private static void registerDataProvider(DataProvider provider, String modelName, String propertyName, QuerySchema.PropertyInfo propertyInfo, Map<String, DataProvider> providerByProperty) {
        if ("@instanceUuid".equals(propertyName) || "@modelKey".equals(propertyName) || "@type".equals(propertyName)) {
            return;
        }
        String property = QualifiedProperty.forModelAndSimpleProperty(modelName, propertyName).toString();
        DataProvider old = providerByProperty.put(property, provider);
        if (old != null) {
            String msg = String.format("Provider %s overrides property '%s' defined by provider %s", provider, property, old);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public QuerySchema getSchema() {
        return this._schema;
    }

    private static QuerySchema toSchema(Map<String, Collection<QuerySchema.ModelInfo>> modelsByName) {
        HashMap<String, QuerySchema.ModelInfo> models = new HashMap<String, QuerySchema.ModelInfo>(modelsByName.size());
        for (Map.Entry<String, Collection<QuerySchema.ModelInfo>> e : modelsByName.entrySet()) {
            QuerySchema.ModelInfo modelInfo = QuerySchema.ModelInfo.merge(e.getValue());
            models.put(e.getKey(), modelInfo);
        }
        return QuerySchema.forModels(models);
    }

    private DataProvider getProviderForProperty(Map<String, DataProvider> providers, String property) {
        if (PropertyUtil.isModelKey(property)) {
            throw new IllegalArgumentException("Can not determine adapter for model key without resource models");
        }
        if (PropertyUtil.isInstanceUuid(property)) {
            return this._providerByModel.get(QualifiedProperty.forQualifiedName(property).getResourceModel());
        }
        DataProvider dataProvider = providers.get(QualifiedProperty.getRootProperty(property));
        if (dataProvider == null) {
            throw new IllegalArgumentException("No data adapter for property " + property);
        }
        return dataProvider;
    }

    @Override
    public DataProvider getProviderForModel(String model) {
        Validate.notEmpty((String)model, (String)"model");
        DataProvider dataProvider = this._providerByModel.get(model);
        if (dataProvider == null) {
            throw new IllegalArgumentException("There is no registered provider  for model " + model);
        }
        return dataProvider;
    }

    @Override
    public DataProvider getProviderForModels(Collection<String> models) {
        Validate.notEmpty(models);
        DataProvider currentProvider = null;
        for (String model : models) {
            DataProvider dataProvider = this.getProviderForModel(model);
            if (currentProvider == null) {
                currentProvider = dataProvider;
            }
            if (currentProvider == dataProvider) continue;
            return null;
        }
        return currentProvider;
    }
}

