/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.relationship;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.QueryClauseAnalyzer;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyLookup;
import com.vmware.cis.data.internal.provider.ext.relationship.RelationshipHop;
import com.vmware.cis.data.internal.provider.ext.relationship.RelationshipQuery;
import com.vmware.cis.data.internal.provider.ext.relationship.RelationshipQueryExecutor;
import com.vmware.cis.data.internal.provider.ext.relationship.RelationshipQueryFactory;
import com.vmware.cis.data.internal.provider.ext.relationship.SortByRelatedProperty;
import com.vmware.cis.data.internal.provider.util.ResultSetUtil;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

final class FilterByRelatedProperty {
    FilterByRelatedProperty() {
    }

    public static Filter resolveRelatedPropertiesInFilter(Query query, Map<String, RelatedPropertyDescriptor> relatedSortProperties, Map<RelatedPropertyDescriptor, List<Object>> relatedFilterPropertiesOrder, RelatedPropertyLookup relatedPropertyLookup, DataProvider connection) {
        assert (query != null);
        assert (relatedSortProperties != null);
        assert (relatedFilterPropertiesOrder != null);
        assert (relatedPropertyLookup != null);
        assert (connection != null);
        Filter filter = query.getFilter();
        Set<String> filterProperties = QueryClauseAnalyzer.gatherPropertiesFromFilter(filter);
        Map<String, RelatedPropertyDescriptor> relatedFilterProperties = relatedPropertyLookup.getRelatedPropertyDescriptors(Arrays.asList(filterProperties.toArray(new String[filterProperties.size()])));
        if (relatedFilterProperties.isEmpty()) {
            return filter;
        }
        Map<String, SortCriterion> relatedFilterPropertiesSortCriteria = SortByRelatedProperty.getSortCriteriaForRelatedPropertiesInFilter(query.getSortCriteria(), relatedSortProperties.keySet(), relatedFilterProperties.keySet());
        Map<String, PropertyPredicate> propertyPredicatesByRelatedProperty = FilterByRelatedProperty.evaluatePredicatesByRelatedProperty(filter, relatedFilterProperties, relatedFilterPropertiesSortCriteria, connection);
        if (propertyPredicatesByRelatedProperty.isEmpty()) {
            return filter;
        }
        Set<PropertyPredicate> extendedPredicates = FilterByRelatedProperty.prepareExtendedPredicates(filter, propertyPredicatesByRelatedProperty);
        if (extendedPredicates == null) {
            return null;
        }
        FilterByRelatedProperty.collectOrderValuesForSortProperties(relatedSortProperties, relatedFilterPropertiesOrder, propertyPredicatesByRelatedProperty);
        List<PropertyPredicate> mergedPredicates = FilterByRelatedProperty.mergeInPropertyPredicates(extendedPredicates, filter.getOperator());
        if (CollectionUtils.isEmpty(mergedPredicates)) {
            return null;
        }
        return new Filter(mergedPredicates, filter.getOperator());
    }

    private static Map<String, PropertyPredicate> evaluatePredicatesByRelatedProperty(Filter filter, Map<String, RelatedPropertyDescriptor> relatedFilterProperties, Map<String, SortCriterion> relatedFilterPropertiesSortCriteria, DataProvider connection) {
        assert (relatedFilterProperties != null);
        assert (relatedFilterPropertiesSortCriteria != null);
        Map<String, Filter> partialFiltersByRelatedProperty = FilterByRelatedProperty.groupPredicatesByRelatedProperty(filter, relatedFilterProperties);
        if (partialFiltersByRelatedProperty.isEmpty()) {
            return Collections.emptyMap();
        }
        return FilterByRelatedProperty.evaluatePredicatesByRelatedProperty(relatedFilterProperties, partialFiltersByRelatedProperty, relatedFilterPropertiesSortCriteria, connection);
    }

    private static Set<PropertyPredicate> prepareExtendedPredicates(Filter filter, Map<String, PropertyPredicate> propertyPredicatesByRelatedProperty) {
        assert (filter != null);
        assert (propertyPredicatesByRelatedProperty != null);
        List<PropertyPredicate> predicates = filter.getCriteria();
        LinkedHashSet<PropertyPredicate> extendedPredicates = new LinkedHashSet<PropertyPredicate>(predicates.size());
        for (PropertyPredicate predicate : predicates) {
            String predicateProperty = predicate.getProperty();
            if (propertyPredicatesByRelatedProperty.containsKey(predicateProperty)) {
                PropertyPredicate extendedPropertyPredicate = propertyPredicatesByRelatedProperty.get(predicateProperty);
                if (extendedPropertyPredicate == null) {
                    if (!LogicalOperator.AND.equals((Object)filter.getOperator())) continue;
                    return null;
                }
                extendedPredicates.add(extendedPropertyPredicate);
                continue;
            }
            extendedPredicates.add(predicate);
        }
        return extendedPredicates;
    }

    private static void collectOrderValuesForSortProperties(Map<String, RelatedPropertyDescriptor> relatedSortProperties, Map<RelatedPropertyDescriptor, List<Object>> relatedFilterPropertiesOrder, Map<String, PropertyPredicate> propertyPredicatesByRelatedProperty) {
        assert (relatedSortProperties != null);
        assert (relatedFilterPropertiesOrder != null);
        assert (propertyPredicatesByRelatedProperty != null);
        if (relatedSortProperties.isEmpty() || propertyPredicatesByRelatedProperty.isEmpty()) {
            return;
        }
        for (Map.Entry<String, RelatedPropertyDescriptor> relatedSortProperty : relatedSortProperties.entrySet()) {
            PropertyPredicate relatedPropertyPredicate = propertyPredicatesByRelatedProperty.get(relatedSortProperty.getKey());
            if (relatedPropertyPredicate == null) continue;
            List relatedPropertyPredicateValues = (List)relatedPropertyPredicate.getComparableValue();
            relatedFilterPropertiesOrder.put(relatedSortProperty.getValue(), relatedPropertyPredicateValues);
        }
    }

    private static List<PropertyPredicate> mergeInPropertyPredicates(Set<PropertyPredicate> propertyPredicates, LogicalOperator operator) {
        assert (propertyPredicates != null);
        assert (operator != null);
        ArrayList<PropertyPredicate> mergedPropertyPerdicates = new ArrayList<PropertyPredicate>(propertyPredicates.size());
        Map<String, Set<Object>> predicateValuesByProperty = FilterByRelatedProperty.collectInPredicateValues(propertyPredicates, operator);
        HashSet<String> processedMergedPredicates = new HashSet<String>();
        for (PropertyPredicate propertyPredicate : propertyPredicates) {
            if (!PropertyPredicate.ComparisonOperator.IN.equals((Object)propertyPredicate.getOperator())) {
                mergedPropertyPerdicates.add(propertyPredicate);
                continue;
            }
            if (processedMergedPredicates.contains(propertyPredicate.getProperty())) continue;
            Set<Object> propertyPredicateValues = predicateValuesByProperty.get(propertyPredicate.getProperty());
            if (CollectionUtils.isEmpty(propertyPredicateValues)) {
                if (!LogicalOperator.AND.equals((Object)operator)) continue;
                return null;
            }
            mergedPropertyPerdicates.add(new PropertyPredicate(propertyPredicate.getProperty(), PropertyPredicate.ComparisonOperator.IN, new ArrayList<Object>(propertyPredicateValues), propertyPredicate.isIgnoreCase()));
            processedMergedPredicates.add(propertyPredicate.getProperty());
        }
        return mergedPropertyPerdicates;
    }

    private static Map<String, Set<Object>> collectInPredicateValues(Set<PropertyPredicate> propertyPredicates, LogicalOperator operator) {
        assert (propertyPredicates != null);
        assert (operator != null);
        LinkedHashMap<String, Set<Object>> predicateValuesByProperty = new LinkedHashMap<String, Set<Object>>();
        for (PropertyPredicate propertyPredicate : propertyPredicates) {
            if (!PropertyPredicate.ComparisonOperator.IN.equals((Object)propertyPredicate.getOperator())) continue;
            LinkedHashSet propertyPredicateValues = (LinkedHashSet)predicateValuesByProperty.get(propertyPredicate.getProperty());
            if (propertyPredicateValues == null) {
                propertyPredicateValues = new LinkedHashSet((Collection)propertyPredicate.getComparableValue());
                predicateValuesByProperty.put(propertyPredicate.getProperty(), propertyPredicateValues);
                continue;
            }
            if (LogicalOperator.AND.equals((Object)operator)) {
                propertyPredicateValues.retainAll((Collection)propertyPredicate.getComparableValue());
                continue;
            }
            propertyPredicateValues.addAll((Collection)propertyPredicate.getComparableValue());
        }
        return predicateValuesByProperty;
    }

    private static Map<String, Filter> groupPredicatesByRelatedProperty(Filter filter, Map<String, RelatedPropertyDescriptor> relatedPropertyDescriptorsByProperty) {
        LinkedHashMap<String, ArrayList<PropertyPredicate>> predicatesByRelatedProperty = new LinkedHashMap<String, ArrayList<PropertyPredicate>>();
        for (PropertyPredicate filterPropertyPredicate : filter.getCriteria()) {
            String predicateProperty = filterPropertyPredicate.getProperty();
            if (relatedPropertyDescriptorsByProperty.get(predicateProperty) == null) continue;
            ArrayList<PropertyPredicate> relatedPropertyPredicateGroup = (ArrayList<PropertyPredicate>)predicatesByRelatedProperty.get(predicateProperty);
            if (relatedPropertyPredicateGroup == null) {
                relatedPropertyPredicateGroup = new ArrayList<PropertyPredicate>();
                predicatesByRelatedProperty.put(predicateProperty, relatedPropertyPredicateGroup);
            }
            relatedPropertyPredicateGroup.add(filterPropertyPredicate);
        }
        LinkedHashMap filtersByRelatedProperty = new LinkedHashMap();
        for (Map.Entry relatedPropertyPredicatesEntry : predicatesByRelatedProperty.entrySet()) {
            filtersByRelatedProperty.put(relatedPropertyPredicatesEntry.getKey(), new Filter((List)relatedPropertyPredicatesEntry.getValue(), filter.getOperator()));
        }
        return Collections.unmodifiableMap(filtersByRelatedProperty);
    }

    private static Map<String, PropertyPredicate> evaluatePredicatesByRelatedProperty(Map<String, RelatedPropertyDescriptor> relatedPropertyDescriptorsByProperty, Map<String, Filter> partialFiltersByRelatedProperty, Map<String, SortCriterion> relatedFilterPropertiesSortCriteria, DataProvider connection) {
        assert (partialFiltersByRelatedProperty != null);
        HashMap<String, PropertyPredicate> propertyPredicatesByRelatedProperty = new HashMap<String, PropertyPredicate>();
        for (Map.Entry<String, Filter> relatedPropertyPartialFilterEntry : partialFiltersByRelatedProperty.entrySet()) {
            String relatedProperty = relatedPropertyPartialFilterEntry.getKey();
            RelatedPropertyDescriptor relatedPropertyDescriptor = relatedPropertyDescriptorsByProperty.get(relatedProperty);
            Filter relatedPropertyPartialFilter = relatedPropertyPartialFilterEntry.getValue();
            PropertyPredicate relatedPropertyPredicate = FilterByRelatedProperty.prepareFilterPredicateForRelatedProperty(relatedPropertyDescriptor, relatedPropertyPartialFilter, relatedFilterPropertiesSortCriteria.get(relatedProperty), connection);
            propertyPredicatesByRelatedProperty.put(relatedProperty, relatedPropertyPredicate);
        }
        return Collections.unmodifiableMap(propertyPredicatesByRelatedProperty);
    }

    private static PropertyPredicate prepareFilterPredicateForRelatedProperty(RelatedPropertyDescriptor relatedPropertyDescriptor, Filter relatedPropertyPartialFilter, SortCriterion relatedPropertySortCriterion, DataProvider connection) {
        assert (relatedPropertyDescriptor != null);
        assert (relatedPropertyPartialFilter != null);
        ArrayList<RelationshipHop> relationshipHops = new ArrayList<RelationshipHop>();
        List<RelationshipQuery> relationshipQueries = RelationshipQueryFactory.createRelationshipQueriesForFilter(relatedPropertyDescriptor, relationshipHops);
        ResultSet relatedResult = RelationshipQueryExecutor.executeRelationshipQueriesForFilter(relatedPropertyDescriptor.getName(), relationshipQueries, relatedPropertyPartialFilter, relatedPropertySortCriterion, connection);
        if (relatedResult == null || relatedResult.getItems().isEmpty()) {
            return null;
        }
        RelationshipHop lastRelationshipHop = (RelationshipHop)relationshipHops.get(relationshipHops.size() - 1);
        List<Object> relatedPropertyValues = ResultSetUtil.extractNotNullPropertyValues(relatedResult, lastRelationshipHop.getSourceModelProperty());
        if (relatedPropertyValues.isEmpty()) {
            return null;
        }
        return new PropertyPredicate(lastRelationshipHop.getTargetModelProperty(), PropertyPredicate.ComparisonOperator.IN, relatedPropertyValues);
    }
}

