/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.relationship;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import com.vmware.cis.data.internal.provider.ext.aggregated.DefaultAggregatedModels;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class RelationshipClientSideTypeFilter {
    RelationshipClientSideTypeFilter() {
    }

    static boolean mayFilterModelKeysOnClientSide(Query query) {
        assert (query != null);
        for (String property : query.getProperties()) {
            if ("@modelKey".equals(property) || "@type".equals(property)) continue;
            return false;
        }
        if (!RelationshipClientSideTypeFilter.mayFilterOnClientSide(query.getFilter())) {
            return false;
        }
        return RelationshipClientSideTypeFilter.maySortOnClientSide(query.getSortCriteria());
    }

    static ResultSet filterModelKeysOnClientSide(Query query) {
        assert (RelationshipClientSideTypeFilter.mayFilterModelKeysOnClientSide(query));
        List<ManagedObjectReference> filteredResources = RelationshipClientSideTypeFilter.filterResources(query.getResourceModels(), query.getFilter().getCriteria().get(0));
        RelationshipClientSideTypeFilter.orderResources(filteredResources, query.getSortCriteria());
        ResultSet result = RelationshipClientSideTypeFilter.createResult(filteredResources, query);
        return result;
    }

    private static List<ManagedObjectReference> filterResources(Collection<String> resourceModels, PropertyPredicate predicate) {
        ArrayList<ManagedObjectReference> filteredResources = new ArrayList<ManagedObjectReference>();
        Object comparableValue = predicate.getComparableValue();
        if (PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)predicate.getOperator())) {
            ManagedObjectReference mor = (ManagedObjectReference)comparableValue;
            if (RelationshipClientSideTypeFilter.acceptItem(mor, resourceModels)) {
                filteredResources.add(mor);
            }
        } else if (PropertyPredicate.ComparisonOperator.IN.equals((Object)predicate.getOperator())) {
            for (Object value : (Collection)comparableValue) {
                ManagedObjectReference mor = (ManagedObjectReference)value;
                if (!RelationshipClientSideTypeFilter.acceptItem(mor, resourceModels)) continue;
                filteredResources.add(mor);
            }
        } else {
            throw new IllegalArgumentException("Only EQUAL or IN operators are supported for filtering by @type on client-side");
        }
        return filteredResources;
    }

    private static void orderResources(List<ManagedObjectReference> filteredResources, List<SortCriterion> sortCriteria) {
        assert (filteredResources != null);
        if (sortCriteria.isEmpty()) {
            return;
        }
        final int multiplier = SortCriterion.SortDirection.ASCENDING.equals((Object)sortCriteria.get(0).getSortDirection()) ? 1 : -1;
        Collections.sort(filteredResources, new Comparator<ManagedObjectReference>(){

            @Override
            public int compare(ManagedObjectReference o1, ManagedObjectReference o2) {
                return multiplier * o1.getValue().compareTo(o2.getValue());
            }
        });
    }

    private static ResultSet createResult(List<ManagedObjectReference> filteredResources, Query query) {
        int limit = query.getLimit();
        if (limit == 0) {
            assert (query.getWithTotalCount());
            return ResultSet.Builder.properties(new String[0]).totalCount(filteredResources.size()).build();
        }
        List<String> properties = query.getProperties();
        ResultSet.Builder resultBuilder = ResultSet.Builder.properties(properties);
        int offset = query.getOffset();
        long endOfPage = (long)offset + (long)limit;
        long itemCount = 0L;
        for (ManagedObjectReference mor : filteredResources) {
            if (++itemCount > (long)offset) {
                resultBuilder.item((Object)mor, RelationshipClientSideTypeFilter.getPropertyValues(mor, properties));
            }
            if (limit <= 0 || itemCount < endOfPage) continue;
            break;
        }
        if (query.getWithTotalCount()) {
            resultBuilder.totalCount(filteredResources.size());
        }
        return resultBuilder.build();
    }

    private static boolean acceptItem(ManagedObjectReference mor, Collection<String> resourceModels) {
        if (resourceModels.contains(mor.getType())) {
            return true;
        }
        AggregatedModelLookup aggregatedModels = DefaultAggregatedModels.getModelLookup();
        ArrayList<String> resourceModelsWithChildren = new ArrayList<String>(resourceModels);
        for (String resourceModel : resourceModels) {
            resourceModelsWithChildren.addAll(aggregatedModels.getChildrenOfAggregatedModel(resourceModel));
        }
        return resourceModelsWithChildren.contains(mor.getType());
    }

    private static List<Object> getPropertyValues(ManagedObjectReference mor, List<String> properties) {
        assert (mor != null);
        assert (properties != null);
        ArrayList<Object> propertyValues = new ArrayList<Object>(properties.size());
        for (String property : properties) {
            if (PropertyUtil.isModelKey(property)) {
                propertyValues.add(mor);
                continue;
            }
            if (PropertyUtil.isType(property)) {
                propertyValues.add(mor.getType());
                continue;
            }
            throw new IllegalArgumentException("Only @modelKey and/or @type property may be selected for filtering by @type on client-side");
        }
        return propertyValues;
    }

    private static boolean mayFilterOnClientSide(Filter filter) {
        if (filter == null) {
            return false;
        }
        List<PropertyPredicate> predicates = filter.getCriteria();
        if (predicates.size() > 1) {
            return false;
        }
        PropertyPredicate predicate = predicates.get(0);
        if (!PropertyUtil.isModelKey(predicate.getProperty())) {
            return false;
        }
        Object comparableValue = predicate.getComparableValue();
        if (PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)predicate.getOperator())) {
            return comparableValue instanceof ManagedObjectReference;
        }
        if (PropertyPredicate.ComparisonOperator.IN.equals((Object)predicate.getOperator())) {
            Collection collectionValue = (Collection)comparableValue;
            assert (!collectionValue.isEmpty());
            return collectionValue.iterator().next() instanceof ManagedObjectReference;
        }
        return false;
    }

    private static boolean maySortOnClientSide(List<SortCriterion> sortCriteria) {
        if (sortCriteria.isEmpty()) {
            return true;
        }
        if (sortCriteria.size() > 1) {
            return false;
        }
        SortCriterion sortCriterion = sortCriteria.get(0);
        return PropertyUtil.isModelKey(sortCriterion.getProperty());
    }
}

