/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.relationship.invert;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.ext.relationship.invert.RelationshipInversionLookup;
import com.vmware.cis.data.internal.provider.util.ResultSetUtil;
import com.vmware.cis.data.internal.provider.util.filter.KeyPredicateMerger;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.cis.data.internal.util.QueryCopy;
import com.vmware.cis.data.provider.DataProvider;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelationshipInvertor
implements DataProvider {
    private static final Logger _logger = LoggerFactory.getLogger(RelationshipInvertor.class);
    private final DataProvider _dataProvider;
    private final RelationshipInversionLookup _relationshipInversions;

    public RelationshipInvertor(DataProvider dataProvider, RelationshipInversionLookup relationshipInversions) {
        assert (dataProvider != null);
        assert (relationshipInversions != null);
        this._dataProvider = dataProvider;
        this._relationshipInversions = relationshipInversions;
    }

    @Override
    public ResultSet executeQuery(Query query) {
        assert (query != null);
        if (this.skipQuery(query)) {
            _logger.trace("Skip query with no invertible relationships");
            return this._dataProvider.executeQuery(query);
        }
        Filter filter = query.getFilter();
        List<PropertyPredicate> transformed = this.evaluateInvertibleRelationshipPredicates(filter);
        if (transformed.isEmpty()) {
            return ResultSetUtil.emptyResult(query);
        }
        Filter transformedFilter = KeyPredicateMerger.mergeKeyPredicates(RelationshipInvertor.filter(transformed, filter.getOperator()));
        if (KeyPredicateMerger.FILTER_MATCH_NONE == transformedFilter) {
            return ResultSetUtil.emptyResult(query);
        }
        Query transformedQuery = QueryCopy.copy(query).where(transformedFilter).build();
        return this._dataProvider.executeQuery(transformedQuery);
    }

    @Override
    public QuerySchema getSchema() {
        return this._relationshipInversions.addInvertibleRelationships(this._dataProvider.getSchema());
    }

    public String toString() {
        return this._dataProvider.toString();
    }

    private static Filter filter(List<PropertyPredicate> predicates, LogicalOperator logicalOperator) {
        assert (predicates != null);
        assert (logicalOperator != null);
        if (predicates.size() == 1) {
            return new Filter(predicates);
        }
        return new Filter(predicates, logicalOperator);
    }

    private boolean skipQuery(Query query) {
        assert (query != null);
        Filter filter = query.getFilter();
        if (filter == null) {
            return true;
        }
        for (PropertyPredicate predicate : filter.getCriteria()) {
            if (this._relationshipInversions.invert(predicate.getProperty()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private List<PropertyPredicate> evaluateInvertibleRelationshipPredicates(Filter filter) {
        assert (filter != null);
        ArrayList<PropertyPredicate> transformed = new ArrayList<PropertyPredicate>();
        for (PropertyPredicate predicate : filter.getCriteria()) {
            PropertyPredicate t = this.evaluateInvertibleRelationshipPredicate(predicate);
            if (t != null) {
                transformed.add(t);
                continue;
            }
            if (!LogicalOperator.AND.equals((Object)filter.getOperator())) continue;
            _logger.trace("Return empty result because predicate matched no objects: {}", (Object)predicate);
            return Collections.emptyList();
        }
        return transformed;
    }

    private PropertyPredicate evaluateInvertibleRelationshipPredicate(PropertyPredicate predicate) {
        assert (predicate != null);
        String property = predicate.getProperty();
        Collection<String> inverses = this._relationshipInversions.invert(property);
        if (inverses.isEmpty()) {
            return predicate;
        }
        _logger.trace("Relationship '{}' will be inverted to: {}", (Object)property, inverses);
        RelationshipInvertor.validateRelationshipPredicate(predicate);
        Collection<?> foreignKeyValues = RelationshipInvertor.getComparableValues(predicate);
        Collection<?> keys = this.fetchFlat(inverses, foreignKeyValues);
        if (keys.isEmpty()) {
            _logger.trace("Predicate on relationship '{}' matched no objects", (Object)property);
            return null;
        }
        _logger.trace("Replace predicate on relationship '{}' by predicate on keys: {}", (Object)property, keys);
        return RelationshipInvertor.createEqualityPredicate("@modelKey", keys);
    }

    private Collection<?> fetchFlat(Collection<String> properties, Collection<?> keys) {
        assert (properties != null);
        assert (keys != null);
        ArrayList allValues = new ArrayList();
        for (String property : properties) {
            String model = QualifiedProperty.forQualifiedName(property).getResourceModel();
            Collection<?> values = this.fetchPropertyValues(model, property, keys);
            allValues.addAll(values);
        }
        return RelationshipInvertor.distinct(allValues);
    }

    private Collection<?> fetchPropertyValues(String model, String property, Collection<?> keys) {
        assert (model != null);
        assert (property != null);
        assert (keys != null);
        if (keys.isEmpty()) {
            return keys;
        }
        Query query = Query.Builder.select(property).from(model).where(RelationshipInvertor.createEqualityPredicate("@modelKey", keys)).build();
        ResultSet result = this._dataProvider.executeQuery(query);
        Collection<?> flat = RelationshipInvertor.getPropertyValues(result, property);
        return RelationshipInvertor.distinct(flat);
    }

    private static Collection<?> distinct(Collection<?> collection) {
        assert (collection != null);
        return new ArrayList(new LinkedHashSet(collection));
    }

    private static void validateRelationshipPredicate(PropertyPredicate predicate) {
        assert (predicate != null);
        PropertyPredicate.ComparisonOperator op = predicate.getOperator();
        if (!PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)op) && !PropertyPredicate.ComparisonOperator.IN.equals((Object)op)) {
            throw new IllegalArgumentException("Unexpected comparison operator in predicate on relationship: " + predicate);
        }
    }

    private static Collection<?> getPropertyValues(ResultSet result, String property) {
        assert (result != null);
        assert (property != null);
        if (result.getItems().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> values = new ArrayList<Object>(result.getItems().size());
        for (ResourceItem item : result.getItems()) {
            Object value = item.get(property);
            if (value == null) continue;
            if (value.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    values.add(element);
                }
                continue;
            }
            if (value instanceof Collection) {
                Collection elements = (Collection)value;
                values.addAll(elements);
                continue;
            }
            values.add(value);
        }
        return values;
    }

    private static Collection<?> getComparableValues(PropertyPredicate predicate) {
        assert (predicate != null);
        PropertyPredicate.ComparisonOperator op = predicate.getOperator();
        if (PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)op)) {
            return Collections.singletonList(predicate.getComparableValue());
        }
        if (PropertyPredicate.ComparisonOperator.IN.equals((Object)op)) {
            return (Collection)predicate.getComparableValue();
        }
        return Collections.emptyList();
    }

    private static PropertyPredicate createEqualityPredicate(String property, Collection<?> values) {
        Collection<?> comparableValue;
        PropertyPredicate.ComparisonOperator op;
        assert (property != null);
        assert (values != null);
        assert (!values.isEmpty());
        if (values.size() == 1) {
            op = PropertyPredicate.ComparisonOperator.EQUAL;
            comparableValue = values.iterator().next();
        } else {
            op = PropertyPredicate.ComparisonOperator.IN;
            comparableValue = values;
        }
        return new PropertyPredicate(property, op, comparableValue);
    }
}

