/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.util.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public final class KeyPredicateMerger {
    public static final Filter FILTER_MATCH_NONE = new Filter(Collections.singletonList(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, "no-such-key")));

    public static Filter mergeKeyPredicates(Filter filter) {
        PropertyPredicate keyPredicate;
        assert (filter != FILTER_MATCH_NONE);
        if (filter == null) {
            return filter;
        }
        if (filter.getCriteria().size() == 1) {
            return filter;
        }
        if (!KeyPredicateMerger.hasMultipleKeyPredicates(filter.getCriteria())) {
            return filter;
        }
        LogicalOperator logicalOperator = filter.getOperator();
        List<PropertyPredicate> predicates = filter.getCriteria();
        Collection<Collection<?>> inclusionKeySets = KeyPredicateMerger.getInclusionKeySets(predicates);
        Collection<Collection<?>> exclusionKeySets = KeyPredicateMerger.getExclusionKeySets(predicates);
        assert (!inclusionKeySets.isEmpty() || !exclusionKeySets.isEmpty());
        switch (logicalOperator) {
            case AND: {
                keyPredicate = KeyPredicateMerger.createKeyPredicateForConjunction(inclusionKeySets, exclusionKeySets);
                if (keyPredicate != null) break;
                return FILTER_MATCH_NONE;
            }
            case OR: {
                keyPredicate = KeyPredicateMerger.createKeyPredicateForDisjunction(inclusionKeySets, exclusionKeySets);
                if (keyPredicate != null) break;
                return null;
            }
            default: {
                throw new IllegalStateException("Unsupported logical operator : " + (Object)((Object)logicalOperator));
            }
        }
        assert (keyPredicate != null);
        return KeyPredicateMerger.replaceKeyPredicates(filter, keyPredicate);
    }

    private static boolean hasMultipleKeyPredicates(List<PropertyPredicate> predicates) {
        assert (predicates != null);
        boolean hasPredicateOnKey = false;
        for (PropertyPredicate predicate : predicates) {
            if (!KeyPredicateMerger.isKeyPredicate(predicate)) continue;
            if (hasPredicateOnKey) {
                return true;
            }
            hasPredicateOnKey = true;
        }
        return false;
    }

    private static Filter replaceKeyPredicates(Filter filter, PropertyPredicate replacementKeyPredicate) {
        assert (filter != null);
        assert (replacementKeyPredicate != null);
        List<PropertyPredicate> predicates = filter.getCriteria();
        ArrayList<PropertyPredicate> transformed = new ArrayList<PropertyPredicate>(predicates.size());
        transformed.add(replacementKeyPredicate);
        for (PropertyPredicate predicate : predicates) {
            if (KeyPredicateMerger.isKeyPredicate(predicate)) continue;
            transformed.add(predicate);
        }
        if (transformed.size() == 1) {
            return new Filter(transformed);
        }
        return new Filter(transformed, filter.getOperator());
    }

    private static PropertyPredicate createKeyPredicateForConjunction(Collection<Collection<?>> inclusionKeySets, Collection<Collection<?>> exclusionKeySets) {
        assert (inclusionKeySets != null);
        assert (exclusionKeySets != null);
        Collection<?> includedKeys = KeyPredicateMerger.intersection(inclusionKeySets);
        Collection<?> excludedKeys = KeyPredicateMerger.union(exclusionKeySets);
        if (inclusionKeySets.isEmpty()) {
            assert (!excludedKeys.isEmpty());
            return KeyPredicateMerger.keyNotIn(excludedKeys);
        }
        Collection<?> keys = KeyPredicateMerger.minus(includedKeys, excludedKeys);
        if (keys.isEmpty()) {
            return null;
        }
        return KeyPredicateMerger.keyIn(keys);
    }

    private static PropertyPredicate createKeyPredicateForDisjunction(Collection<Collection<?>> inclusionKeySets, Collection<Collection<?>> exclusionKeySets) {
        assert (inclusionKeySets != null);
        assert (exclusionKeySets != null);
        Collection<?> includedKeys = KeyPredicateMerger.union(inclusionKeySets);
        Collection<?> excludedKeys = KeyPredicateMerger.intersection(exclusionKeySets);
        if (exclusionKeySets.isEmpty()) {
            assert (!inclusionKeySets.isEmpty());
            Collection<?> keys = KeyPredicateMerger.union(inclusionKeySets);
            return KeyPredicateMerger.keyIn(keys);
        }
        Collection<?> keys = KeyPredicateMerger.minus(excludedKeys, includedKeys);
        if (keys.isEmpty()) {
            return null;
        }
        return KeyPredicateMerger.keyNotIn(keys);
    }

    private static Collection<?> intersection(Collection<Collection<?>> sets) {
        assert (sets != null);
        if (sets.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<Collection<?>> it = sets.iterator();
        LinkedHashSet intersection = new LinkedHashSet(it.next());
        while (it.hasNext()) {
            intersection.retainAll(it.next());
            if (!intersection.isEmpty()) continue;
            return Collections.emptyList();
        }
        return new ArrayList(intersection);
    }

    private static Collection<?> union(Collection<Collection<?>> sets) {
        assert (sets != null);
        if (sets.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet union = new LinkedHashSet();
        for (Collection<?> set : sets) {
            union.addAll(set);
        }
        return new ArrayList(union);
    }

    private static Collection<?> minus(Collection<?> set1, Collection<?> set2) {
        assert (set1 != null);
        assert (set2 != null);
        if (set1.isEmpty() || set2.isEmpty()) {
            return set1;
        }
        LinkedHashSet diff = new LinkedHashSet(set1);
        diff.removeAll(set2);
        return new ArrayList(diff);
    }

    private static Collection<Collection<?>> getInclusionKeySets(Collection<PropertyPredicate> predicates) {
        assert (predicates != null);
        ArrayList keySets = new ArrayList(predicates.size());
        for (PropertyPredicate predicate : predicates) {
            if (!KeyPredicateMerger.isKeyInclusionPredicate(predicate)) continue;
            Collection<?> keys = KeyPredicateMerger.getComparableValues(predicate);
            keySets.add(keys);
        }
        return keySets;
    }

    private static Collection<Collection<?>> getExclusionKeySets(Collection<PropertyPredicate> predicates) {
        assert (predicates != null);
        ArrayList keySets = new ArrayList(predicates.size());
        for (PropertyPredicate predicate : predicates) {
            if (!KeyPredicateMerger.isKeyExclusionPredicate(predicate)) continue;
            Collection<?> keys = KeyPredicateMerger.getComparableValues(predicate);
            keySets.add(keys);
        }
        return keySets;
    }

    private static boolean isKeyPredicate(PropertyPredicate predicate) {
        return KeyPredicateMerger.isKeyInclusionPredicate(predicate) || KeyPredicateMerger.isKeyExclusionPredicate(predicate);
    }

    private static boolean isKeyInclusionPredicate(PropertyPredicate predicate) {
        assert (predicate != null);
        String property = predicate.getProperty();
        PropertyPredicate.ComparisonOperator op = predicate.getOperator();
        return "@modelKey".equals(property) && (PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)op) || PropertyPredicate.ComparisonOperator.IN.equals((Object)op));
    }

    private static boolean isKeyExclusionPredicate(PropertyPredicate predicate) {
        assert (predicate != null);
        String property = predicate.getProperty();
        PropertyPredicate.ComparisonOperator op = predicate.getOperator();
        return "@modelKey".equals(property) && (PropertyPredicate.ComparisonOperator.NOT_EQUAL.equals((Object)op) || PropertyPredicate.ComparisonOperator.NOT_IN.equals((Object)op));
    }

    private static Collection<?> getComparableValues(PropertyPredicate predicate) {
        assert (predicate != null);
        PropertyPredicate.ComparisonOperator op = predicate.getOperator();
        if (PropertyPredicate.ComparisonOperator.IN.equals((Object)op) || PropertyPredicate.ComparisonOperator.NOT_IN.equals((Object)op)) {
            return (Collection)predicate.getComparableValue();
        }
        return Collections.singletonList(predicate.getComparableValue());
    }

    private static PropertyPredicate keyIn(Collection<?> keys) {
        Collection<?> comparableValue;
        PropertyPredicate.ComparisonOperator op;
        assert (keys != null);
        assert (!keys.isEmpty());
        if (keys.size() == 1) {
            op = PropertyPredicate.ComparisonOperator.EQUAL;
            comparableValue = keys.iterator().next();
        } else {
            op = PropertyPredicate.ComparisonOperator.IN;
            comparableValue = keys;
        }
        return new PropertyPredicate("@modelKey", op, comparableValue);
    }

    private static PropertyPredicate keyNotIn(Collection<?> keys) {
        Collection<?> comparableValue;
        PropertyPredicate.ComparisonOperator op;
        assert (keys != null);
        assert (!keys.isEmpty());
        if (keys.size() == 1) {
            op = PropertyPredicate.ComparisonOperator.NOT_EQUAL;
            comparableValue = keys.iterator().next();
        } else {
            op = PropertyPredicate.ComparisonOperator.NOT_IN;
            comparableValue = keys;
        }
        return new PropertyPredicate("@modelKey", op, comparableValue);
    }
}

