/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.provider.registry;

import com.vmware.cis.data.provider.registry.QueryModelRegistry;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryModelRegistrar {
    private static Logger _logger = LoggerFactory.getLogger(QueryModelRegistrar.class);
    private final QueryModelRegistry _registry;
    private final Class<?> _queryModel;

    public QueryModelRegistrar(QueryModelRegistry registry, Class<?> queryModel) {
        Validate.notNull((Object)registry);
        Validate.notNull(queryModel);
        this._registry = registry;
        this._queryModel = queryModel;
    }

    public void register() {
        this._registry.registerQueryModel(this._queryModel);
        _logger.info("Registered QueryModel {}", (Object)this._queryModel.getName());
    }

    public void unregister() {
        this._registry.unregisterQueryModel(this._queryModel);
        _logger.info("Unregistered QueryModel {}", (Object)this._queryModel.getName());
    }
}

