/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.vmware.vise.util.InArrayPredicate;
import com.vmware.vise.util.Predicate;
import com.vmware.vise.util.reflection.ReflectionUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ArrayUtil {
    public static final Class<?>[] EMPTY_CLASS_ARR = new Class[0];

    public static <T> ArrayList<T> toArrayList(T[] TArray) {
        if (TArray == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(Arrays.asList(TArray));
    }

    public static Boolean contains(Object object, Object[] objectArray) {
        if (objectArray == null) {
            return Boolean.FALSE;
        }
        int n = ArrayUtil.indexOf(objectArray, object, 0, objectArray.length);
        return n >= 0;
    }

    public static <T> T[] toArrayOrNull(Collection<T> collection, Class<T> clazz) {
        T[] TArray = null;
        if (collection == null) {
            return TArray;
        }
        if (collection.size() > 0) {
            TArray = ArrayUtil.toArray(collection, clazz);
        }
        return TArray;
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> clazz) {
        Object[] objectArray = null;
        if (collection == null) {
            objectArray = (Object[])Array.newInstance(clazz, 0);
            return objectArray;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, collection.size());
        objectArray = collection.toArray(objectArray2);
        return objectArray;
    }

    public static <T> Set<T> toSet(T[] TArray) {
        HashSet<T> hashSet = new HashSet<T>();
        if (TArray == null) {
            return hashSet;
        }
        for (T t : TArray) {
            hashSet.add(t);
        }
        return hashSet;
    }

    public static <T> boolean contains(T[] TArray, Predicate<T> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Illegal predicate.");
        }
        if (TArray == null) {
            return false;
        }
        for (T t : TArray) {
            if (!predicate.evaluate(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isNullOrEmpty(List<T> list) {
        if (list == null) {
            return true;
        }
        return list.size() == 0;
    }

    public static <T> boolean isNullOrEmpty(T[] TArray) {
        if (TArray == null) {
            return true;
        }
        return TArray.length == 0;
    }

    public static <T> void reverse(T[] TArray) {
        if (TArray == null || TArray.length < 2) {
            return;
        }
        int n = TArray.length - 1;
        int n2 = TArray.length / 2;
        for (int i = 0; i < n2; ++i) {
            T t = TArray[n];
            TArray[n] = TArray[i];
            TArray[i] = t;
            --n;
        }
    }

    private static <T, E extends T> int indexOf(@Nonnull T[] TArray, @Nullable E e, @Nonnegative int n, @Nonnegative int n2) {
        for (int i = n; i < n2; ++i) {
            boolean bl;
            T t = TArray[i];
            boolean bl2 = e == null ? t == null : (bl = e.equals(t));
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    @SafeVarargs
    public static <T> T[] removeAll(@Nonnull T[] TArray, T ... TArray2) {
        if (TArray2.length == 0) {
            return TArray;
        }
        InArrayPredicate<T> inArrayPredicate = new InArrayPredicate<T>((Equivalence<Object>)Equivalence.equals(), TArray2);
        return ArrayUtil.removeAll(TArray, inArrayPredicate);
    }

    public static <T> T[] removeAll(@Nonnull T[] TArray, @Nonnull Collection<? extends T> collection) {
        if (collection.size() == 0) {
            return TArray;
        }
        com.google.common.base.Predicate predicate = Predicates.in(collection);
        return ArrayUtil.removeAll(TArray, predicate);
    }

    public static <T> T[] removeAll(@Nonnull T[] TArray, @Nonnull com.google.common.base.Predicate<T> predicate) {
        Preconditions.checkNotNull(TArray);
        Preconditions.checkNotNull(predicate);
        int n = TArray.length;
        if (n == 0) {
            return TArray;
        }
        int n2 = 0;
        T[] TArray2 = null;
        for (int i = 0; i < n; ++i) {
            T t = TArray[i];
            if (predicate.apply(t)) {
                if (TArray2 != null) continue;
                TArray2 = ArrayUtil.createArray(TArray, n - 1);
                if (i > 0) {
                    System.arraycopy(TArray, 0, TArray2, 0, i);
                }
                n2 = i;
                continue;
            }
            if (TArray2 == null) continue;
            TArray2[n2] = TArray[i];
            ++n2;
        }
        if (TArray2 != null) {
            if (n2 < TArray2.length) {
                TArray2 = Arrays.copyOf(TArray2, n2);
            }
            return TArray2;
        }
        return TArray;
    }

    @SafeVarargs
    public static <T> T[] retainAll(@Nonnull T[] TArray, T ... TArray2) {
        if (TArray2.length == 0) {
            return ArrayUtil.createArray(TArray, 0);
        }
        InArrayPredicate<T> inArrayPredicate = new InArrayPredicate<T>((Equivalence<Object>)Equivalence.equals(), TArray2);
        return ArrayUtil.retainAll(TArray, inArrayPredicate);
    }

    public static <T> T[] retainAll(@Nonnull T[] TArray, @Nonnull Collection<? extends T> collection) {
        if (collection.size() == 0) {
            return ArrayUtil.createArray(TArray, 0);
        }
        com.google.common.base.Predicate predicate = Predicates.in(collection);
        return ArrayUtil.retainAll(TArray, predicate);
    }

    public static <T> T[] retainAll(@Nonnull T[] TArray, @Nonnull com.google.common.base.Predicate<T> predicate) {
        com.google.common.base.Predicate predicate2 = Predicates.not(predicate);
        return ArrayUtil.removeAll(TArray, predicate2);
    }

    private static <T> T[] createArray(@Nonnull T[] TArray, @Nonnegative int n) {
        Class<?> clazz = TArray.getClass();
        Object[] objectArray = clazz == Object[].class ? new Object[n] : (Object[])Array.newInstance(clazz.getComponentType(), n);
        return objectArray;
    }

    public static <T> T[] removeDuplicates(@Nullable T[] TArray) {
        return ArrayUtil.removeDuplicates(TArray, false, true);
    }

    public static <T> T[] removeDuplicates(@Nullable T[] objectArray, boolean bl, boolean bl2) {
        Object[] objectArray2;
        boolean bl3;
        int n;
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length < 2) {
            return objectArray;
        }
        if (bl2) {
            LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(objectArray.length);
            for (Object object : objectArray) {
                linkedHashSet.add(object);
            }
            Class<?> bl32 = objectArray.getClass().getComponentType();
            Object[] objectArray3 = (Object[])Array.newInstance(bl32, linkedHashSet.size());
            linkedHashSet.toArray(objectArray3);
            return objectArray3;
        }
        int n2 = 1;
        boolean bl4 = false;
        int n3 = objectArray.length;
        for (n = 1; n < n3; ++n) {
            if (ArrayUtil.indexOf(objectArray, objectArray[n], 0, n2) < 0) {
                objectArray[n2] = objectArray[n];
                ++n2;
                continue;
            }
            if (bl) continue;
            bl3 = true;
            break;
        }
        if (bl3) {
            objectArray2 = objectArray.getClass().getComponentType();
            Object[] objectArray4 = (Object[])Array.newInstance(objectArray2, objectArray.length - 1);
            System.arraycopy(objectArray, 0, objectArray4, 0, n2);
            ++n;
            while (n < n3) {
                Object object = objectArray[n];
                if (ArrayUtil.indexOf(objectArray4, object, 0, n2) < 0) {
                    objectArray4[n2] = object;
                    ++n2;
                }
                ++n;
            }
            objectArray = objectArray4;
        }
        if (n2 >= objectArray.length) {
            return objectArray;
        }
        objectArray2 = Arrays.copyOf(objectArray, n2);
        return objectArray2;
    }

    public static <T> T[] removeDuplicates(@Nullable T[] TArray, @Nonnull Comparator<? super T> comparator, boolean bl) {
        Preconditions.checkNotNull(comparator);
        if (TArray == null) {
            return null;
        }
        if (TArray.length < 2) {
            return TArray;
        }
        if (!bl) {
            TArray = Arrays.copyOf(TArray, TArray.length);
        }
        Arrays.sort(TArray, comparator);
        T t = TArray[0];
        int n = 1;
        int n2 = TArray.length;
        for (int i = 1; i < n2; ++i) {
            boolean bl2;
            T t2 = TArray[i];
            boolean bl3 = t2 == null ? t == null : (bl2 = t2.equals(t));
            if (bl2) continue;
            t = t2;
            TArray[n] = t2;
            ++n;
        }
        if (n >= TArray.length) {
            return TArray;
        }
        T[] TArray2 = Arrays.copyOf(TArray, n);
        return TArray2;
    }

    public static <T> void append(List<T> list, Object[] objectArray) {
        if (list == null || objectArray == null || objectArray.length == 0) {
            return;
        }
        for (Object object : objectArray) {
            list.add(object);
        }
    }

    public static <T, E> void append(List<T> list, List<E> list2) {
        if (list == null || list2 == null || list2.isEmpty()) {
            return;
        }
        for (E e : list2) {
            list.add(e);
        }
    }

    public static <T> T[] append(T[] TArray, T t) {
        if (TArray == null) {
            throw new IllegalArgumentException("Target array is null.");
        }
        T[] TArray2 = Arrays.copyOf(TArray, TArray.length + 1);
        TArray2[TArray.length] = t;
        return TArray2;
    }

    public static boolean areEquivalent(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        HashSet<Object> hashSet = new HashSet<Object>(objectArray.length);
        for (Object object : objectArray) {
            hashSet.add(object);
        }
        HashSet hashSet2 = new HashSet(objectArray2.length);
        for (Object object : objectArray2) {
            hashSet2.add(object);
        }
        if (hashSet.size() != hashSet2.size()) {
            return false;
        }
        return hashSet.containsAll(hashSet2);
    }

    public static <T> T[] intersection(T[] TArray, T[] TArray2, Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The array type should not be null.");
        }
        if (TArray == null || TArray2 == null || TArray.length == 0 || TArray2.length == 0) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        LinkedList<T> linkedList = new LinkedList<T>();
        for (T t : TArray) {
            if (!ArrayUtil.contains(t, TArray2).booleanValue()) continue;
            linkedList.add(t);
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, linkedList.size());
        return linkedList.toArray(objectArray);
    }

    public static <T> T[] toSafe(T[] TArray, Class<T> clazz) {
        if (TArray != null) {
            return TArray;
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, 0);
        return objectArray;
    }

    public static Class<?> getFirstItemType(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        return objectArray[0].getClass();
    }

    public static Class<?> getNearestCommonType(@Nullable Object[] objectArray, boolean bl) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            Class<?> clazz = objectArray.getClass().getComponentType();
            return clazz;
        }
        if (objectArray.length == 1) {
            Object object = objectArray[0];
            Class<?> clazz = object != null ? object.getClass() : objectArray.getClass().getComponentType();
            return clazz;
        }
        Class<?> clazz = null;
        HashSet hashSet = new HashSet(objectArray.length);
        for (Object object : objectArray) {
            if (object == null) continue;
            hashSet.add(object.getClass());
        }
        Object[] objectArray2 = hashSet.toArray(EMPTY_CLASS_ARR);
        if (bl) {
            List<Class<?>> list = ReflectionUtil.getCommonSupertypes(objectArray2);
            if (list.size() > 0) {
                clazz = list.get(0);
            }
        } else {
            clazz = ReflectionUtil.getCommonSuperclass(objectArray2);
        }
        if (clazz == null) {
            clazz = objectArray.getClass().getComponentType();
        }
        return clazz;
    }

    public static <T> T[] getTypedArray(Object[] objectArray, Class<T> clazz) {
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length);
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public static Object getTypedArray(Object[] objectArray) {
        Object object = ArrayUtil.getTypedArray(objectArray, false);
        return object;
    }

    public static Object getTypedArray(@Nullable Object[] objectArray, boolean bl) {
        if (objectArray == null) {
            return null;
        }
        Class<?> clazz = ArrayUtil.getNearestCommonType(objectArray, bl);
        return ArrayUtil.getTypedArray(objectArray, clazz);
    }

    public static <T> T[] toTypedArray(List<?> list, Class<T> clazz) {
        if (list == null) {
            return null;
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, list.size());
        objectArray = list.toArray(objectArray);
        return objectArray;
    }
}

