/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.Version;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;

public final class BuildProperties {
    private static final String BUILD_PROPERTIES_FILE = "java-util-build.properties";
    private static final boolean IS_H5_CLIENT;
    private static final boolean IS_RELEASE_BUILD;
    private static final String XSRF_COOKIE_NAME;
    private static final String XSRF_HEADER_NAME;
    private static final Version CLIENT_VERSION;
    private static final boolean USE_EXPERIMENTAL_SDK_FEATURES;

    public static boolean isH5Client() {
        return IS_H5_CLIENT;
    }

    public static String getXsrfCookieName() {
        return XSRF_COOKIE_NAME;
    }

    public static String getXsrfHeaderName() {
        return XSRF_HEADER_NAME;
    }

    public static boolean isReleaseBuild() {
        return IS_RELEASE_BUILD;
    }

    public static Version getClientVersion() {
        return CLIENT_VERSION;
    }

    public static boolean useExperimentalSdkFeatures() {
        return USE_EXPERIMENTAL_SDK_FEATURES;
    }

    static {
        ClassPathResource classPathResource = new ClassPathResource(BUILD_PROPERTIES_FILE, BuildProperties.class.getClassLoader());
        try (InputStream inputStream = classPathResource.getInputStream();){
            Properties properties = new Properties();
            properties.load(inputStream);
            IS_H5_CLIENT = PropertyUtil.getBooleanProperty(properties, "build.isH5Client", false);
            XSRF_COOKIE_NAME = properties.getProperty("build.xsrf.cookie.name");
            XSRF_HEADER_NAME = properties.getProperty("build.xsrf.header.name");
            IS_RELEASE_BUILD = "release".equals(properties.getProperty("build.type"));
            CLIENT_VERSION = new Version(properties.getProperty("build.clientVersion"));
            USE_EXPERIMENTAL_SDK_FEATURES = Boolean.valueOf(properties.getProperty("build.experimental.sdk.features.enabled"));
        }
        catch (IOException iOException) {
            throw new ExceptionInInitializerError(iOException);
        }
    }
}

