/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.ConversionException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import javax.annotation.Nullable;

public class ConversionUtil {
    @Nullable
    public static char[] bytes2chars(@Nullable byte[] byArray) {
        return ConversionUtil.bytes2chars(byArray, (Charset)null);
    }

    @Nullable
    public static char[] bytes2chars(@Nullable byte[] byArray, @Nullable String string) {
        Charset charset;
        try {
            charset = string != null ? Charset.forName(string) : null;
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            throw new ConversionException("Illegal charset name: " + string);
        }
        char[] cArray = ConversionUtil.bytes2chars(byArray, charset);
        return cArray;
    }

    @Nullable
    public static char[] bytes2chars(@Nullable byte[] byArray, @Nullable Charset charset) {
        if (byArray == null) {
            return null;
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharsetDecoder charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
        try {
            CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
            int n = charBuffer.length();
            char[] cArray = new char[n];
            charBuffer.get(cArray, charBuffer.position(), n);
            return cArray;
        }
        catch (Exception exception) {
            throw new ConversionException("Error while decoding bytes to chars. Tried with charset '" + charset.toString() + "'.", exception);
        }
    }

    @Nullable
    public static byte[] chars2bytes(@Nullable char[] cArray) {
        return ConversionUtil.chars2bytes(cArray, (Charset)null);
    }

    @Nullable
    public static byte[] chars2bytes(@Nullable char[] cArray, @Nullable String string) {
        Charset charset = string != null ? Charset.forName(string) : null;
        byte[] byArray = ConversionUtil.chars2bytes(cArray, charset);
        return byArray;
    }

    @Nullable
    public static byte[] chars2bytes(@Nullable char[] cArray, @Nullable Charset charset) {
        if (cArray == null) {
            return null;
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        CharsetEncoder charsetEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT);
        try {
            ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
            int n = byteBuffer.remaining();
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray, byteBuffer.position(), n);
            return byArray;
        }
        catch (Exception exception) {
            throw new ConversionException("Error while encoding chars to bytes. Tried with charset '" + charset.toString() + "'.", exception);
        }
    }
}

