/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.io.ObjectInputStreamEx;
import com.vmware.vise.util.io.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectUtil {
    private static final Log _logger = LogFactory.getLog(ObjectUtil.class);
    private static final char PRETTY_PRINT_INDENT_CHAR = ' ';
    private static final int PRETTY_PRINT_DEFAULT_INDENT = 2;
    private static final String PRETTY_PRINT_PROP_INDENT = ObjectUtil.newIndentString(' ', 2);
    private static final String[] PRETTY_PRINT_PRESET_INDENTS = new String[]{ObjectUtil.newIndentString(' ', 0), ObjectUtil.newIndentString(' ', 2), ObjectUtil.newIndentString(' ', 4), ObjectUtil.newIndentString(' ', 6), ObjectUtil.newIndentString(' ', 8), ObjectUtil.newIndentString(' ', 10), ObjectUtil.newIndentString(' ', 12), ObjectUtil.newIndentString(' ', 14), ObjectUtil.newIndentString(' ', 16), ObjectUtil.newIndentString(' ', 18)};

    public static Object deepCopy(Object object) {
        Object object2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            object2 = objectInputStream.readObject();
        }
        catch (Exception exception) {
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)("Error deep copying object: " + exception.getMessage()));
            }
            object2 = null;
        }
        return object2;
    }

    public static <T> T shallowCopy(T t, Class<? extends T> clazz) {
        if (t == null) {
            return null;
        }
        Field[] fieldArray = t.getClass().getFields();
        try {
            T t2 = clazz.newInstance();
            for (Field field : fieldArray) {
                Object object = field.get(t);
                field.set(t2, object);
            }
            return t2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String objectToString(Object object) {
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        try {
            String string;
            Field[] fieldArray = object.getClass().getFields();
            Method[] methodArray = object.getClass().getMethods();
            for (Field accessibleObject : fieldArray) {
                string = ObjectUtil.getStringRepresentation(object, accessibleObject);
                stringBuilder.append(string);
            }
            for (AccessibleObject accessibleObject : methodArray) {
                string = ObjectUtil.getStringRepresentation(object, (Method)accessibleObject);
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean hasOverridenToString(Object object) {
        assert (object != null);
        try {
            Method method = object.getClass().getMethod("toString", new Class[0]);
            Class<?> clazz = method.getDeclaringClass();
            return !Object.class.equals(clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError();
        }
    }

    private static String getStringRepresentation(Object object, Field field) throws IllegalAccessException {
        assert (object != null);
        assert (field != null);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(field.getName());
        stringBuilder.append(": ");
        Object object2 = field.get(object);
        if (object2 != null && ObjectUtil.hasOverridenToString(object2)) {
            stringBuilder.append(object2.toString());
        } else {
            stringBuilder.append(ObjectUtil.objectToString(object2));
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    private static String getStringRepresentation(Object object, Method method) throws InvocationTargetException, IllegalAccessException {
        Object object2;
        assert (object != null);
        assert (method != null);
        StringBuilder stringBuilder = new StringBuilder();
        if (!ObjectUtil.isGetterMethod(method)) {
            return "";
        }
        stringBuilder.append(ObjectUtil.getMethodAsProperty(method));
        stringBuilder.append(": ");
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        if ((object2 = method.invoke(object, new Object[0])) != null && ObjectUtil.hasOverridenToString(object2)) {
            stringBuilder.append(object2.toString());
        } else {
            stringBuilder.append(ObjectUtil.objectToString(object2));
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    private static boolean isGetterMethod(Method method) {
        assert (method != null);
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        String string = method.getName();
        if ("getClass".equals(string)) {
            return false;
        }
        if (string.startsWith("get") && string.length() >= 4) {
            return true;
        }
        return string.startsWith("is") && string.length() > 2;
    }

    private static String getMethodAsProperty(Method method) {
        assert (method != null);
        String string = method.getName();
        if (string.startsWith("get") && string.length() >= 4) {
            char c = method.getName().charAt(3);
            String string2 = String.valueOf(c).toUpperCase(Locale.ENGLISH) + method.getName().substring(4);
            return string2;
        }
        if (string.startsWith("is") && string.length() >= 3) {
            return string;
        }
        return null;
    }

    public static boolean objectsEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static <T extends Comparable<T>> int compare(T t, T t2) {
        return t == null ? (t2 == null ? 0 : -1) : (t2 == null ? 1 : t.compareTo(t2));
    }

    public static int compare(Object object, Object object2) {
        if (object == null) {
            return object2 == null ? 0 : -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof Comparable) {
            Class<?> clazz;
            Class<?> clazz2 = object.getClass();
            if (clazz2.isAssignableFrom(clazz = object2.getClass())) {
                try {
                    Method method = clazz2.getMethod("compareTo", clazz2);
                    Object object3 = method.invoke(object, object2);
                    return (Integer)object3;
                }
                catch (Exception exception) {
                    throw new UnsupportedOperationException("Invocation of method compareTo failed", exception);
                }
            }
            throw new ClassCastException("Cannot compare incompatible types: " + clazz2 + " and " + clazz);
        }
        throw new ClassCastException("The values must implement " + Comparable.class);
    }

    public static boolean equalsAnyOf(Object object, Object object2) {
        if (object2 == null) {
            return false;
        }
        if (object2 instanceof Collection) {
            Collection collection = (Collection)object2;
            boolean bl = collection.contains(object);
            return bl;
        }
        if (object2.getClass().isArray()) {
            return ObjectUtil.arrayContains(object2, object);
        }
        boolean bl = object2.equals(object);
        return bl;
    }

    public static boolean startsWith(Object object, Object object2) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            if (object2 == null) {
                return false;
            }
            if (object2 instanceof String) {
                String string = (String)object;
                String string2 = (String)object2;
                boolean bl = string.startsWith(string2);
                return bl;
            }
            throw new UnsupportedOperationException("The container is a String, so the prefix must also be a String. Instead, it is " + object2.getClass().getName());
        }
        if (object instanceof List || object.getClass().isArray()) {
            return ObjectUtil.arrayOrListStartsWith(object, object2);
        }
        throw new UnsupportedOperationException("The only supported container types are String, collection and array The provided type is " + object.getClass().getName());
    }

    private static boolean arrayOrListStartsWith(Object object, Object object2) {
        int n;
        if (object == null) {
            return false;
        }
        boolean bl = object instanceof List;
        List list = bl ? (List)object : null;
        int n2 = n = bl ? list.size() : Array.getLength(object);
        if (n == 0) {
            return false;
        }
        if (object2 == null) {
            Object object3 = bl ? list.get(0) : Array.get(object, 0);
            return object3 == null;
        }
        if (object2 instanceof List) {
            List list2 = (List)object2;
            int n3 = list2.size();
            if (n3 > n) {
                return false;
            }
            for (int i = 0; i < n3; ++i) {
                boolean bl2;
                Object object4 = bl ? list.get(i) : Array.get(object, i);
                Object e = list2.get(i);
                boolean bl3 = object4 == null ? e == null : (bl2 = object4.equals(e));
                if (bl2) continue;
                return false;
            }
            return true;
        }
        if (object2.getClass().isArray()) {
            int n4 = Array.getLength(object2);
            if (n4 > n) {
                return false;
            }
            for (int i = 0; i < n4; ++i) {
                boolean bl4;
                Object object5 = bl ? list.get(i) : Array.get(object, i);
                Object object6 = Array.get(object2, i);
                boolean bl5 = object5 == null ? object6 == null : (bl4 = object5.equals(object6));
                if (bl4) continue;
                return false;
            }
            return true;
        }
        Object object7 = bl ? list.get(0) : Array.get(object, 0);
        return object2.equals(object7);
    }

    public static boolean endsWith(Object object, Object object2) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            if (object2 == null) {
                return false;
            }
            if (object2 instanceof String) {
                String string = (String)object;
                String string2 = (String)object2;
                boolean bl = string.endsWith(string2);
                return bl;
            }
            throw new UnsupportedOperationException("The container is a String, so the prefix must also be a String. Instead, it is " + object2.getClass().getName());
        }
        if (object instanceof List || object.getClass().isArray()) {
            return ObjectUtil.arrayOrListEndsWith(object, object2);
        }
        throw new UnsupportedOperationException("The only supported container types are String, collection and array. The provided type is " + object.getClass().getName());
    }

    private static boolean arrayOrListEndsWith(Object object, Object object2) {
        int n;
        if (object == null) {
            return false;
        }
        boolean bl = object instanceof List;
        List list = bl ? (List)object : null;
        int n2 = n = bl ? list.size() : Array.getLength(object);
        if (n == 0) {
            return false;
        }
        if (object2 == null) {
            int n3 = n - 1;
            Object object3 = bl ? list.get(n3) : Array.get(object, n3);
            return object3 == null;
        }
        if (object2 instanceof List) {
            List list2 = (List)object2;
            int n4 = list2.size();
            if (n4 > n) {
                return false;
            }
            int n5 = n - 1;
            for (int i = n4 - 1; i >= 0; --i) {
                boolean bl2;
                Object object4 = bl ? list.get(n5) : Array.get(object, n5);
                Object e = list2.get(i);
                boolean bl3 = object4 == null ? e == null : (bl2 = object4.equals(e));
                if (!bl2) {
                    return false;
                }
                --n5;
            }
            return true;
        }
        if (object2.getClass().isArray()) {
            int n6 = Array.getLength(object2);
            if (n6 > n) {
                return false;
            }
            int n7 = n - 1;
            for (int i = n6 - 1; i >= 0; --i) {
                boolean bl4;
                Object object5 = bl ? list.get(n7) : Array.get(object, n7);
                Object object6 = Array.get(object2, i);
                boolean bl5 = object5 == null ? object6 == null : (bl4 = object5.equals(object6));
                if (!bl4) {
                    return false;
                }
                --n7;
            }
            return true;
        }
        int n8 = n - 1;
        Object object7 = bl ? list.get(n8) : Array.get(object, n8);
        return object2.equals(object7);
    }

    public static boolean contains(Object object, Object object2) {
        if (object == null) {
            return false;
        }
        ContainerType containerType = ContainerType.determineContainerType(object);
        return ObjectUtil.contains(object, object2, containerType);
    }

    private static boolean contains(Object object, Object object2, ContainerType containerType) {
        assert (object != null) : "The container should not be null";
        switch (containerType) {
            case STRING: {
                if (object2 == null) {
                    return false;
                }
                if (object2 instanceof CharSequence) {
                    String string = (String)object;
                    boolean bl = string.contains((CharSequence)object2);
                    return bl;
                }
                return false;
            }
            case COLLECTION: {
                Collection collection = (Collection)object;
                boolean bl = collection.contains(object2);
                return bl;
            }
            case ARRAY: {
                return ObjectUtil.arrayContains(object, object2);
            }
        }
        throw new UnsupportedOperationException("The only supported containers are Strings, collections and arrays. The container type is: " + (Object)((Object)containerType));
    }

    private static boolean arrayContains(Object object, Object object2) {
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object3 = Array.get(object, i);
            if ((object2 != null || object3 != null) && (object2 == null || !object2.equals(object3))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyOf(Object object, Object object2) {
        if (object == null) {
            return false;
        }
        ContainerType containerType = ContainerType.determineContainerType(object);
        if (object2 == null) {
            return ObjectUtil.contains(object, object2, containerType);
        }
        if (object2 instanceof Collection) {
            Collection collection = (Collection)object2;
            for (Object e : collection) {
                if (!ObjectUtil.contains(object, e, containerType)) continue;
                return true;
            }
        } else if (object2.getClass().isArray()) {
            int n = Array.getLength(object2);
            for (int i = 0; i < n; ++i) {
                Object object3 = Array.get(object2, i);
                if (!ObjectUtil.contains(object, object3, containerType)) continue;
                return true;
            }
        }
        boolean bl = ObjectUtil.contains(object, object2, containerType);
        return bl;
    }

    public static boolean matches(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object;
            String string2 = (String)object2;
            boolean bl = string.matches(string2);
            return bl;
        }
        throw new UnsupportedOperationException("Only String matching is supported at the moment");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromByteArray(byte[] byArray) {
        Object object = null;
        ObjectInputStreamEx objectInputStreamEx = null;
        try {
            objectInputStreamEx = new ObjectInputStreamEx(Thread.currentThread().getContextClassLoader(), new ByteArrayInputStream(byArray));
            object = objectInputStreamEx.readObject();
            StreamUtil.close(objectInputStreamEx);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
        finally {
            StreamUtil.close(objectInputStreamEx);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(Object object) {
        byte[] byArray;
        block5: {
            byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                byArray = byteArrayOutputStream.toByteArray();
                StreamUtil.close(objectOutputStream);
            }
            catch (Exception exception) {
                _logger.error((Object)exception);
                break block5;
            }
            finally {
                StreamUtil.close(objectOutputStream);
                StreamUtil.close(byteArrayOutputStream);
            }
            StreamUtil.close(byteArrayOutputStream);
        }
        return byArray;
    }

    public static int getHashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public static int getHashCode(boolean bl) {
        return bl ? 1 : 0;
    }

    public static String prettyPrint(Object object) {
        try {
            return ObjectUtil.prettyPrint(object, 0, new HashSet<Object>());
        }
        catch (Exception exception) {
            return "pprint error:" + exception.getMessage();
        }
    }

    private static String prettyPrint(Object object, int n, Set<Object> set) {
        Class<?> clazz;
        if (object == null) {
            return "null";
        }
        if (set.contains(object)) {
            return "recursion@home";
        }
        set.add(object);
        StringBuffer stringBuffer = new StringBuffer();
        String string = n < 10 ? PRETTY_PRINT_PRESET_INDENTS[n] : ObjectUtil.newIndentString(' ', n * 2);
        stringBuffer.append(clazz.getCanonicalName());
        if (clazz.isArray()) {
            stringBuffer.append(":[\n");
            for (int i = 0; i < Array.getLength(object); ++i) {
                Object object2 = Array.get(object, i);
                stringBuffer.append(PRETTY_PRINT_PROP_INDENT + string);
                stringBuffer.append(ObjectUtil.prettyPrint(object2, n + 1, set));
                stringBuffer.append(",\n");
            }
            stringBuffer.append(string);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        boolean bl = true;
        stringBuffer.append(" {\n");
        for (clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                if (!ObjectUtil.isFieldPrintable(field)) continue;
                bl = false;
                stringBuffer.append(PRETTY_PRINT_PROP_INDENT + string);
                stringBuffer.append(field.getName());
                stringBuffer.append(" = ");
                try {
                    stringBuffer.append(ObjectUtil.prettyPrint(field.get(object), n + 1, set));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append(string);
        stringBuffer.append("}");
        if (bl) {
            set.remove(object);
            return object.toString();
        }
        return stringBuffer.toString();
    }

    private static boolean isFieldPrintable(Field field) {
        int n = field.getModifiers();
        if ((n & 1) == 0) {
            return false;
        }
        return (n & 8) == 0;
    }

    private static String newIndentString(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public static <T> T firstNonNull(@Nullable T t, @Nullable T t2) {
        return t != null ? t : Objects.requireNonNull(t2);
    }

    private static enum ContainerType {
        STRING,
        COLLECTION,
        ARRAY;


        public static ContainerType determineContainerType(Object object) {
            if (object == null) {
                throw new IllegalArgumentException("The container shouldn't be null");
            }
            if (object instanceof String) {
                return STRING;
            }
            if (object instanceof Collection) {
                return COLLECTION;
            }
            if (object.getClass().isArray()) {
                return ARRAY;
            }
            throw new UnsupportedOperationException("The only supported containers are Strings, collections and arrays. The supplied type is: " + object.getClass().getName());
        }
    }
}

