/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.ObjectUtil;
import java.util.NoSuchElementException;
import org.apache.commons.lang.Validate;

public final class Optional<T> {
    private static final Optional<?> EMPTY = new Optional();
    private final T value;

    private Optional() {
        this.value = null;
    }

    public static <T> Optional<T> empty() {
        Optional<?> optional = EMPTY;
        return optional;
    }

    private Optional(T t) {
        Validate.notNull(t);
        this.value = t;
    }

    public static <T> Optional<T> of(T t) {
        return new Optional<T>(t);
    }

    public static <T> Optional<T> ofNullable(T t) {
        if (t == null) {
            return Optional.empty();
        }
        return Optional.of(t);
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public T orElse(T t) {
        return this.value != null ? this.value : t;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Optional)) {
            return false;
        }
        Optional optional = (Optional)object;
        return ObjectUtil.objectsEqual(this.value, optional.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return this.value != null ? String.format("Optional[%s]", this.value) : "Optional.empty";
    }
}

