/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Pair<T1, T2> {
    public final T1 first;
    public final T2 second;
    private final boolean _immutable;
    private volatile int _cachedHashCode;

    public Pair(T1 T1, T2 T2) {
        this(T1, T2, false);
    }

    public Pair(T1 T1, T2 T2, boolean bl) {
        this.first = T1;
        this.second = T2;
        this._immutable = bl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Pair) {
            Pair pair = (Pair)object;
            return (this.first == null ? pair.first == null : this.first.equals(pair.first)) && (this.second == null ? pair.second == null : this.second.equals(pair.second));
        }
        return false;
    }

    public int hashCode() {
        int n;
        if (this._immutable && (n = this._cachedHashCode) != 0) {
            return n;
        }
        n = 17;
        n = 31 * n + (this.first != null ? this.first.hashCode() : 0);
        n = 31 * n + (this.second != null ? this.second.hashCode() : 0);
        if (this._immutable) {
            this._cachedHashCode = n;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append('<');
        if (this.first != null) {
            stringBuilder.append(this.first);
        } else {
            stringBuilder.append((String)null);
        }
        stringBuilder.append(',');
        if (this.second != null) {
            stringBuilder.append(this.second);
        } else {
            stringBuilder.append((String)null);
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    public static <T1, T2> List<T1> extractFirst(Collection<Pair<T1, T2>> collection) {
        if (collection == null) {
            return null;
        }
        int n = collection.size();
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (Pair<T1, T2> pair : collection) {
            arrayList.add(pair != null ? (Object)pair.first : null);
        }
        return arrayList;
    }

    public static <T1, T2> List<T2> extractSecond(Collection<Pair<T1, T2>> collection) {
        if (collection == null) {
            return null;
        }
        int n = collection.size();
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (Pair<T1, T2> pair : collection) {
            arrayList.add(pair != null ? (Object)pair.second : null);
        }
        return arrayList;
    }
}

