/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.google.common.annotations.VisibleForTesting;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.Version;

public class VersionInterval {
    static final Version LEFT_LIMIT = new Version("0");
    static final Version RIGHT_LIMIT = new Version("9999999");
    private Endpoint _leftEndpoint;
    private Endpoint _rightEndpoint;

    public VersionInterval(String string) {
        int n;
        if (StringUtil.isNullOrWhitespace(string)) {
            throw new IllegalArgumentException("The passed range string is null or empty");
        }
        string = string.trim();
        char c = string.charAt(0);
        char c2 = string.charAt(string.length() - 1);
        if (string.length() < 2 || c != '(' && c != '[' || c2 != ')' && c2 != ']') {
            throw new IllegalArgumentException("The range string " + string + " must start and end with a bracket");
        }
        String[] stringArray = string.split(",");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("The range string " + string + " must be an interval.");
        }
        this._leftEndpoint = new Endpoint(stringArray[0]);
        if (this._leftEndpoint.version == null) {
            this._leftEndpoint.version = LEFT_LIMIT;
        }
        this._rightEndpoint = new Endpoint(stringArray[1]);
        if (this._rightEndpoint.version == null) {
            this._rightEndpoint.version = RIGHT_LIMIT;
        }
        if ((n = this._leftEndpoint.version.compareTo(this._rightEndpoint.version)) > 0 || n == 0 && (!this._leftEndpoint.inclusive || !this._rightEndpoint.inclusive)) {
            throw new IllegalArgumentException("The left endpoint must either be before the right endpointor both endpoints need to be equal and inclusive: " + string);
        }
    }

    public boolean contains(Version version) {
        return this._leftEndpoint.isBefore(version) && this._rightEndpoint.isAfter(version);
    }

    Endpoint getLeftEndpoint() {
        return this._leftEndpoint;
    }

    Endpoint getRightEndpoint() {
        return this._rightEndpoint;
    }

    @VisibleForTesting
    static class Endpoint {
        Version version;
        boolean inclusive = false;

        public Endpoint(String string) {
            string = string.trim();
            if (string.length() < 1) {
                throw new IllegalArgumentException("The interval endpoint must begin/end with anopen interval bracket/closing interval bracket.");
            }
            int n = 0;
            int n2 = string.length();
            char c = string.charAt(0);
            char c2 = string.charAt(string.length() - 1);
            if (c == '(') {
                ++n;
            } else if (c == '[') {
                ++n;
                this.inclusive = true;
            } else if (c2 == ')') {
                --n2;
            } else if (c2 == ']') {
                --n2;
                this.inclusive = true;
            }
            if (n >= string.length() || n2 <= 0) {
                this.version = null;
            } else {
                String string2 = string.substring(n, n2);
                if (StringUtil.isNullOrWhitespace(string2 = string2.trim())) {
                    this.version = null;
                } else {
                    try {
                        this.version = new Version(string2);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Couldn't transform the " + string2 + " to a version.", exception);
                    }
                }
            }
        }

        public boolean isBefore(Version version) {
            int n = this.version.compareTo(version);
            if (n < 0) {
                return true;
            }
            return this.inclusive && n == 0;
        }

        public boolean isAfter(Version version) {
            int n = this.version.compareTo(version);
            if (n > 0) {
                return true;
            }
            return this.inclusive && n == 0;
        }
    }
}

