/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.vmware.vise.util.Optional;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;

public final class BlockingUtil {
    public static void awaitUninterruptibly(CountDownLatch countDownLatch) {
        ValidationUtil.paramsNotNull(countDownLatch);
        boolean bl = false;
        while (true) {
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean await(CountDownLatch countDownLatch, long l, TimeUnit timeUnit) {
        ValidationUtil.paramsNotNull(countDownLatch);
        try {
            boolean bl = countDownLatch.await(l, timeUnit);
            return bl;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static boolean await(Condition condition, long l, TimeUnit timeUnit) {
        ValidationUtil.paramsNotNull(condition);
        try {
            boolean bl = condition.await(l, timeUnit);
            return bl;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        ValidationUtil.paramsNotNull(future);
        boolean bl = false;
        while (true) {
            try {
                V v;
                V v2 = v = future.get();
                return v2;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <V> V get(Future<V> future, long l, TimeUnit timeUnit) throws ExecutionException, TimeoutException {
        ValidationUtil.paramsNotNull(future);
        try {
            V v = future.get(l, timeUnit);
            return v;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Nonnull
    public static <V, F extends Future<V>> Collection<FutureResult<V, F>> get(@Nonnull Collection<F> collection, long l, @Nonnull TimeUnit timeUnit) throws InterruptedException {
        Validate.notNull(collection);
        Validate.notNull((Object)((Object)timeUnit));
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        long l2 = timeUnit.toNanos(l);
        long l3 = System.nanoTime();
        long l4 = -1L;
        if (l >= 0L && (l4 = l3 + l2) < 0L) {
            l4 = Long.MAX_VALUE;
        }
        ArrayList<FutureResult<V, F>> arrayList = new ArrayList<FutureResult<V, F>>(collection.size());
        for (Future future : collection) {
            long l5;
            long l6 = l5 = l >= 0L ? l4 - l3 : 0L;
            if (l5 > 0L || future.isDone()) {
                try {
                    Object v = l >= 0L ? future.get(l5, TimeUnit.NANOSECONDS) : future.get();
                    arrayList.add(new FutureResult(future, v, null, null));
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (Exception exception) {
                    arrayList.add(new FutureResult(future, null, exception, null));
                }
            } else {
                arrayList.add(new FutureResult(future, null, new TimeoutException("Timeout expired: " + l + " " + timeUnit.toString()), null));
            }
            l3 = System.nanoTime();
        }
        return arrayList;
    }

    @Nonnull
    public static <K, V, F extends Future<V>> Map<K, FutureResult<V, F>> get(@Nonnull Map<K, F> map, long l, @Nonnull TimeUnit timeUnit) throws InterruptedException {
        Object object;
        Object object2;
        Validate.notNull(map);
        Validate.notNull((Object)((Object)timeUnit));
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList arrayList = new ArrayList(map.size());
        for (Map.Entry<K, F> object32 : map.entrySet()) {
            object2 = object32.getKey();
            object = (Future)object32.getValue();
            arrayList.add(new KeyAndFuture(object2, (Future)object));
        }
        Collection collection = BlockingUtil.get(arrayList, l, timeUnit);
        HashMap hashMap = new HashMap();
        object2 = collection.iterator();
        while (object2.hasNext()) {
            object = (FutureResult)object2.next();
            Object var9_9 = ((FutureResult)object).getResult().orElse(null);
            Exception exception = ((FutureResult)object).getException().orElse(null);
            KeyAndFuture keyAndFuture = (KeyAndFuture)((FutureResult)object).getFuture();
            Object k = keyAndFuture.getKey();
            Object f = keyAndFuture.getFuture();
            hashMap.put(k, new FutureResult((Future)f, var9_9, exception, null));
        }
        return hashMap;
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void sleepUntilTimeElapses(long l) throws InterruptedException {
        long l2;
        if (l < 1L) {
            throw new IllegalArgumentException("sleepTimeMillis must be at least 1 ms.");
        }
        long l3 = TimeUnit.MILLISECONDS.toNanos(l);
        long l4 = System.nanoTime() + l3;
        Thread.sleep(l);
        while ((l2 = System.nanoTime()) < l4) {
            long l5 = l4 - l2;
            long l6 = TimeUnit.NANOSECONDS.toMillis(l5);
            if (l6 == 0L) {
                Thread.sleep(0L, (int)l5);
                continue;
            }
            Thread.sleep(l6);
        }
    }

    private static class KeyAndFuture<K, V, F extends Future<V>>
    implements Future<V> {
        private final K _key;
        private final F _future;

        KeyAndFuture(K k, F f) {
            this._key = k;
            this._future = f;
        }

        public K getKey() {
            return this._key;
        }

        public F getFuture() {
            return this._future;
        }

        @Override
        public boolean cancel(boolean bl) {
            return this._future.cancel(bl);
        }

        @Override
        public boolean isCancelled() {
            return this._future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this._future.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this._future.get();
        }

        @Override
        public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this._future.get(l, timeUnit);
        }
    }

    public static final class FutureResult<T, F extends Future<T>> {
        private final T _result;
        private final Exception _exception;
        private final F _future;

        private FutureResult(@Nonnull F f, @Nullable T t, @Nullable Exception exception) {
            Validate.notNull(f);
            this._result = t;
            this._exception = exception;
            this._future = f;
        }

        public Optional<T> getResult() {
            return Optional.ofNullable(this._result);
        }

        public Optional<Exception> getException() {
            return Optional.ofNullable(this._exception);
        }

        @Nonnull
        public F getFuture() {
            return this._future;
        }

        public String toString() {
            return "[future: " + this._future + ", result: " + this._result + ", exception: " + this._exception + "]";
        }

        /* synthetic */ FutureResult(Future future, Object object, Exception exception, 1 var4_4) {
            this(future, object, exception);
        }
    }
}

