/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.Validate;

public class CountDownLatchEx {
    private final CountDownLatch _latch;
    private final AtomicBoolean _countOfZeroAlreadyReported = new AtomicBoolean(false);

    public CountDownLatchEx(CountDownLatch countDownLatch) {
        Validate.notNull((Object)countDownLatch);
        this._latch = countDownLatch;
    }

    public boolean countDownAndCheckIfZeroIsReachedForTheFirstTime() {
        this.countDown();
        if (this.getCount() > 0L) {
            return false;
        }
        boolean bl = this._countOfZeroAlreadyReported.getAndSet(true);
        return !bl;
    }

    public void await() throws InterruptedException {
        this._latch.await();
    }

    public void await(long l, TimeUnit timeUnit) throws InterruptedException {
        this._latch.await(l, timeUnit);
    }

    public void countDown() {
        this._latch.countDown();
    }

    public long getCount() {
        return this._latch.getCount();
    }

    public String toString() {
        return CountDownLatchEx.class.getSimpleName() + ":" + super.toString();
    }
}

