/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.google.common.collect.MapMaker;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.concurrent.ConcurrencyUtil;
import com.vmware.vise.util.concurrent.DiagnosticExecutorService;
import com.vmware.vise.util.concurrent.DiagnosticRunnable;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.session.SessionUtil;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExecutorUtil {
    private static final Log _logger = LogFactory.getLog(ExecutorUtil.class);
    private static final ConcurrentMap<Executor, AtomicInteger> _rejectionsByExecutor = new MapMaker().weakKeys().concurrencyLevel(5).makeMap();
    public static final Runnable EMPTY_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }

        public String toString() {
            return "[EMPTY_RUNNABLE]";
        }
    };

    public static void executeTasks(Collection<? extends Runnable> collection, Executor executor) throws InterruptedException {
        try {
            ExecutorUtil.executeTasks(collection, executor, -1L, null);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public static void executeTasks(Collection<? extends Runnable> collection, Executor executor, long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        Object object;
        Object object2;
        int n;
        if (executor == null) {
            throw new IllegalArgumentException("The executor shouldn't be null");
        }
        if (collection == null || (n = collection.size()) == 0) {
            _logger.warn((Object)"An empty collection of tasks specified.");
            return;
        }
        boolean bl = l > 0L && timeUnit != null;
        CountDownLatch countDownLatch = new CountDownLatch(n);
        SessionUtil.ThreadContext threadContext = null;
        Iterator<? extends Runnable> iterator = collection.iterator();
        boolean bl2 = iterator.hasNext();
        ArrayList<LatchRunnable> arrayList = new ArrayList<LatchRunnable>(collection.size());
        long l2 = System.nanoTime();
        long l3 = 0L;
        while (bl2) {
            Runnable runnable = iterator.next();
            boolean bl3 = runnable instanceof DiagnosticRunnable;
            object2 = null;
            if (bl3) {
                object2 = runnable.toString();
                _logger.info((Object)("Processing task " + (String)object2));
            }
            object = new LatchRunnable(runnable, countDownLatch);
            arrayList.add((LatchRunnable)object);
            bl2 = iterator.hasNext();
            if (bl || bl2) {
                try {
                    if (threadContext == null) {
                        threadContext = SessionUtil.getThreadContext(true);
                    }
                    Runnable runnable2 = new ThreadContextPropagatingTask((Runnable)object, threadContext);
                    if (bl3) {
                        _logger.info((Object)("Executing task " + (String)object2));
                    }
                    executor.execute(runnable2);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    _logger.warn((Object)ExecutorUtil.buildMessageAboutRejectedTask(executor, object));
                    ((LatchRunnable)object).run();
                }
                continue;
            }
            ((LatchRunnable)object).run();
        }
        if (bl) {
            boolean bl4 = false;
            Exception exception = null;
            try {
                bl4 = countDownLatch.await(l, timeUnit);
            }
            catch (Exception exception2) {
                exception = exception2;
                l3 = System.nanoTime() - l2;
            }
            if (!bl4) {
                object2 = new ArrayList(5);
                for (Runnable runnable2 : arrayList) {
                    if (runnable2.isDone()) continue;
                    object2.add(runnable2);
                }
                if (exception == null) {
                    throw new TimeoutException(String.format("Tasks didn't complete within the allotted timeout: %d %s. The tasks that timed out are: %s", new Object[]{l, timeUnit, object2.toString()}));
                }
                object = new InterruptedException(String.format("Task was interrupted after: %d ms. The tasks that were still running are: %s", TimeUnit.NANOSECONDS.toMillis(l3), object2.toString()));
                ((Throwable)object).initCause(exception);
                throw object;
            }
        } else {
            countDownLatch.await();
        }
    }

    public static <T> List<TaskResult<T>> executeTasks(List<? extends Callable<T>> list, Executor executor) throws InterruptedException {
        try {
            return ExecutorUtil.executeTasks(list, executor, -1L, null, false, false, true);
        }
        catch (TimeoutException timeoutException) {
            return null;
        }
    }

    public static <T> List<TaskResult<T>> executeTasks(List<? extends Callable<T>> list, Executor executor, long l, TimeUnit timeUnit, boolean bl) throws InterruptedException, TimeoutException {
        return ExecutorUtil.executeTasks(list, executor, l, timeUnit, bl, false, true);
    }

    public static List<TaskResult<Void>> executeRunnableTasks(List<? extends Runnable> list, Executor executor, long l, TimeUnit timeUnit, boolean bl, boolean bl2, boolean bl3) throws InterruptedException, TimeoutException, IllegalArgumentException, RejectedExecutionException {
        List<Callable<Void>> list2 = ExecutorUtil.toCallables(list);
        return ExecutorUtil.executeTasks(list2, executor, l, timeUnit, bl, bl2, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<TaskResult<T>> executeTasks(List<? extends Callable<T>> list, Executor executor, long l, TimeUnit timeUnit, boolean bl, boolean bl2, boolean bl3) throws InterruptedException, TimeoutException, IllegalArgumentException, RejectedExecutionException {
        int n;
        int n2;
        if (executor == null) {
            throw new IllegalArgumentException("The executor shouldn't be null");
        }
        ExecutorService executorService = null;
        if (executor instanceof ExecutorService) {
            executorService = (ExecutorService)executor;
        }
        if (list == null || (n2 = list.size()) == 0) {
            _logger.warn((Object)"An empty collection of tasks specified.");
            return Collections.emptyList();
        }
        boolean bl4 = l > 0L && timeUnit != null;
        ArrayList arrayList = new ArrayList(n2);
        ArrayList<Long> arrayList2 = new ArrayList<Long>(n2);
        ArrayList<Future<T>> arrayList3 = new ArrayList<Future<T>>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(null);
            arrayList3.add(null);
        }
        List<TaskResult<T>> list2 = Collections.synchronizedList(arrayList);
        CountDownLatch countDownLatch = new CountDownLatch(n2);
        SessionUtil.ThreadContext threadContext = null;
        int n3 = n2 - 1;
        for (n = 0; n <= n3; ++n) {
            Callable<T> callable = list.get(n);
            int n4 = n;
            long l2 = System.nanoTime();
            arrayList2.add(l2);
            Callable<T> callable2 = ExecutorUtil.createLatchTask(callable, n4, list2, countDownLatch);
            if (bl4 || n < n3) {
                try {
                    ThreadContextPropagatingTask<T> threadContextPropagatingTask;
                    if (threadContext == null) {
                        threadContext = SessionUtil.getThreadContext(true);
                    }
                    if (executorService != null) {
                        threadContextPropagatingTask = new ThreadContextPropagatingTask<T>(callable2, threadContext);
                        Future<T> future = executorService.submit(threadContextPropagatingTask);
                        arrayList3.set(n, future);
                        continue;
                    }
                    threadContextPropagatingTask = new ThreadContextPropagatingTask<T>(callable2, threadContext);
                    executor.execute(threadContextPropagatingTask);
                    continue;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    if (bl3) {
                        _logger.warn((Object)ExecutorUtil.buildMessageAboutRejectedTask(executor, callable2));
                        ExecutorUtil.executeTaskInCurrentThread(executorService, callable2, n, arrayList3);
                        if (!Thread.currentThread().isInterrupted()) continue;
                        ExecutorUtil.logRunningTasks(arrayList2, list, list2, n);
                        throw new InterruptedException("Interrupted while executing in current thread");
                    }
                    _logger.warn((Object)("Task '" + list.get(n) + "' was rejected by the thread pool. Will cancel all tasks from its batch."));
                    if (executorService != null) {
                        for (int i = 0; i < n2; ++i) {
                            Future future = (Future)arrayList3.get(i);
                            if (future == null) continue;
                            ExecutorUtil.cancelTask(future, list.get(i), (Long)arrayList2.get(i), false);
                        }
                    } else {
                        ExecutorUtil.logRunningTasks(arrayList2, list, list2, n);
                    }
                    throw rejectedExecutionException;
                }
            }
            ExecutorUtil.executeTaskInCurrentThread(executorService, callable2, n, arrayList3);
            if (!Thread.currentThread().isInterrupted()) continue;
            ExecutorUtil.logRunningTasks(arrayList2, list, list2, n);
            throw new InterruptedException("Interrupted while executing in current thread");
        }
        if (bl4) {
            try {
                n = countDownLatch.await(l, timeUnit) ? 1 : 0;
            }
            catch (Exception exception) {
                ExecutorUtil.logRunningTasks(arrayList2, list, list2, arrayList3.size());
                throw exception;
            }
            n3 = 0;
            if (n == 0 && !bl && bl2 && executorService != null) {
                n3 = 1;
                for (int i = 0; i < n2; ++i) {
                    Future future = (Future)arrayList3.get(i);
                    if (future == null) continue;
                    ExecutorUtil.cancelTask(future, list.get(i), (Long)arrayList2.get(i), true);
                }
            }
            if (n == 0 && n3 == 0) {
                ExecutorUtil.logRunningTasks(arrayList2, list, list2, arrayList3.size());
            }
            if (n == 0 && !bl) {
                throw new TimeoutException("Tasks didn't complete within the allowed timeout: " + l + " " + (Object)((Object)timeUnit));
            }
        } else if (executorService != null) {
            ExecutorUtil.await(arrayList3, list, arrayList2);
        } else {
            try {
                countDownLatch.await();
            }
            catch (Exception exception) {
                ExecutorUtil.logRunningTasks(arrayList2, list, list2, arrayList3.size());
                throw exception;
            }
        }
        List<TaskResult<T>> list3 = list2;
        synchronized (list3) {
            ArrayList<TaskResult<T>> arrayList4 = new ArrayList<TaskResult<T>>(arrayList.size());
            int n5 = arrayList.size();
            for (int i = 0; i < n5; ++i) {
                TaskResult taskResult = (TaskResult)arrayList.get(i);
                Future future = (Future)arrayList3.get(i);
                if (taskResult != null) {
                    if (future != null) {
                        taskResult = taskResult.newTaskResultWithFuture(future);
                    }
                    arrayList4.add(taskResult);
                    continue;
                }
                if (bl2 && future != null) {
                    ExecutorUtil.cancelTask(future, list.get(i), (Long)arrayList2.get(i), true);
                }
                arrayList4.add(new TaskResult(null, new TimeoutException(), future));
            }
            return arrayList4;
        }
    }

    static <T> void await(List<Future<T>> list, List<? extends Callable<T>> list2, List<Long> list3) {
        if (list == null) {
            return;
        }
        Iterator<Callable<T>> iterator = list2.iterator();
        Iterator<Long> iterator2 = list3.iterator();
        for (Future<T> future : list) {
            ExecutorUtil.await(future, iterator.next(), iterator2.next());
        }
    }

    static void await(Future<?> future, Callable<?> callable, Long l) {
        if (future == null || future.isDone()) {
            return;
        }
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            long l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l);
            _logger.warn((Object)("Task '" + callable + "' was still runing at interruption moment after " + l2 + " ms."), (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            _logger.error((Object)("Waiting completion of '" + callable + "' finished with error."), (Throwable)executionException);
        }
    }

    private static <T> void logRunningTasks(List<Long> list, List<? extends Callable<T>> list2, List<TaskResult<T>> list3, int n) {
        for (int i = 0; i < n; ++i) {
            if (list3.get(i) != null) continue;
            Callable<T> callable = list2.get(i);
            long l = System.nanoTime() - list.get(i);
            long l2 = TimeUnit.NANOSECONDS.toMillis(l);
            _logger.warn((Object)("Task '" + callable + "' was still runing at interruption moment after " + l2 + " ms."));
        }
    }

    private static <T> Callable<T> createLatchTask(final @Nonnull Callable<T> callable, final int n, final @Nonnull List<TaskResult<T>> list, final @Nonnull CountDownLatch countDownLatch) {
        Callable callable2 = new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    Object v = callable.call();
                    list.set(n, new TaskResult(v, null, null));
                    Object v2 = v;
                    return v2;
                }
                catch (Exception exception) {
                    if (ExceptionUtil.isCausedBy(exception, InterruptedException.class) || ExceptionUtil.isCausedBy(exception, ClosedByInterruptException.class)) {
                        _logger.warn((Object)("Task '" + callable + "' was interrupted"), (Throwable)exception);
                    }
                    list.set(n, new TaskResult(null, exception, null));
                    throw exception;
                }
                catch (Error error) {
                    Exception exception = new Exception("A java.lang.Error occurred while executing a task", error);
                    list.set(n, new TaskResult(null, exception, null));
                    throw error;
                }
                finally {
                    countDownLatch.countDown();
                }
            }

            public String toString() {
                return callable.toString();
            }
        };
        return callable2;
    }

    private static <T> void executeTaskInCurrentThread(@Nullable ExecutorService executorService, @Nonnull Callable<T> callable, int n, @Nullable List<Future<T>> list) {
        long l = System.nanoTime();
        if (executorService != null) {
            FutureTask<T> futureTask = new FutureTask<T>(callable);
            list.set(n, futureTask);
            futureTask.run();
            try {
                futureTask.get(0L, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException | CancellationException exception) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                if (ExceptionUtil.isCausedBy(executionException, InterruptedException.class) || ExceptionUtil.isCausedBy(executionException, ClosedByInterruptException.class)) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Exception exception) {}
        } else {
            try {
                callable.call();
            }
            catch (InterruptedException | ClosedByInterruptException exception) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            long l2 = System.nanoTime() - l;
            _logger.warn((Object)("Execution of '" + callable + "' was interrupted after " + TimeUnit.NANOSECONDS.toMillis(l2) + " ms in current thread"));
        }
    }

    private static void cancelTask(@Nonnull Future<?> future, @Nonnull Callable<?> callable, @Nonnull Long l, boolean bl) {
        boolean bl2 = future.cancel(true);
        long l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l);
        if (bl2) {
            _logger.warn((Object)("Task '" + callable + "'" + (bl ? " timed out after " + l2 + " ms and" : "") + " was cancelled."));
        } else if (!future.isDone()) {
            _logger.warn((Object)("Task '" + callable + "'" + (bl ? " timed out after " + l2 + " ms but" : "") + " it could not be cancelled."));
        }
    }

    private static List<Callable<Void>> toCallables(List<? extends Runnable> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<Callable<Void>> arrayList = new ArrayList<Callable<Void>>(n);
        for (int i = 0; i < n; ++i) {
            final Runnable runnable = list.get(i);
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    runnable.run();
                    return null;
                }

                public String toString() {
                    return runnable.toString();
                }
            };
            arrayList.add(callable);
        }
        return arrayList;
    }

    private static String buildMessageAboutRejectedTask(Executor executor, Object object) {
        int n = ExecutorUtil.registerRejection(executor);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("Task ").append(object).append(" was rejected. Will execute it in the current thread.");
        if (executor instanceof ThreadPoolExecutor) {
            ExecutorUtil.appendExecutorStats(stringBuilder, (ThreadPoolExecutor)executor);
        }
        stringBuilder.append(" Rejections: ").append(n);
        return stringBuilder.toString();
    }

    private static int registerRejection(@Nonnull Executor executor) {
        AtomicInteger atomicInteger;
        AtomicInteger atomicInteger2 = (AtomicInteger)_rejectionsByExecutor.get(executor);
        if (atomicInteger2 == null && (atomicInteger = _rejectionsByExecutor.putIfAbsent(executor, atomicInteger2 = new AtomicInteger(0))) != null) {
            atomicInteger2 = atomicInteger;
        }
        int n = atomicInteger2.incrementAndGet();
        return n;
    }

    public static void appendExecutorStats(@Nonnull StringBuilder stringBuilder, @Nonnull ThreadPoolExecutor threadPoolExecutor) {
        String string = ExecutorUtil.getPoolName(threadPoolExecutor);
        if (string != null) {
            stringBuilder.append(" Pool:'").append(string).append('\'');
        }
        stringBuilder.append(" Active: ").append(threadPoolExecutor.getActiveCount()).append(" Current: ").append(threadPoolExecutor.getPoolSize()).append(" Core: ").append(threadPoolExecutor.getCorePoolSize()).append(" Max: ").append(threadPoolExecutor.getMaximumPoolSize()).append(" Queue: ").append(threadPoolExecutor.getQueue().size());
    }

    public static String getPoolName(Executor executor) {
        Validate.notNull((Object)executor);
        if (executor instanceof DiagnosticExecutorService) {
            return ((DiagnosticExecutorService)executor).getName();
        }
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
            ThreadFactory threadFactory = threadPoolExecutor.getThreadFactory();
            if (threadFactory instanceof WorkerThreadFactory) {
                return ((WorkerThreadFactory)threadFactory).getPoolName();
            }
            return threadFactory.toString();
        }
        return executor.toString();
    }

    public static ExecutorService threadContextDecorator(@Nonnull ExecutorService executorService, boolean bl) {
        if (executorService instanceof ThreadContextDecorator) {
            return executorService;
        }
        return new ThreadContextDecorator(executorService, bl);
    }

    private static class ThreadContextDecorator
    extends AbstractExecutorService {
        private final ExecutorService _delegate;
        private final boolean _useRequestWrapper;

        ThreadContextDecorator(@Nonnull ExecutorService executorService, boolean bl) {
            Validate.notNull((Object)executorService);
            this._delegate = executorService;
            this._useRequestWrapper = bl;
        }

        @Override
        protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
            SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext(this._useRequestWrapper);
            ThreadContextPropagatingTask threadContextPropagatingTask = new ThreadContextPropagatingTask(runnable, threadContext);
            return super.newTaskFor(threadContextPropagatingTask, t);
        }

        @Override
        protected final <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
            SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext(this._useRequestWrapper);
            ThreadContextPropagatingTask<T> threadContextPropagatingTask = new ThreadContextPropagatingTask<T>(callable, threadContext);
            return super.newTaskFor(threadContextPropagatingTask);
        }

        @Override
        public void execute(Runnable runnable) {
            this._delegate.execute(runnable);
        }

        @Override
        public void shutdown() {
            this._delegate.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this._delegate.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this._delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this._delegate.isTerminated();
        }

        @Override
        public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            return this._delegate.awaitTermination(l, timeUnit);
        }
    }

    private static class LatchRunnable
    implements Runnable {
        private final Runnable _runnable;
        private final CountDownLatch _latch;
        private volatile boolean _runnableExecutionComplete;

        LatchRunnable(Runnable runnable, CountDownLatch countDownLatch) {
            this._runnable = runnable;
            this._latch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                this._runnable.run();
            }
            catch (RuntimeException runtimeException) {
                _logger.error((Object)("A task crashed: " + this._runnable), (Throwable)runtimeException);
            }
            finally {
                this._runnableExecutionComplete = true;
                this._latch.countDown();
            }
        }

        public boolean isDone() {
            return this._runnableExecutionComplete;
        }

        public String toString() {
            return this._runnable.toString();
        }
    }

    public static class ThreadContextPropagatingTask<T>
    implements Runnable,
    Callable<T> {
        private final Callable<T> _callable;
        private final SessionUtil.ThreadContext _threadContext;
        private final long _creationTimeInNanos = System.nanoTime();

        public ThreadContextPropagatingTask(Callable<T> callable, SessionUtil.ThreadContext threadContext) {
            if (callable == null) {
                throw new IllegalArgumentException("The Callable should not be null");
            }
            this._callable = callable;
            this._threadContext = threadContext;
        }

        public ThreadContextPropagatingTask(final Runnable runnable, SessionUtil.ThreadContext threadContext) {
            if (runnable == null) {
                throw new IllegalArgumentException("The Runnable should not be null");
            }
            this._callable = new Callable<T>(){

                @Override
                public T call() {
                    try {
                        runnable.run();
                    }
                    catch (Exception exception) {
                        _logger.error((Object)"A task crashed", (Throwable)exception);
                    }
                    return null;
                }

                public String toString() {
                    return runnable.toString();
                }
            };
            this._threadContext = threadContext;
        }

        @Override
        public T call() throws Exception {
            this.logIfWaitingThresholdIsExceeded();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Thread " + Thread.currentThread().getName() + " is beginning execution of task " + this._callable));
            }
            SessionUtil.ThreadContext threadContext = null;
            if (this._threadContext != null) {
                threadContext = SessionUtil.getThreadContext(false);
                SessionUtil.setThreadContext(this._threadContext);
            }
            try {
                T t;
                T t2 = t = this._callable.call();
                return t2;
            }
            catch (Exception exception) {
                _logger.error((Object)("A task crashed: " + this._callable), (Throwable)exception);
                throw exception;
            }
            finally {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Thread " + Thread.currentThread().getName() + " finished executing task " + this._callable));
                }
                if (this._threadContext != null) {
                    SessionUtil.setThreadContext(threadContext);
                }
            }
        }

        @Override
        public void run() {
            try {
                this.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void logIfWaitingThresholdIsExceeded() {
            long l = System.nanoTime() - this._creationTimeInNanos;
            if (l > ConcurrencyUtil.TASK_WAIT_TIME_THRESHOLD_IN_NANOS) {
                _logger.warn((Object)("A task waited too long to be executed: " + TimeUnit.NANOSECONDS.toMillis(l) + " ms. Task: " + this._callable.toString()));
            }
        }

        public String toString() {
            return this._callable.toString();
        }
    }

    public static final class TaskResult<T> {
        private final T _result;
        private final Exception _exception;
        private final Future<T> _future;

        private TaskResult(T t, Exception exception, Future<T> future) {
            this._result = t;
            this._exception = exception;
            this._future = future;
        }

        public T getResult() {
            return this._result;
        }

        public Exception getException() {
            return this._exception;
        }

        public Future<T> getFuture() {
            return this._future;
        }

        private TaskResult<T> newTaskResultWithFuture(Future<T> future) {
            return new TaskResult<T>(this._result, this._exception, future);
        }

        public String toString() {
            return "[result: " + this._result + ", exception: " + this._exception + "]";
        }
    }
}

