/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.google.common.util.concurrent.SettableFuture;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.concurrent.AtomicUtil;
import com.vmware.vise.util.concurrent.ConcurrencyUtil;
import com.vmware.vise.util.concurrent.DiagnosticExecutorService;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.concurrent.ExpirationException;
import com.vmware.vise.util.concurrent.TaskDescriptor;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.internal.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueuingCachedThreadPool
implements DiagnosticExecutorService {
    private static final Log _logger = LogFactory.getLog(QueuingCachedThreadPool.class);
    private static final int STATS_INTERVAL = 500;
    private final ThreadPoolExecutor _executor;
    private final ExecutionManager _executionManager;
    private final AtomicLong _taskGroupIdGenerator = new AtomicLong(0L);
    private volatile boolean _isLoggingOfAdditionalDiagnosticsEnabled = false;
    private final long _queueWaitTimeThresholdNanos;
    private final int _expiredTaskStepSizeForLoggingAdditionalDiagnostics;
    private final int _delayedTaskStepSizeForLoggingAdditionalDiagnostics;
    private final long _minNanosApartForLoggingAdditionalDiagnostics;
    private final AtomicLong _tasksSubmitted = new AtomicLong(0L);
    private final AtomicLong _tasksRunByWorkPool = new AtomicLong(0L);
    private final AtomicLong _tasksRunByCaller = new AtomicLong(0L);
    private final AtomicLong _tasksExpired = new AtomicLong(0L);
    private final AtomicLong _taskWaitTimeInMicroSecs = new AtomicLong(0L);
    private final AtomicInteger _workerThreadCounter = new AtomicInteger(0);
    private final AtomicInteger _largestObservedQueueSize = new AtomicInteger(0);
    private final AtomicInteger _largestNumberOfWorkerThreads = new AtomicInteger(0);
    private final AtomicLong _longWaitCounter = new AtomicLong(0L);
    private final AtomicLong _nanoTimeOfLatestLoggingOfDelayedTasks = new AtomicLong(0L);
    private final long _taskExpirationNanos;
    private final TaskExpirationPolicy _taskExpirationPolicy;
    private final String _poolName;
    private final String _label;
    private final boolean _loggingEnabled;

    public QueuingCachedThreadPool(int n, ThreadFactory threadFactory, long l, TimeUnit timeUnit, long l2, TimeUnit timeUnit2, TaskExpirationPolicy taskExpirationPolicy, boolean bl) {
        this(n, threadFactory, l, timeUnit, l2, timeUnit2, taskExpirationPolicy, bl, null, ConcurrencyUtil.TASK_WAIT_TIME_THRESHOLD_IN_NANOS, TimeUnit.NANOSECONDS, -1, -1, -1L, TimeUnit.MILLISECONDS);
    }

    public QueuingCachedThreadPool(int n, ThreadFactory threadFactory, long l, TimeUnit timeUnit, long l2, TimeUnit timeUnit2, TaskExpirationPolicy taskExpirationPolicy, boolean bl, @Nullable ConfigurationService configurationService, long l3, TimeUnit timeUnit3, int n2, int n3, long l4, TimeUnit timeUnit4) {
        String string;
        String string2;
        ValidationUtil.paramsNotNull(threadFactory);
        this._executionManager = new ExecutionManager(n);
        this._taskExpirationNanos = l >= 0L ? TimeUnit.NANOSECONDS.convert(l, timeUnit) : Long.MAX_VALUE;
        this._executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, l2, timeUnit2, new SynchronousQueue<Runnable>(), threadFactory);
        if (threadFactory instanceof WorkerThreadFactory) {
            string2 = ((WorkerThreadFactory)threadFactory).getPoolName();
            string = threadFactory.toString();
        } else {
            string = string2 = threadFactory.toString();
        }
        this._poolName = string2;
        this._label = string;
        this._taskExpirationPolicy = taskExpirationPolicy;
        this._executor.execute(ExecutorUtil.EMPTY_RUNNABLE);
        this._loggingEnabled = bl;
        if (configurationService != null) {
            this.doUseConfigurationService(configurationService);
        }
        this._queueWaitTimeThresholdNanos = timeUnit3.toNanos(l3);
        this._expiredTaskStepSizeForLoggingAdditionalDiagnostics = n2;
        this._delayedTaskStepSizeForLoggingAdditionalDiagnostics = n3;
        this._minNanosApartForLoggingAdditionalDiagnostics = timeUnit4.toNanos(l4);
    }

    public void useConfigurationService(ConfigurationService configurationService) {
        this.doUseConfigurationService(configurationService);
    }

    private void doUseConfigurationService(ConfigurationService configurationService) {
        this._isLoggingOfAdditionalDiagnosticsEnabled = configurationService != null ? PropertyUtil.getBooleanProperty(configurationService, "threadPool.additionalDiagnostics.enabled", true) : true;
    }

    public void setLoggingOfAdditionalDiagnostics(boolean bl) {
        this._isLoggingOfAdditionalDiagnosticsEnabled = bl;
    }

    @Override
    public void shutdown() {
        this._executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        arrayList.addAll(this._executor.shutdownNow());
        this._executionManager.drainQueue(arrayList);
        return arrayList;
    }

    @Override
    public boolean isShutdown() {
        return this._executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        boolean bl = this._executor.isTerminated();
        return bl;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        ValidationUtil.paramsNotNull(new Object[]{timeUnit});
        boolean bl = this._executor.awaitTermination(l, timeUnit);
        return bl;
    }

    @Override
    public void execute(Runnable runnable) {
        long l = System.nanoTime();
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        long l2 = this._taskGroupIdGenerator.incrementAndGet();
        this.innerSubmit(runnable, null, String.valueOf(l2), l2, l);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        long l = System.nanoTime();
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        long l2 = this._taskGroupIdGenerator.incrementAndGet();
        Future<T> future = this.innerSubmit(callable, String.valueOf(l2), l2, l);
        return future;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        long l = System.nanoTime();
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        long l2 = this._taskGroupIdGenerator.incrementAndGet();
        Future<T> future = this.innerSubmit(runnable, t, String.valueOf(l2), l2, l);
        return future;
    }

    public Future<Void> submit(Runnable runnable) {
        long l = System.nanoTime();
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        long l2 = this._taskGroupIdGenerator.incrementAndGet();
        Future<Object> future = this.innerSubmit(runnable, null, String.valueOf(l2), l2, l);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        long l = System.nanoTime();
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        Long l2 = this._taskGroupIdGenerator.incrementAndGet();
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(collection.size());
        int n = 1;
        for (Callable<T> object : collection) {
            Future<T> future = this.innerSubmit(object, this.getTaskLabel(l2, n), l2, l);
            ++n;
            arrayList.add(future);
        }
        try {
            for (Future future : arrayList) {
                try {
                    if (future.isDone()) continue;
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (Exception exception) {
                }
            }
        }
        finally {
            for (Future future : arrayList) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = System.nanoTime();
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        long l3 = l2 + TimeUnit.NANOSECONDS.convert(l, timeUnit);
        Long l4 = this._taskGroupIdGenerator.incrementAndGet();
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(collection.size());
        int n = 1;
        for (Callable<T> object : collection) {
            Future<T> future = this.innerSubmit(object, this.getTaskLabel(l4, n), l4, l2);
            ++n;
            arrayList.add(future);
        }
        try {
            for (Future future : arrayList) {
                long l5 = l3 - System.nanoTime();
                try {
                    if (future.isDone()) continue;
                    future.get(l5, TimeUnit.NANOSECONDS);
                }
                catch (TimeoutException timeoutException) {
                    break;
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (Exception exception) {
                }
            }
        }
        finally {
            for (Future future : arrayList) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
        return arrayList;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        long l = System.nanoTime();
        T t = null;
        try {
            t = this.doInvokeAny(collection, null, l);
        }
        catch (TimeoutException timeoutException) {
            throw new IllegalStateException(timeoutException);
        }
        return t;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        long l2 = System.nanoTime();
        Long l3 = l2 + TimeUnit.NANOSECONDS.convert(l, timeUnit);
        T t = this.doInvokeAny(collection, l3, l2);
        return t;
    }

    @Override
    @Nonnull
    public Collection<TaskDescriptor> getCurrentlyExecutingTasks() {
        return this._executionManager.getCurrentlyExecutingTasks();
    }

    private <T> T doInvokeAny(Collection<? extends Callable<T>> collection, Long l, long l2) throws InterruptedException, ExecutionException, TimeoutException {
        InvokeAnyResult invokeAnyResult;
        if (this._executor.isShutdown()) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Long l3 = this._taskGroupIdGenerator.incrementAndGet();
        int n = 1;
        int n2 = 0;
        Exception exception = null;
        LinkedBlockingQueue<InvokeAnyResult<T>> linkedBlockingQueue = new LinkedBlockingQueue<InvokeAnyResult<T>>();
        LinkedList<Future<T>> linkedList = new LinkedList<Future<T>>();
        Iterator<Callable<T>> iterator = collection.iterator();
        Callable<T> callable = iterator.next();
        Future<T> future = this.innerSubmit(this.getNotifyingCallable(callable, linkedBlockingQueue), this.getTaskLabel(l3, n), l3, l2);
        linkedList.add(future);
        ++n;
        while (iterator.hasNext()) {
            invokeAnyResult = (InvokeAnyResult)linkedBlockingQueue.poll();
            while (invokeAnyResult != null) {
                if (invokeAnyResult.exception == null) {
                    this.cancelUnfinished(linkedList);
                    return invokeAnyResult.computationResult;
                }
                exception = invokeAnyResult.exception;
                ++n2;
                invokeAnyResult = (InvokeAnyResult)linkedBlockingQueue.poll();
            }
            callable = iterator.next();
            future = this.innerSubmit(this.getNotifyingCallable(callable, linkedBlockingQueue), this.getTaskLabel(l3, n), l3, l2);
            ++n;
            linkedList.add(future);
        }
        while (n2 < collection.size()) {
            if (l == null) {
                invokeAnyResult = (InvokeAnyResult)linkedBlockingQueue.take();
            } else {
                long l4 = l - System.nanoTime();
                if (l4 <= 0L) {
                    this.cancelUnfinished(linkedList);
                    throw new TimeoutException();
                }
                invokeAnyResult = (InvokeAnyResult)linkedBlockingQueue.poll(l4, TimeUnit.NANOSECONDS);
            }
            if (invokeAnyResult != null && invokeAnyResult.exception == null) {
                this.cancelUnfinished(linkedList);
                return invokeAnyResult.computationResult;
            }
            if (invokeAnyResult != null) {
                exception = invokeAnyResult.exception;
            }
            ++n2;
        }
        throw new ExecutionException(exception);
    }

    private <T> void cancelUnfinished(List<Future<T>> list) {
        for (Future<T> future : list) {
            future.cancel(true);
        }
    }

    private <T> Callable<T> getNotifyingCallable(final Callable<T> callable, final BlockingQueue<InvokeAnyResult<T>> blockingQueue) {
        Callable callable2 = new Callable<T>(){

            @Override
            public T call() throws Exception {
                Object t = null;
                Exception exception = null;
                try {
                    Object t2 = t = (Object)callable.call();
                    return t2;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    throw exception2;
                }
                finally {
                    InvokeAnyResult<Object> invokeAnyResult = new InvokeAnyResult<Object>(t, exception);
                    blockingQueue.add(invokeAnyResult);
                }
            }

            public String toString() {
                return "NotifyingCallable@" + QueuingCachedThreadPool.identityHashCode(this) + ": " + callable.toString();
            }
        };
        return callable2;
    }

    private <T> Future<T> innerSubmit(Callable<T> callable, String string, long l, long l2) {
        this.logSubmittedTask(string);
        long l3 = l2 + this._taskExpirationNanos;
        ExpiringTask<T> expiringTask = new ExpiringTask<T>(callable, string, l, l2, l3);
        this._executionManager.processNewTask(expiringTask);
        if (l % 500L == 0L) {
            this.printStats();
        }
        return expiringTask;
    }

    private <T> Future<T> innerSubmit(final Runnable runnable, final T t, String string, long l, long l2) {
        Callable callable = new Callable<T>(){

            @Override
            public T call() {
                runnable.run();
                return t;
            }

            public String toString() {
                return "Runnable@" + QueuingCachedThreadPool.identityHashCode(this) + ": " + runnable.toString();
            }
        };
        Future<T> future = this.innerSubmit(callable, string, l, l2);
        return future;
    }

    private String getTaskLabel(long l, int n) {
        if (!this._loggingEnabled) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(l);
        stringBuilder.append('-');
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    private void logRanTask(ExpiringTask<?> expiringTask) {
        long l = TimeUnit.MICROSECONDS.convert(System.nanoTime() - expiringTask.getSubmissionTime(), TimeUnit.NANOSECONDS);
        this._taskWaitTimeInMicroSecs.addAndGet(l);
        this._tasksRunByWorkPool.incrementAndGet();
        if (!this._loggingEnabled || !_logger.isDebugEnabled()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" ran task ");
        stringBuilder.append(expiringTask.getLabel());
        stringBuilder.append(" after a wait time of (micro-sec): ");
        stringBuilder.append(l);
        _logger.debug((Object)stringBuilder.toString());
    }

    private void logPoolManagementTime(ExpiringTask<?> expiringTask, long l) {
        if (!this._loggingEnabled || !_logger.isDebugEnabled()) {
            return;
        }
        long l2 = TimeUnit.MICROSECONDS.convert(System.nanoTime() - l, TimeUnit.NANOSECONDS);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" assigned task ");
        stringBuilder.append(expiringTask.getLabel());
        stringBuilder.append(" after time of (micro-sec): ");
        stringBuilder.append(l2);
        _logger.debug((Object)stringBuilder.toString());
    }

    private void logExpiredTask(ExpiringTask<?> expiringTask) {
        long l = this._tasksExpired.getAndIncrement();
        if (!this._loggingEnabled) {
            return;
        }
        long l2 = System.nanoTime();
        long l3 = l2 - expiringTask.getSubmissionTime();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" task# ");
        stringBuilder.append(expiringTask.getLabel());
        stringBuilder.append(" expired after ");
        stringBuilder.append(TimeUnit.NANOSECONDS.toSeconds(l3));
        stringBuilder.append(" sec.");
        ExecutorUtil.appendExecutorStats(stringBuilder, this._executor);
        stringBuilder.append(" WorkerThreadCounter: ").append(this._workerThreadCounter);
        if (this._isLoggingOfAdditionalDiagnosticsEnabled && Config.THREAD_POOL_LOG_CURR_EXEC_TASKS_ENABLED && l % (long)this._expiredTaskStepSizeForLoggingAdditionalDiagnostics == 0L) {
            this.appendAdditionalDiagnosticsIfNecessary(stringBuilder);
        }
        _logger.warn((Object)stringBuilder.toString());
    }

    private void appendAdditionalDiagnosticsIfNecessary(StringBuilder stringBuilder) {
        block2: {
            long l;
            long l2;
            boolean bl;
            if (this._minNanosApartForLoggingAdditionalDiagnostics < 0L) {
                return;
            }
            do {
                l2 = this._nanoTimeOfLatestLoggingOfDelayedTasks.get();
                l = System.nanoTime();
                if (l < l2 + this._minNanosApartForLoggingAdditionalDiagnostics) break block2;
            } while (!(bl = this._nanoTimeOfLatestLoggingOfDelayedTasks.compareAndSet(l2, l)));
            Collection<TaskDescriptor> collection = this.getCurrentlyExecutingTasks();
            stringBuilder.append("\nCurrently executing tasks: ").append(collection);
        }
    }

    private void logSubmittedTask(String string) {
        this._tasksSubmitted.incrementAndGet();
        if (!this._loggingEnabled || !_logger.isDebugEnabled()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" accepting task# ");
        stringBuilder.append(string);
        _logger.debug((Object)stringBuilder.toString());
    }

    private void logRanExpiredTaskInCallerThread(ExpiringTask<?> expiringTask, Exception exception) {
        this._tasksRunByCaller.incrementAndGet();
        if (!this._loggingEnabled) {
            return;
        }
        long l = System.nanoTime();
        long l2 = l - expiringTask.getSubmissionTime();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" ran expired task# ");
        stringBuilder.append(expiringTask.getLabel());
        stringBuilder.append(" (").append(expiringTask.toString()).append(')');
        stringBuilder.append(" in calling thread after ");
        stringBuilder.append(TimeUnit.NANOSECONDS.toSeconds(l2));
        stringBuilder.append(" sec.");
        if (exception != null) {
            stringBuilder.append(" The task threw an exception: ").append(exception.toString());
        }
        _logger.warn((Object)stringBuilder.toString());
    }

    private void logQueueHitNewMax(int n) {
        if (!this._loggingEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" hit new max size: ");
        stringBuilder.append(n);
        _logger.info((Object)stringBuilder.toString());
    }

    private void logWorkersHitNewMax(int n) {
        if (!this._loggingEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._label);
        stringBuilder.append(" workers hit new max size: ");
        stringBuilder.append(n);
        _logger.info((Object)stringBuilder.toString());
    }

    private void printStats() {
        if (!this._loggingEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("stats for pool : ");
        stringBuilder.append(this._label);
        stringBuilder.append("\nTasks submitted: ");
        stringBuilder.append(this._tasksSubmitted.get());
        stringBuilder.append("\nTasks run by workers: ");
        stringBuilder.append(this._tasksRunByWorkPool.get());
        stringBuilder.append("\nTasks expired: ");
        stringBuilder.append(this._tasksExpired.get());
        stringBuilder.append("\nAverage wait time before running (micro-sec): ");
        long l = this._tasksRunByWorkPool.get();
        if (l > 0L) {
            long l2 = this._taskWaitTimeInMicroSecs.get() / l;
            stringBuilder.append(l2);
        }
        stringBuilder.append("\nCaller-run tasks: ");
        stringBuilder.append(this._tasksRunByCaller.get());
        stringBuilder.append("\nMax queue-size reached: ");
        stringBuilder.append(this._largestObservedQueueSize.get());
        stringBuilder.append("\nLargest work-queue size: ");
        stringBuilder.append(this._largestNumberOfWorkerThreads.get());
        _logger.info((Object)stringBuilder.toString());
    }

    private void logIfWaitingThresholdIsExceeded(ExpiringTask<?> expiringTask) {
        long l = System.nanoTime() - expiringTask.getSubmissionTime();
        if (this._isLoggingOfAdditionalDiagnosticsEnabled && Config.THREAD_POOL_LOG_CURR_EXEC_TASKS_ENABLED && this._queueWaitTimeThresholdNanos > 0L && l > this._queueWaitTimeThresholdNanos) {
            StringBuilder stringBuilder = new StringBuilder(150);
            stringBuilder.append(this._label).append(": A task waited too long to be executed: ").append(TimeUnit.NANOSECONDS.toMillis(l)).append(" ms, task# ").append(expiringTask.getLabel()).append(", ").append(expiringTask.toString());
            long l2 = this._longWaitCounter.getAndIncrement();
            if (l2 % (long)this._delayedTaskStepSizeForLoggingAdditionalDiagnostics == 0L) {
                this.appendAdditionalDiagnosticsIfNecessary(stringBuilder);
            }
            _logger.warn((Object)stringBuilder.toString());
        }
    }

    @Nullable
    private static String identityHashCode(Object object) {
        if (object == null) {
            return null;
        }
        String string = Integer.toHexString(System.identityHashCode(object));
        return string;
    }

    @Override
    public String getName() {
        return this._poolName;
    }

    public String toString() {
        return this._executor.getThreadFactory().toString();
    }

    public static enum TaskExpirationPolicy {
        CALLER_RUNS,
        CANCEL;

    }

    private class ExpiringTask<T>
    extends FutureTask<T>
    implements Comparable<ExpiringTask<T>> {
        private final SettableFuture<Boolean> _taskStarted;
        private final AtomicBoolean _expirationHandled;
        private final String _label;
        private final Long _groupId;
        private final long _submissionTime;
        private final long _expirationTime;
        private final Callable<T> _actualTask;
        private volatile long _executionStartNanoTime;

        ExpiringTask(Callable<T> callable, String string, long l, long l2, long l3) {
            super(callable);
            this._taskStarted = SettableFuture.create();
            this._expirationHandled = new AtomicBoolean(false);
            this._label = string;
            this._groupId = l;
            this._submissionTime = l2;
            this._expirationTime = l3;
            this._actualTask = callable;
            this._executionStartNanoTime = -1L;
        }

        String getLabel() {
            return this._label;
        }

        long getSubmissionTime() {
            return this._submissionTime;
        }

        void setExecutionStartNanoTime(long l) {
            this._executionStartNanoTime = l;
        }

        long getExecutionStartNanoTime() {
            return this._executionStartNanoTime;
        }

        boolean isPastExirationTime() {
            return System.nanoTime() >= this._expirationTime;
        }

        boolean signalWaiters(boolean bl) {
            boolean bl2 = this._taskStarted.set((Object)bl);
            if (bl2 && !bl) {
                QueuingCachedThreadPool.this.logExpiredTask(this);
            }
            return bl2;
        }

        private void handleIfExpired() throws InterruptedException {
            try {
                boolean bl;
                if (this._taskStarted.isDone()) {
                    boolean bl2 = (Boolean)this._taskStarted.get();
                    if (!bl2) {
                        this.handleExpiredTaskIfNotHandledYet();
                    }
                    return;
                }
                long l = this._expirationTime - System.nanoTime();
                try {
                    bl = (Boolean)this._taskStarted.get(l, TimeUnit.NANOSECONDS);
                }
                catch (TimeoutException timeoutException) {
                    QueuingCachedThreadPool.this._executionManager.removeTaskFromQueue(this);
                    boolean bl3 = this.signalWaiters(false);
                    bl = bl3 ? false : (Boolean)this._taskStarted.get();
                }
                if (!bl) {
                    this.handleExpiredTaskIfNotHandledYet();
                }
            }
            catch (ExecutionException executionException) {
                throw new IllegalStateException("Cannot happen with SettableFuture.");
            }
        }

        private boolean waitUntilRunOrExpired(long l) throws InterruptedException {
            try {
                if (this._taskStarted.isDone()) {
                    boolean bl = (Boolean)this._taskStarted.get();
                    return !bl;
                }
                long l2 = this._expirationTime - System.nanoTime();
                if (l < l2) {
                    l2 = l;
                }
                try {
                    Boolean bl = (Boolean)this._taskStarted.get(l2, TimeUnit.NANOSECONDS);
                    if (bl.booleanValue()) {
                        return false;
                    }
                    boolean bl2 = System.nanoTime() >= this._expirationTime;
                    return bl2;
                }
                catch (TimeoutException timeoutException) {
                    boolean bl = System.nanoTime() >= this._expirationTime;
                    return bl;
                }
            }
            catch (ExecutionException executionException) {
                throw new IllegalStateException("cannot happen.");
            }
        }

        private void handleExpiredTaskIfNotHandledYet() {
            if (QueuingCachedThreadPool.this._taskExpirationPolicy == TaskExpirationPolicy.CALLER_RUNS) {
                boolean bl = this._expirationHandled.getAndSet(true);
                if (!bl) {
                    RuntimeException runtimeException = null;
                    try {
                        this.run();
                    }
                    catch (RuntimeException runtimeException2) {
                        runtimeException = runtimeException2;
                        throw runtimeException2;
                    }
                    finally {
                        QueuingCachedThreadPool.this.logRanExpiredTaskInCallerThread(this, runtimeException);
                    }
                }
            } else if (QueuingCachedThreadPool.this._taskExpirationPolicy == TaskExpirationPolicy.CANCEL) {
                boolean bl = this._expirationHandled.getAndSet(true);
                if (!bl) {
                    super.cancel(true);
                }
                throw new ExpirationException();
            }
        }

        @Override
        public T get() throws ExecutionException, InterruptedException {
            this.handleIfExpired();
            Object v = super.get();
            return (T)v;
        }

        @Override
        public T get(long l, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
            long l2 = System.nanoTime();
            long l3 = TimeUnit.NANOSECONDS.convert(l, timeUnit);
            boolean bl = this.waitUntilRunOrExpired(l3);
            long l4 = System.nanoTime() - l2;
            if (bl) {
                QueuingCachedThreadPool.this._executionManager.removeTaskFromQueue(this);
                boolean bl2 = this.signalWaiters(false);
                if (bl2 || !((Boolean)this._taskStarted.get()).booleanValue()) {
                    this.handleExpiredTaskIfNotHandledYet();
                }
            }
            Object v = super.get(l3 - l4, TimeUnit.NANOSECONDS);
            return (T)v;
        }

        @Override
        public int compareTo(ExpiringTask<T> expiringTask) {
            if (expiringTask == null) {
                throw new NullPointerException("Null tasks should not be queued.");
            }
            return this._groupId.compareTo(expiringTask._groupId);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "@" + QueuingCachedThreadPool.identityHashCode(this) + ": " + this._actualTask.toString();
        }
    }

    private class QueueProcessor
    implements Runnable {
        private volatile ExpiringTask<?> _task;

        QueueProcessor(ExpiringTask<?> expiringTask) {
            this._task = expiringTask;
            if (QueuingCachedThreadPool.this._loggingEnabled) {
                int n = QueuingCachedThreadPool.this._workerThreadCounter.incrementAndGet();
                boolean bl = AtomicUtil.updateIfGreater(QueuingCachedThreadPool.this._largestNumberOfWorkerThreads, n);
                if (bl) {
                    QueuingCachedThreadPool.this.logWorkersHitNewMax(n);
                }
            }
        }

        @Override
        public void run() {
            QueuingCachedThreadPool.this.logRanTask(this._task);
            ExpiringTask<?> expiringTask = this._task;
            while (expiringTask != null) {
                try {
                    if (!expiringTask.isPastExirationTime()) {
                        boolean bl = expiringTask.signalWaiters(true);
                        if (bl) {
                            QueuingCachedThreadPool.this.logIfWaitingThresholdIsExceeded(expiringTask);
                            expiringTask.setExecutionStartNanoTime(System.nanoTime());
                            expiringTask.run();
                            continue;
                        }
                        _logger.info((Object)("A task's state was set by some other thread: " + expiringTask + ".  That other thread will handle the task."));
                        continue;
                    }
                    expiringTask.signalWaiters(false);
                }
                finally {
                    expiringTask = QueuingCachedThreadPool.this._executionManager.getNextTaskFromQueueOrRetireWorker(this);
                    if (expiringTask == null) {
                        if (QueuingCachedThreadPool.this._loggingEnabled) {
                            QueuingCachedThreadPool.this._workerThreadCounter.decrementAndGet();
                        }
                        continue;
                    }
                    this._task = expiringTask;
                }
            }
        }

        public String toString() {
            ExpiringTask<?> expiringTask = this._task;
            return QueueProcessor.class.getSimpleName() + ": " + (expiringTask != null ? expiringTask.toString() : "[null]");
        }
    }

    private class ExecutionManager {
        private final int _maxThreads;
        private final Lock _lock = new ReentrantLock();
        @GuardedBy(value="_lock")
        private int _workerThreads = 0;
        @GuardedBy(value="_lock")
        private final PriorityQueue<ExpiringTask<?>> _queue = new PriorityQueue();
        private final Set<QueueProcessor> _workers;

        ExecutionManager(int n) {
            this._maxThreads = n;
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            this._workers = Collections.newSetFromMap(concurrentHashMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processNewTask(ExpiringTask<?> expiringTask) {
            boolean bl;
            int n;
            long l;
            LinkedList linkedList;
            ArrayList arrayList;
            block16: {
                boolean bl2;
                arrayList = new ArrayList(1);
                linkedList = new LinkedList();
                l = 0L;
                n = 0;
                if (QueuingCachedThreadPool.this._loggingEnabled) {
                    l = System.nanoTime();
                }
                this._lock.lock();
                if (this._workerThreads >= this._maxThreads || !this._queue.isEmpty()) break block16;
                ++this._workerThreads;
                arrayList.add(expiringTask);
                this._lock.unlock();
                QueuingCachedThreadPool.this.logPoolManagementTime(expiringTask, l);
                for (ExpiringTask expiringTask2 : arrayList) {
                    QueueProcessor queueProcessor = new QueueProcessor(expiringTask2);
                    this._workers.add(queueProcessor);
                    QueuingCachedThreadPool.this._executor.submit(queueProcessor);
                }
                for (ExpiringTask expiringTask2 : linkedList) {
                    expiringTask2.signalWaiters(false);
                }
                if (QueuingCachedThreadPool.this._loggingEnabled && n > 0 && (bl2 = AtomicUtil.updateIfGreater(QueuingCachedThreadPool.this._largestObservedQueueSize, n))) {
                    QueuingCachedThreadPool.this.logQueueHitNewMax(n);
                }
                return;
            }
            try {
                this.removeExpiredTasksInternal(linkedList);
                while (this._workerThreads < this._maxThreads && !this._queue.isEmpty()) {
                    arrayList.add(this._queue.poll());
                    ++this._workerThreads;
                }
                if (this._workerThreads < this._maxThreads) {
                    arrayList.add(expiringTask);
                    ++this._workerThreads;
                } else {
                    this._queue.add(expiringTask);
                }
                n = this._queue.size();
                this._lock.unlock();
            }
            catch (Throwable throwable) {
                boolean bl3;
                this._lock.unlock();
                QueuingCachedThreadPool.this.logPoolManagementTime(expiringTask, l);
                for (ExpiringTask expiringTask3 : arrayList) {
                    QueueProcessor queueProcessor = new QueueProcessor(expiringTask3);
                    this._workers.add(queueProcessor);
                    QueuingCachedThreadPool.this._executor.submit(queueProcessor);
                }
                for (ExpiringTask expiringTask3 : linkedList) {
                    expiringTask3.signalWaiters(false);
                }
                if (QueuingCachedThreadPool.this._loggingEnabled && n > 0 && (bl3 = AtomicUtil.updateIfGreater(QueuingCachedThreadPool.this._largestObservedQueueSize, n))) {
                    QueuingCachedThreadPool.this.logQueueHitNewMax(n);
                }
                throw throwable;
            }
            QueuingCachedThreadPool.this.logPoolManagementTime(expiringTask, l);
            for (ExpiringTask expiringTask4 : arrayList) {
                QueueProcessor queueProcessor = new QueueProcessor(expiringTask4);
                this._workers.add(queueProcessor);
                QueuingCachedThreadPool.this._executor.submit(queueProcessor);
            }
            for (ExpiringTask expiringTask5 : linkedList) {
                expiringTask5.signalWaiters(false);
            }
            if (QueuingCachedThreadPool.this._loggingEnabled && n > 0 && (bl = AtomicUtil.updateIfGreater(QueuingCachedThreadPool.this._largestObservedQueueSize, n))) {
                QueuingCachedThreadPool.this.logQueueHitNewMax(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ExpiringTask<?> getNextTaskFromQueueOrRetireWorker(QueueProcessor queueProcessor) {
            this._lock.lock();
            try {
                ExpiringTask<?> expiringTask = this._queue.poll();
                if (expiringTask == null) {
                    --this._workerThreads;
                    this._workers.remove(queueProcessor);
                }
                ExpiringTask<?> expiringTask2 = expiringTask;
                return expiringTask2;
            }
            finally {
                this._lock.unlock();
            }
        }

        void drainQueue(Collection<Runnable> collection) {
            this._lock.lock();
            try {
                while (!this._queue.isEmpty()) {
                    collection.add((Runnable)this._queue.remove());
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        boolean removeTaskFromQueue(ExpiringTask<?> expiringTask) {
            boolean bl = false;
            this._lock.lock();
            try {
                bl = this._queue.remove(expiringTask);
            }
            finally {
                this._lock.unlock();
            }
            return bl;
        }

        @GuardedBy(value="_lock")
        private void removeExpiredTasksInternal(Collection<ExpiringTask<?>> collection) {
            for (ExpiringTask<?> expiringTask : this._queue) {
                if (!expiringTask.isPastExirationTime()) continue;
                collection.add(expiringTask);
            }
            this._queue.removeAll(collection);
        }

        Collection<TaskDescriptor> getCurrentlyExecutingTasks() {
            List<TaskDescriptor> list = null;
            for (QueueProcessor queueProcessor : this._workers) {
                ExpiringTask expiringTask = queueProcessor._task;
                if (expiringTask == null) continue;
                long l = System.nanoTime() - expiringTask.getExecutionStartNanoTime();
                if (list == null) {
                    list = new ArrayList<TaskDescriptor>();
                }
                list.add(new TaskDescriptor(expiringTask, l));
            }
            if (list == null) {
                list = Collections.emptyList();
            }
            return list;
        }
    }

    private static class InvokeAnyResult<T> {
        final T computationResult;
        final Exception exception;

        InvokeAnyResult(T t, Exception exception) {
            this.computationResult = t;
            this.exception = exception;
        }
    }
}

