/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.google.common.base.Ticker;
import com.vmware.vise.util.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SingleRunner<T> {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Nonnull
    private final Callable<T> _callable;
    @Nonnull
    private final CacheType _cacheType;
    private final long _expireAfterNanos;
    @Nullable
    private final ExecutorService _execSvc;
    private final boolean _cancelTaskOnTimeout;
    @Nullable
    private final TaskIsAlreadyRunningListener _taskIsAlreadyRunningListener;
    private final Ticker _ticker;
    private final Lock _execSubmissionLock = new ReentrantLock();
    @Nullable
    private volatile AtomicReference<ExpirableFuture<T>> _taskRef = new AtomicReference<Object>(null);

    private SingleRunner(@Nonnull Callable<T> callable, @Nonnull CacheType cacheType, long l, @Nullable ExecutorService executorService, boolean bl, @Nonnull Ticker ticker, @Nullable TaskIsAlreadyRunningListener taskIsAlreadyRunningListener) {
        Validate.notNull(callable);
        this._callable = callable;
        this._cacheType = cacheType;
        this._expireAfterNanos = l;
        this._execSvc = executorService;
        this._cancelTaskOnTimeout = bl;
        this._taskIsAlreadyRunningListener = taskIsAlreadyRunningListener;
        this._ticker = ticker;
    }

    public static <T> Builder<T> newBuilder(@Nonnull Callable<T> callable) {
        Validate.notNull(callable);
        return new Builder<T>(callable);
    }

    public T get() throws ExecutionException, InterruptedException {
        return this.get(false);
    }

    public T get(boolean bl) throws ExecutionException, InterruptedException {
        try {
            return this.get(-1L, null, null, bl);
        }
        catch (TimeoutException timeoutException) {
            throw new ExecutionException(timeoutException);
        }
    }

    public T get(long l, @Nullable TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        return this.get(l, timeUnit, null, false);
    }

    public T get(long l, @Nullable TimeUnit timeUnit, @Nullable ExecutorService executorService) throws ExecutionException, InterruptedException, TimeoutException {
        return this.get(l, timeUnit, executorService, false);
    }

    public T get(long l, @Nullable TimeUnit timeUnit, boolean bl) throws ExecutionException, InterruptedException, TimeoutException {
        return this.get(l, timeUnit, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long l, @Nullable TimeUnit timeUnit, @Nullable ExecutorService executorService, boolean bl) throws ExecutionException, InterruptedException, TimeoutException {
        ExecutorService executorService2;
        Object object;
        block16: {
            Object object2;
            block17: {
                boolean bl2;
                do {
                    object = this._taskRef.get();
                    if (!bl && this.isSuitableTask((ExpirableFuture<T>)object)) break block16;
                    executorService2 = null;
                    if (executorService != null && !executorService.isShutdown()) {
                        executorService2 = executorService;
                    } else if (this._execSvc != null && !this._execSvc.isShutdown()) {
                        executorService2 = this._execSvc;
                    }
                    if (l > 0L && timeUnit != null && executorService2 != null) break block17;
                } while (!(bl2 = this._taskRef.compareAndSet((ExpirableFuture<T>)object, (ExpirableFuture<T>)(object2 = new ExpirableFutureTask<T>(this._callable)))));
                if (l > 0L && timeUnit != null) {
                    _logger.warn((Object)("A timeout was specified, but there's no " + ExecutorService.class.getSimpleName() + " that can be used, so the current thread will run the task without a timeout"));
                }
                object = object2;
                ((ExpirableFutureTask)object2).run();
                if (this._cacheType == CacheType.DO_NOT_CACHE || this._cacheType == CacheType.EXPIRE_AFTER_START && object.isExpired()) {
                    this._taskRef.compareAndSet((ExpirableFuture<T>)object2, (ExpirableFuture<T>)null);
                }
                break block16;
            }
            object2 = new CallableWithExpirationPoint(this._callable);
            this._execSubmissionLock.lock();
            try {
                object = this._taskRef.get();
                if (!this.isSuitableTask((ExpirableFuture<T>)object)) {
                    Future future = executorService2.submit(object2);
                    object = new FutureAndCallableWithExpirationPoint((CallableWithExpirationPoint)object2, future);
                }
            }
            finally {
                this._execSubmissionLock.unlock();
            }
        }
        if (l < 0L || timeUnit == null) {
            executorService2 = object.get();
        } else {
            try {
                executorService2 = object.get(l, timeUnit);
            }
            catch (TimeoutException timeoutException) {
                if (this._cancelTaskOnTimeout) {
                    object.cancel(true);
                    this._taskRef.compareAndSet((ExpirableFuture<T>)object, (ExpirableFuture<T>)null);
                }
                throw timeoutException;
            }
        }
        return (T)executorService2;
    }

    private boolean isSuitableTask(ExpirableFuture<T> expirableFuture) {
        if (expirableFuture == null || expirableFuture.isDone() && expirableFuture.isExpired()) {
            return false;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("A task is running. Will wait for its result. (" + this._callable + ")"));
        }
        if (this._taskIsAlreadyRunningListener != null) {
            this._taskIsAlreadyRunningListener.willWaitForTaskWhichIsAlreadyRunning();
        }
        return true;
    }

    public void clearCache() {
        this._taskRef.set(null);
    }

    public boolean isCachedResultAvailable() {
        ExpirableFuture<T> expirableFuture = this._taskRef.get();
        if (expirableFuture == null) {
            return false;
        }
        boolean bl = expirableFuture.isDone() && !expirableFuture.isExpired();
        return bl;
    }

    @VisibleForTesting
    Future<T> getCurrentFuture() {
        ExpirableFuture<T> expirableFuture = this._taskRef.get();
        return expirableFuture;
    }

    @VisibleForTesting
    static interface TaskIsAlreadyRunningListener {
        public void willWaitForTaskWhichIsAlreadyRunning();
    }

    private static enum CacheType {
        DO_NOT_CACHE,
        NEVER_EXPIRE,
        EXPIRE_AFTER_START,
        EXPIRE_AFTER_DONE;

    }

    public static class Builder<T> {
        private Callable<T> _callable;
        private CacheType _cacheType = CacheType.DO_NOT_CACHE;
        private long _expireAfterNanos;
        private ExecutorService _execSvc;
        private boolean _cancelTaskOnTimeout;
        private TaskIsAlreadyRunningListener _taskIsAlreadyRunningListener;
        private Ticker _ticker = Ticker.systemTicker();

        public Builder(@Nonnull Callable<T> callable) {
            Validate.notNull(callable);
            this._callable = callable;
        }

        public Builder<T> cacheAndNeverExpire() {
            this._cacheType = CacheType.NEVER_EXPIRE;
            return this;
        }

        public Builder<T> cacheAndExpireAfterStart(@Nonnegative long l, @Nonnull TimeUnit timeUnit) {
            Validate.isTrue((l > 0L ? 1 : 0) != 0);
            Validate.notNull((Object)((Object)timeUnit));
            this._cacheType = CacheType.EXPIRE_AFTER_START;
            this._expireAfterNanos = timeUnit.toNanos(l);
            return this;
        }

        public Builder<T> cacheAndExpireAfterDone(@Nonnegative long l, @Nonnull TimeUnit timeUnit) {
            Validate.isTrue((l > 0L ? 1 : 0) != 0);
            Validate.notNull((Object)((Object)timeUnit));
            this._cacheType = CacheType.EXPIRE_AFTER_DONE;
            this._expireAfterNanos = timeUnit.toNanos(l);
            return this;
        }

        public Builder<T> executorService(@Nullable ExecutorService executorService) {
            this._execSvc = executorService;
            return this;
        }

        public Builder<T> cancelTaskOnTimeout(boolean bl) {
            this._cancelTaskOnTimeout = bl;
            return this;
        }

        @VisibleForTesting
        Builder<T> ticker(@Nonnull Ticker ticker) {
            Validate.notNull((Object)ticker);
            this._ticker = ticker;
            return this;
        }

        @VisibleForTesting
        Builder<T> taskIsAlreadyRunningListener(@Nullable TaskIsAlreadyRunningListener taskIsAlreadyRunningListener) {
            this._taskIsAlreadyRunningListener = taskIsAlreadyRunningListener;
            return this;
        }

        public SingleRunner<T> build() {
            return new SingleRunner(this._callable, this._cacheType, this._expireAfterNanos, this._execSvc, this._cancelTaskOnTimeout, this._ticker, this._taskIsAlreadyRunningListener);
        }
    }

    private class ExpirableFutureTask<V>
    extends FutureTask<V>
    implements ExpirableFuture<V> {
        private volatile long _expirationPointNanos;

        public ExpirableFutureTask(Callable<V> callable) {
            super(callable);
        }

        @Override
        public void run() {
            if (SingleRunner.this._cacheType == CacheType.EXPIRE_AFTER_START) {
                this._expirationPointNanos = SingleRunner.this._ticker.read() + SingleRunner.this._expireAfterNanos;
            }
            super.run();
        }

        @Override
        protected void done() {
            if (SingleRunner.this._cacheType == CacheType.EXPIRE_AFTER_DONE) {
                this._expirationPointNanos = SingleRunner.this._ticker.read() + SingleRunner.this._expireAfterNanos;
            }
        }

        @Override
        public boolean isExpired() {
            long l = this._expirationPointNanos;
            boolean bl = l > 0L && l <= SingleRunner.this._ticker.read();
            return bl;
        }
    }

    private class FutureAndCallableWithExpirationPoint
    implements ExpirableFuture<T> {
        private final CallableWithExpirationPoint _task;
        private final Future<T> _future;

        FutureAndCallableWithExpirationPoint(CallableWithExpirationPoint callableWithExpirationPoint, Future<T> future) {
            this._task = callableWithExpirationPoint;
            this._future = future;
        }

        @Override
        public boolean cancel(boolean bl) {
            return this._future.cancel(bl);
        }

        @Override
        public boolean isCancelled() {
            return this._future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this._future.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this._future.get();
        }

        @Override
        public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this._future.get(l, timeUnit);
        }

        @Override
        public boolean isExpired() {
            long l = this._task.getExpirationPoint();
            boolean bl = l > 0L && l <= SingleRunner.this._ticker.read();
            return bl;
        }
    }

    @Immutable
    private class CallableWithExpirationPoint
    implements Callable<T> {
        private volatile long _expirationPointNanos;
        private final Callable<T> _delegate;

        CallableWithExpirationPoint(Callable<T> callable) {
            this._delegate = callable;
        }

        @Override
        public T call() throws Exception {
            if (SingleRunner.this._cacheType == CacheType.EXPIRE_AFTER_START) {
                this._expirationPointNanos = SingleRunner.this._ticker.read() + SingleRunner.this._expireAfterNanos;
            }
            try {
                Object t = this._delegate.call();
                return t;
            }
            finally {
                if (SingleRunner.this._cacheType == CacheType.EXPIRE_AFTER_DONE) {
                    this._expirationPointNanos = SingleRunner.this._ticker.read() + SingleRunner.this._expireAfterNanos;
                }
            }
        }

        public long getExpirationPoint() {
            return this._expirationPointNanos;
        }
    }

    private static interface ExpirableFuture<T>
    extends Future<T> {
        public boolean isExpired();
    }
}

