/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;

public class TaskDescriptor {
    private final Runnable _runnable;
    private final long _startTimeNanos;

    public TaskDescriptor(Runnable runnable, long l) {
        Validate.notNull((Object)runnable);
        this._runnable = runnable;
        this._startTimeNanos = l;
    }

    public Runnable getRunnable() {
        return this._runnable;
    }

    public long getStartTimeNanos() {
        return this._startTimeNanos;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof TaskDescriptor) {
            TaskDescriptor taskDescriptor = (TaskDescriptor)object;
            return this._runnable == taskDescriptor._runnable;
        }
        return false;
    }

    public int hashCode() {
        return this._runnable.hashCode();
    }

    public String toString() {
        long l = System.nanoTime() - this._startTimeNanos;
        return "(" + this._runnable.toString() + ", elapsedTime:" + TimeUnit.NANOSECONDS.toMillis(l) + " ms)";
    }
}

